/*
 * This declarations of the PIC16F685 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2014.
 *
 * This file is generated automatically by the cinc2h.pl, 2014-09-15 14:38:39 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16F685_H__
#define __PIC16F685_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF_ADDR               0x0000
#define TMR0_ADDR               0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR_ADDR                0x0004
#define PORTA_ADDR              0x0005
#define PORTB_ADDR              0x0006
#define PORTC_ADDR              0x0007
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PIR1_ADDR               0x000C
#define PIR2_ADDR               0x000D
#define TMR1_ADDR               0x000E
#define TMR1L_ADDR              0x000E
#define TMR1H_ADDR              0x000F
#define T1CON_ADDR              0x0010
#define TMR2_ADDR               0x0011
#define T2CON_ADDR              0x0012
#define CCPR1_ADDR              0x0015
#define CCPR1L_ADDR             0x0015
#define CCPR1H_ADDR             0x0016
#define CCP1CON_ADDR            0x0017
#define PWM1CON_ADDR            0x001C
#define ECCPAS_ADDR             0x001D
#define ADRESH_ADDR             0x001E
#define ADCON0_ADDR             0x001F
#define OPTION_REG_ADDR         0x0081
#define TRISA_ADDR              0x0085
#define TRISB_ADDR              0x0086
#define TRISC_ADDR              0x0087
#define PIE1_ADDR               0x008C
#define PIE2_ADDR               0x008D
#define PCON_ADDR               0x008E
#define OSCCON_ADDR             0x008F
#define OSCTUNE_ADDR            0x0090
#define PR2_ADDR                0x0092
#define WPU_ADDR                0x0095
#define WPUA_ADDR               0x0095
#define IOC_ADDR                0x0096
#define IOCA_ADDR               0x0096
#define WDTCON_ADDR             0x0097
#define ADRESL_ADDR             0x009E
#define ADCON1_ADDR             0x009F
#define EEDAT_ADDR              0x010C
#define EEDATA_ADDR             0x010C
#define EEADR_ADDR              0x010D
#define EEDATH_ADDR             0x010E
#define EEADRH_ADDR             0x010F
#define WPUB_ADDR               0x0115
#define IOCB_ADDR               0x0116
#define VRCON_ADDR              0x0118
#define CM1CON0_ADDR            0x0119
#define CM2CON0_ADDR            0x011A
#define CM2CON1_ADDR            0x011B
#define ANSEL_ADDR              0x011E
#define ANSELH_ADDR             0x011F
#define EECON1_ADDR             0x018C
#define EECON2_ADDR             0x018D
#define PSTRCON_ADDR            0x019D
#define SRCON_ADDR              0x019E

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF;
extern __at(0x0001) __sfr TMR0;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef union
  {
  struct
    {
    unsigned C                  : 1;
    unsigned DC                 : 1;
    unsigned Z                  : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned RP0                : 1;
    unsigned RP1                : 1;
    unsigned IRP                : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned RP                 : 2;
    unsigned                    : 1;
    };
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10
#define _RP0                    0x20
#define _RP1                    0x40
#define _IRP                    0x80

//==============================================================================

extern __at(0x0004) __sfr FSR;

//==============================================================================
//        PORTA Bits

extern __at(0x0005) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 6;
    unsigned                    : 2;
    };
  } __PORTAbits_t;

extern __at(0x0005) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0006) __sfr PORTB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x0006) volatile __PORTBbits_t PORTBbits;

#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0007) __sfr PORTC;

typedef struct
  {
  unsigned RC0                  : 1;
  unsigned RC1                  : 1;
  unsigned RC2                  : 1;
  unsigned RC3                  : 1;
  unsigned RC4                  : 1;
  unsigned RC5                  : 1;
  unsigned RC6                  : 1;
  unsigned RC7                  : 1;
  } __PORTCbits_t;

extern __at(0x0007) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20
#define _RC6                    0x40
#define _RC7                    0x80

//==============================================================================

extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef struct
  {
  unsigned RABIF                : 1;
  unsigned INTF                 : 1;
  unsigned T0IF                 : 1;
  unsigned RABIE                : 1;
  unsigned INTE                 : 1;
  unsigned T0IE                 : 1;
  unsigned PEIE                 : 1;
  unsigned GIE                  : 1;
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _RABIF                  0x01
#define _INTF                   0x02
#define _T0IF                   0x04
#define _RABIE                  0x08
#define _INTE                   0x10
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x000C) __sfr PIR1;

typedef union
  {
  struct
    {
    unsigned TMR1IF             : 1;
    unsigned TMR2IF             : 1;
    unsigned CCP1IF             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADIF               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1IF               : 1;
    unsigned T2IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR1bits_t;

extern __at(0x000C) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _T1IF                   0x01
#define _TMR2IF                 0x02
#define _T2IF                   0x02
#define _CCP1IF                 0x04
#define _ADIF                   0x40

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x000D) __sfr PIR2;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned EEIF                 : 1;
  unsigned C1IF                 : 1;
  unsigned C2IF                 : 1;
  unsigned OSFIF                : 1;
  } __PIR2bits_t;

extern __at(0x000D) volatile __PIR2bits_t PIR2bits;

#define _EEIF                   0x10
#define _C1IF                   0x20
#define _C2IF                   0x40
#define _OSFIF                  0x80

//==============================================================================

extern __at(0x000E) __sfr TMR1;
extern __at(0x000E) __sfr TMR1L;
extern __at(0x000F) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0010) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned TMR1CS             : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1GE             : 1;
    unsigned T1GINV             : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };
  } __T1CONbits_t;

extern __at(0x0010) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _TMR1CS                 0x02
#define _NOT_T1SYNC             0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1GE                 0x40
#define _T1GINV                 0x80

//==============================================================================

extern __at(0x0011) __sfr TMR2;

//==============================================================================
//        T2CON Bits

extern __at(0x0012) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned TOUTPS0            : 1;
    unsigned TOUTPS1            : 1;
    unsigned TOUTPS2            : 1;
    unsigned TOUTPS3            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned TOUTPS             : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0012) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _TOUTPS0                0x08
#define _TOUTPS1                0x10
#define _TOUTPS2                0x20
#define _TOUTPS3                0x40

//==============================================================================

extern __at(0x0015) __sfr CCPR1;
extern __at(0x0015) __sfr CCPR1L;
extern __at(0x0016) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0017) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned P1M0               : 1;
    unsigned P1M1               : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P1M                : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0017) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _DC1B1                  0x20
#define _P1M0                   0x40
#define _P1M1                   0x80

//==============================================================================


//==============================================================================
//        PWM1CON Bits

extern __at(0x001C) __sfr PWM1CON;

typedef union
  {
  struct
    {
    unsigned PDC0               : 1;
    unsigned PDC1               : 1;
    unsigned PDC2               : 1;
    unsigned PDC3               : 1;
    unsigned PDC4               : 1;
    unsigned PDC5               : 1;
    unsigned PDC6               : 1;
    unsigned PRSEN              : 1;
    };

  struct
    {
    unsigned PDC                : 7;
    unsigned                    : 1;
    };
  } __PWM1CONbits_t;

extern __at(0x001C) volatile __PWM1CONbits_t PWM1CONbits;

#define _PDC0                   0x01
#define _PDC1                   0x02
#define _PDC2                   0x04
#define _PDC3                   0x08
#define _PDC4                   0x10
#define _PDC5                   0x20
#define _PDC6                   0x40
#define _PRSEN                  0x80

//==============================================================================


//==============================================================================
//        ECCPAS Bits

extern __at(0x001D) __sfr ECCPAS;

typedef union
  {
  struct
    {
    unsigned PSSBD0             : 1;
    unsigned PSSBD1             : 1;
    unsigned PSSAC0             : 1;
    unsigned PSSAC1             : 1;
    unsigned ECCPAS0            : 1;
    unsigned ECCPAS1            : 1;
    unsigned ECCPAS2            : 1;
    unsigned ECCPASE            : 1;
    };

  struct
    {
    unsigned PSSBD              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSSAC              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCPAS             : 3;
    unsigned                    : 1;
    };
  } __ECCPASbits_t;

extern __at(0x001D) volatile __ECCPASbits_t ECCPASbits;

#define _PSSBD0                 0x01
#define _PSSBD1                 0x02
#define _PSSAC0                 0x04
#define _PSSAC1                 0x08
#define _ECCPAS0                0x10
#define _ECCPAS1                0x20
#define _ECCPAS2                0x40
#define _ECCPASE                0x80

//==============================================================================

extern __at(0x001E) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x001F) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned VCFG               : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_DONE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 4;
    unsigned                    : 2;
    };
  } __ADCON0bits_t;

extern __at(0x001F) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _GO                     0x02
#define _NOT_DONE               0x02
#define _GO_DONE                0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _VCFG                   0x40
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0081) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_RABPU          : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0081) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_RABPU              0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0085) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISA              : 6;
    unsigned                    : 2;
    };
  } __TRISAbits_t;

extern __at(0x0085) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0086) __sfr TRISB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x0086) volatile __TRISBbits_t TRISBbits;

#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0087) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x0087) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x008C) __sfr PIE1;

typedef union
  {
  struct
    {
    unsigned TMR1IE             : 1;
    unsigned TMR2IE             : 1;
    unsigned CCP1IE             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADIE               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1IE               : 1;
    unsigned T2IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE1bits_t;

extern __at(0x008C) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _T1IE                   0x01
#define _TMR2IE                 0x02
#define _T2IE                   0x02
#define _CCP1IE                 0x04
#define _ADIE                   0x40

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x008D) __sfr PIE2;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned EEIE                 : 1;
  unsigned C1IE                 : 1;
  unsigned C2IE                 : 1;
  unsigned OSFIE                : 1;
  } __PIE2bits_t;

extern __at(0x008D) volatile __PIE2bits_t PIE2bits;

#define _EEIE                   0x10
#define _C1IE                   0x20
#define _C2IE                   0x40
#define _OSFIE                  0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x008E) __sfr PCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SBOREN             : 1;
    unsigned ULPWUE             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned NOT_BOD            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PCONbits_t;

extern __at(0x008E) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_BOD                0x01
#define _NOT_POR                0x02
#define _SBOREN                 0x10
#define _ULPWUE                 0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x008F) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS                : 1;
    unsigned LTS                : 1;
    unsigned HTS                : 1;
    unsigned OSTS               : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned IRCF               : 3;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x008F) volatile __OSCCONbits_t OSCCONbits;

#define _SCS                    0x01
#define _LTS                    0x02
#define _HTS                    0x04
#define _OSTS                   0x08
#define _IRCF0                  0x10
#define _IRCF1                  0x20
#define _IRCF2                  0x40

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0090) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TUN                : 5;
    unsigned                    : 3;
    };
  } __OSCTUNEbits_t;

extern __at(0x0090) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10

//==============================================================================

extern __at(0x0092) __sfr PR2;

//==============================================================================
//        WPU Bits

extern __at(0x0095) __sfr WPU;

typedef union
  {
  struct
    {
    unsigned WPUA0              : 1;
    unsigned WPUA1              : 1;
    unsigned WPUA2              : 1;
    unsigned                    : 1;
    unsigned WPUA4              : 1;
    unsigned WPUA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPU0               : 1;
    unsigned WPU1               : 1;
    unsigned WPU2               : 1;
    unsigned                    : 1;
    unsigned WPU4               : 1;
    unsigned WPU5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __WPUbits_t;

extern __at(0x0095) volatile __WPUbits_t WPUbits;

#define _WPUA0                  0x01
#define _WPU0                   0x01
#define _WPUA1                  0x02
#define _WPU1                   0x02
#define _WPUA2                  0x04
#define _WPU2                   0x04
#define _WPUA4                  0x10
#define _WPU4                   0x10
#define _WPUA5                  0x20
#define _WPU5                   0x20

//==============================================================================


//==============================================================================
//        WPUA Bits

extern __at(0x0095) __sfr WPUA;

typedef union
  {
  struct
    {
    unsigned WPUA0              : 1;
    unsigned WPUA1              : 1;
    unsigned WPUA2              : 1;
    unsigned                    : 1;
    unsigned WPUA4              : 1;
    unsigned WPUA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPU0               : 1;
    unsigned WPU1               : 1;
    unsigned WPU2               : 1;
    unsigned                    : 1;
    unsigned WPU4               : 1;
    unsigned WPU5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __WPUAbits_t;

extern __at(0x0095) volatile __WPUAbits_t WPUAbits;

#define _WPUA_WPUA0             0x01
#define _WPUA_WPU0              0x01
#define _WPUA_WPUA1             0x02
#define _WPUA_WPU1              0x02
#define _WPUA_WPUA2             0x04
#define _WPUA_WPU2              0x04
#define _WPUA_WPUA4             0x10
#define _WPUA_WPU4              0x10
#define _WPUA_WPUA5             0x20
#define _WPUA_WPU5              0x20

//==============================================================================


//==============================================================================
//        IOC Bits

extern __at(0x0096) __sfr IOC;

typedef union
  {
  struct
    {
    unsigned IOCA0              : 1;
    unsigned IOCA1              : 1;
    unsigned IOCA2              : 1;
    unsigned IOCA3              : 1;
    unsigned IOCA4              : 1;
    unsigned IOCA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOC0               : 1;
    unsigned IOC1               : 1;
    unsigned IOC2               : 1;
    unsigned IOC3               : 1;
    unsigned IOC4               : 1;
    unsigned IOC5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCA               : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned IOC                : 6;
    unsigned                    : 2;
    };
  } __IOCbits_t;

extern __at(0x0096) volatile __IOCbits_t IOCbits;

#define _IOCA0                  0x01
#define _IOC0                   0x01
#define _IOCA1                  0x02
#define _IOC1                   0x02
#define _IOCA2                  0x04
#define _IOC2                   0x04
#define _IOCA3                  0x08
#define _IOC3                   0x08
#define _IOCA4                  0x10
#define _IOC4                   0x10
#define _IOCA5                  0x20
#define _IOC5                   0x20

//==============================================================================


//==============================================================================
//        IOCA Bits

extern __at(0x0096) __sfr IOCA;

typedef union
  {
  struct
    {
    unsigned IOCA0              : 1;
    unsigned IOCA1              : 1;
    unsigned IOCA2              : 1;
    unsigned IOCA3              : 1;
    unsigned IOCA4              : 1;
    unsigned IOCA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOC0               : 1;
    unsigned IOC1               : 1;
    unsigned IOC2               : 1;
    unsigned IOC3               : 1;
    unsigned IOC4               : 1;
    unsigned IOC5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCA               : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned IOC                : 6;
    unsigned                    : 2;
    };
  } __IOCAbits_t;

extern __at(0x0096) volatile __IOCAbits_t IOCAbits;

#define _IOCA_IOCA0             0x01
#define _IOCA_IOC0              0x01
#define _IOCA_IOCA1             0x02
#define _IOCA_IOC1              0x02
#define _IOCA_IOCA2             0x04
#define _IOCA_IOC2              0x04
#define _IOCA_IOCA3             0x08
#define _IOCA_IOC3              0x08
#define _IOCA_IOCA4             0x10
#define _IOCA_IOC4              0x10
#define _IOCA_IOCA5             0x20
#define _IOCA_IOC5              0x20

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0097) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 4;
    unsigned                    : 3;
    };
  } __WDTCONbits_t;

extern __at(0x0097) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10

//==============================================================================

extern __at(0x009E) __sfr ADRESL;

//==============================================================================
//        ADCON1 Bits

extern __at(0x009F) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCS               : 3;
    unsigned                    : 1;
    };
  } __ADCON1bits_t;

extern __at(0x009F) volatile __ADCON1bits_t ADCON1bits;

#define _ADCS0                  0x10
#define _ADCS1                  0x20
#define _ADCS2                  0x40

//==============================================================================

extern __at(0x010C) __sfr EEDAT;
extern __at(0x010C) __sfr EEDATA;
extern __at(0x010D) __sfr EEADR;
extern __at(0x010E) __sfr EEDATH;
extern __at(0x010F) __sfr EEADRH;

//==============================================================================
//        WPUB Bits

extern __at(0x0115) __sfr WPUB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x0115) volatile __WPUBbits_t WPUBbits;

#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        IOCB Bits

extern __at(0x0116) __sfr IOCB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCB4                : 1;
  unsigned IOCB5                : 1;
  unsigned IOCB6                : 1;
  unsigned IOCB7                : 1;
  } __IOCBbits_t;

extern __at(0x0116) volatile __IOCBbits_t IOCBbits;

#define _IOCB4                  0x10
#define _IOCB5                  0x20
#define _IOCB6                  0x40
#define _IOCB7                  0x80

//==============================================================================


//==============================================================================
//        VRCON Bits

extern __at(0x0118) __sfr VRCON;

typedef union
  {
  struct
    {
    unsigned VR0                : 1;
    unsigned VR1                : 1;
    unsigned VR2                : 1;
    unsigned VR3                : 1;
    unsigned VP6EN              : 1;
    unsigned VRR                : 1;
    unsigned C2VREN             : 1;
    unsigned C1VREN             : 1;
    };

  struct
    {
    unsigned VR                 : 4;
    unsigned                    : 4;
    };
  } __VRCONbits_t;

extern __at(0x0118) volatile __VRCONbits_t VRCONbits;

#define _VR0                    0x01
#define _VR1                    0x02
#define _VR2                    0x04
#define _VR3                    0x08
#define _VP6EN                  0x10
#define _VRR                    0x20
#define _C2VREN                 0x40
#define _C1VREN                 0x80

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x0119) __sfr CM1CON0;

typedef union
  {
  struct
    {
    unsigned C1CH0              : 1;
    unsigned C1CH1              : 1;
    unsigned C1R                : 1;
    unsigned                    : 1;
    unsigned C1POL              : 1;
    unsigned C1OE               : 1;
    unsigned C1OUT              : 1;
    unsigned C1ON               : 1;
    };

  struct
    {
    unsigned C1CH               : 2;
    unsigned                    : 6;
    };
  } __CM1CON0bits_t;

extern __at(0x0119) volatile __CM1CON0bits_t CM1CON0bits;

#define _C1CH0                  0x01
#define _C1CH1                  0x02
#define _C1R                    0x04
#define _C1POL                  0x10
#define _C1OE                   0x20
#define _C1OUT                  0x40
#define _C1ON                   0x80

//==============================================================================


//==============================================================================
//        CM2CON0 Bits

extern __at(0x011A) __sfr CM2CON0;

typedef union
  {
  struct
    {
    unsigned C2CH0              : 1;
    unsigned C2CH1              : 1;
    unsigned C2R                : 1;
    unsigned                    : 1;
    unsigned C2POL              : 1;
    unsigned C2OE               : 1;
    unsigned C2OUT              : 1;
    unsigned C2ON               : 1;
    };

  struct
    {
    unsigned C2CH               : 2;
    unsigned                    : 6;
    };
  } __CM2CON0bits_t;

extern __at(0x011A) volatile __CM2CON0bits_t CM2CON0bits;

#define _C2CH0                  0x01
#define _C2CH1                  0x02
#define _C2R                    0x04
#define _C2POL                  0x10
#define _C2OE                   0x20
#define _C2OUT                  0x40
#define _C2ON                   0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x011B) __sfr CM2CON1;

typedef struct
  {
  unsigned C2SYNC               : 1;
  unsigned T1GSS                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned MC2OUT               : 1;
  unsigned MC1OUT               : 1;
  } __CM2CON1bits_t;

extern __at(0x011B) volatile __CM2CON1bits_t CM2CON1bits;

#define _C2SYNC                 0x01
#define _T1GSS                  0x02
#define _MC2OUT                 0x40
#define _MC1OUT                 0x80

//==============================================================================


//==============================================================================
//        ANSEL Bits

extern __at(0x011E) __sfr ANSEL;

typedef struct
  {
  unsigned ANS0                 : 1;
  unsigned ANS1                 : 1;
  unsigned ANS2                 : 1;
  unsigned ANS3                 : 1;
  unsigned ANS4                 : 1;
  unsigned ANS5                 : 1;
  unsigned ANS6                 : 1;
  unsigned ANS7                 : 1;
  } __ANSELbits_t;

extern __at(0x011E) volatile __ANSELbits_t ANSELbits;

#define _ANS0                   0x01
#define _ANS1                   0x02
#define _ANS2                   0x04
#define _ANS3                   0x08
#define _ANS4                   0x10
#define _ANS5                   0x20
#define _ANS6                   0x40
#define _ANS7                   0x80

//==============================================================================


//==============================================================================
//        ANSELH Bits

extern __at(0x011F) __sfr ANSELH;

typedef struct
  {
  unsigned ANS8                 : 1;
  unsigned ANS9                 : 1;
  unsigned ANS10                : 1;
  unsigned ANS11                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELHbits_t;

extern __at(0x011F) volatile __ANSELHbits_t ANSELHbits;

#define _ANS8                   0x01
#define _ANS9                   0x02
#define _ANS10                  0x04
#define _ANS11                  0x08

//==============================================================================


//==============================================================================
//        EECON1 Bits

extern __at(0x018C) __sfr EECON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned EEPGD                : 1;
  } __EECON1bits_t;

extern __at(0x018C) volatile __EECON1bits_t EECON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _EEPGD                  0x80

//==============================================================================

extern __at(0x018D) __sfr EECON2;

//==============================================================================
//        PSTRCON Bits

extern __at(0x019D) __sfr PSTRCON;

typedef struct
  {
  unsigned STRA                 : 1;
  unsigned STRB                 : 1;
  unsigned STRC                 : 1;
  unsigned STRD                 : 1;
  unsigned STRSYNC              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSTRCONbits_t;

extern __at(0x019D) volatile __PSTRCONbits_t PSTRCONbits;

#define _STRA                   0x01
#define _STRB                   0x02
#define _STRC                   0x04
#define _STRD                   0x08
#define _STRSYNC                0x10

//==============================================================================


//==============================================================================
//        SRCON Bits

extern __at(0x019E) __sfr SRCON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PULSR              : 1;
    unsigned PULSS              : 1;
    unsigned C2REN              : 1;
    unsigned C1SEN              : 1;
    unsigned SR0                : 1;
    unsigned SR1                : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned SR                 : 2;
    };
  } __SRCONbits_t;

extern __at(0x019E) volatile __SRCONbits_t SRCONbits;

#define _PULSR                  0x04
#define _PULSS                  0x08
#define _C2REN                  0x10
#define _C1SEN                  0x20
#define _SR0                    0x40
#define _SR1                    0x80

//==============================================================================


//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG                 0x2007

//----------------------------- CONFIG Options -------------------------------

#define _FOSC_LP                0x3FF8  // LP oscillator: Low-power crystal on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN.
#define _LP_OSC                 0x3FF8  // LP oscillator: Low-power crystal on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN.
#define _FOSC_XT                0x3FF9  // XT oscillator: Crystal/resonator on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN.
#define _XT_OSC                 0x3FF9  // XT oscillator: Crystal/resonator on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN.
#define _FOSC_HS                0x3FFA  // HS oscillator: High-speed crystal/resonator on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN.
#define _HS_OSC                 0x3FFA  // HS oscillator: High-speed crystal/resonator on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN.
#define _FOSC_EC                0x3FFB  // EC: I/O function on RA4/OSC2/CLKOUT pin, CLKIN on RA5/OSC1/CLKIN.
#define _EC_OSC                 0x3FFB  // EC: I/O function on RA4/OSC2/CLKOUT pin, CLKIN on RA5/OSC1/CLKIN.
#define _FOSC_INTRCIO           0x3FFC  // INTOSCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN.
#define _INTRC_OSC_NOCLKOUT     0x3FFC  // INTOSCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN.
#define _INTOSCIO               0x3FFC  // INTOSCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN.
#define _FOSC_INTRCCLK          0x3FFD  // INTOSC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN.
#define _INTRC_OSC_CLKOUT       0x3FFD  // INTOSC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN.
#define _INTOSC                 0x3FFD  // INTOSC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN.
#define _FOSC_EXTRCIO           0x3FFE  // RCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, RC on RA5/OSC1/CLKIN.
#define _EXTRC_OSC_NOCLKOUT     0x3FFE  // RCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, RC on RA5/OSC1/CLKIN.
#define _EXTRCIO                0x3FFE  // RCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, RC on RA5/OSC1/CLKIN.
#define _FOSC_EXTRCCLK          0x3FFF  // RC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, RC on RA5/OSC1/CLKIN.
#define _EXTRC_OSC_CLKOUT       0x3FFF  // RC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, RC on RA5/OSC1/CLKIN.
#define _EXTRC                  0x3FFF  // RC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, RC on RA5/OSC1/CLKIN.
#define _WDTE_OFF               0x3FF7  // WDT disabled and can be enabled by SWDTEN bit of the WDTCON register.
#define _WDT_OFF                0x3FF7  // WDT disabled and can be enabled by SWDTEN bit of the WDTCON register.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _WDT_ON                 0x3FFF  // WDT enabled.
#define _PWRTE_ON               0x3FEF  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _MCLRE_OFF              0x3FDF  // MCLR pin function is digital input, MCLR internally tied to VDD.
#define _MCLRE_ON               0x3FFF  // MCLR pin function is MCLR.
#define _CP_ON                  0x3FBF  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.
#define _CPD_ON                 0x3F7F  // Data memory code protection is enabled.
#define _CPD_OFF                0x3FFF  // Data memory code protection is disabled.
#define _BOREN_OFF              0x3CFF  // BOR disabled.
#define _BOD_OFF                0x3CFF  // BOR disabled.
#define _BOR_OFF                0x3CFF  // BOR disabled.
#define _BOREN_SBODEN           0x3DFF  // BOR controlled by SBOREN bit of the PCON register.
#define _BOD_SBODEN             0x3DFF  // BOR controlled by SBOREN bit of the PCON register.
#define _BOR_SBODEN             0x3DFF  // BOR controlled by SBOREN bit of the PCON register.
#define _BOREN_NSLEEP           0x3EFF  // BOR enabled during operation and disabled in Sleep.
#define _BOD_NSLEEP             0x3EFF  // BOR enabled during operation and disabled in Sleep.
#define _BOR_NSLEEP             0x3EFF  // BOR enabled during operation and disabled in Sleep.
#define _BOREN_ON               0x3FFF  // BOR enabled.
#define _BOD_ON                 0x3FFF  // BOR enabled.
#define _BOR_ON                 0x3FFF  // BOR enabled.
#define _IESO_OFF               0x3BFF  // Internal External Switchover mode is disabled.
#define _IESO_ON                0x3FFF  // Internal External Switchover mode is enabled.
#define _FCMEN_OFF              0x37FF  // Fail-Safe Clock Monitor is disabled.
#define _FCMEN_ON               0x3FFF  // Fail-Safe Clock Monitor is enabled.

//==============================================================================

#define _DEVID1                 0x2006

#define _IDLOC0                 0x2000
#define _IDLOC1                 0x2001
#define _IDLOC2                 0x2002
#define _IDLOC3                 0x2003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 1, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 1, shadows bit in ADCON0bits
#define NOT_DONE                ADCON0bits.NOT_DONE             // bit 1, shadows bit in ADCON0bits
#define GO_DONE                 ADCON0bits.GO_DONE              // bit 1, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 2
#define CHS1                    ADCON0bits.CHS1                 // bit 3
#define CHS2                    ADCON0bits.CHS2                 // bit 4
#define CHS3                    ADCON0bits.CHS3                 // bit 5
#define VCFG                    ADCON0bits.VCFG                 // bit 6
#define ADFM                    ADCON0bits.ADFM                 // bit 7

#define ADCS0                   ADCON1bits.ADCS0                // bit 4
#define ADCS1                   ADCON1bits.ADCS1                // bit 5
#define ADCS2                   ADCON1bits.ADCS2                // bit 6

#define ANS0                    ANSELbits.ANS0                  // bit 0
#define ANS1                    ANSELbits.ANS1                  // bit 1
#define ANS2                    ANSELbits.ANS2                  // bit 2
#define ANS3                    ANSELbits.ANS3                  // bit 3
#define ANS4                    ANSELbits.ANS4                  // bit 4
#define ANS5                    ANSELbits.ANS5                  // bit 5
#define ANS6                    ANSELbits.ANS6                  // bit 6
#define ANS7                    ANSELbits.ANS7                  // bit 7

#define ANS8                    ANSELHbits.ANS8                 // bit 0
#define ANS9                    ANSELHbits.ANS9                 // bit 1
#define ANS10                   ANSELHbits.ANS10                // bit 2
#define ANS11                   ANSELHbits.ANS11                // bit 3

#define CCP1M0                  CCP1CONbits.CCP1M0              // bit 0
#define CCP1M1                  CCP1CONbits.CCP1M1              // bit 1
#define CCP1M2                  CCP1CONbits.CCP1M2              // bit 2
#define CCP1M3                  CCP1CONbits.CCP1M3              // bit 3
#define DC1B0                   CCP1CONbits.DC1B0               // bit 4
#define DC1B1                   CCP1CONbits.DC1B1               // bit 5
#define P1M0                    CCP1CONbits.P1M0                // bit 6
#define P1M1                    CCP1CONbits.P1M1                // bit 7

#define C1CH0                   CM1CON0bits.C1CH0               // bit 0
#define C1CH1                   CM1CON0bits.C1CH1               // bit 1
#define C1R                     CM1CON0bits.C1R                 // bit 2
#define C1POL                   CM1CON0bits.C1POL               // bit 4
#define C1OE                    CM1CON0bits.C1OE                // bit 5
#define C1OUT                   CM1CON0bits.C1OUT               // bit 6
#define C1ON                    CM1CON0bits.C1ON                // bit 7

#define C2CH0                   CM2CON0bits.C2CH0               // bit 0
#define C2CH1                   CM2CON0bits.C2CH1               // bit 1
#define C2R                     CM2CON0bits.C2R                 // bit 2
#define C2POL                   CM2CON0bits.C2POL               // bit 4
#define C2OE                    CM2CON0bits.C2OE                // bit 5
#define C2OUT                   CM2CON0bits.C2OUT               // bit 6
#define C2ON                    CM2CON0bits.C2ON                // bit 7

#define C2SYNC                  CM2CON1bits.C2SYNC              // bit 0
#define T1GSS                   CM2CON1bits.T1GSS               // bit 1
#define MC2OUT                  CM2CON1bits.MC2OUT              // bit 6
#define MC1OUT                  CM2CON1bits.MC1OUT              // bit 7

#define PSSBD0                  ECCPASbits.PSSBD0               // bit 0
#define PSSBD1                  ECCPASbits.PSSBD1               // bit 1
#define PSSAC0                  ECCPASbits.PSSAC0               // bit 2
#define PSSAC1                  ECCPASbits.PSSAC1               // bit 3
#define ECCPAS0                 ECCPASbits.ECCPAS0              // bit 4
#define ECCPAS1                 ECCPASbits.ECCPAS1              // bit 5
#define ECCPAS2                 ECCPASbits.ECCPAS2              // bit 6
#define ECCPASE                 ECCPASbits.ECCPASE              // bit 7

#define RD                      EECON1bits.RD                   // bit 0
#define WR                      EECON1bits.WR                   // bit 1
#define WREN                    EECON1bits.WREN                 // bit 2
#define WRERR                   EECON1bits.WRERR                // bit 3
#define EEPGD                   EECON1bits.EEPGD                // bit 7

#define RABIF                   INTCONbits.RABIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define T0IF                    INTCONbits.T0IF                 // bit 2
#define RABIE                   INTCONbits.RABIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define T0IE                    INTCONbits.T0IE                 // bit 5
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCA0                   IOCbits.IOCA0                   // bit 0, shadows bit in IOCbits
#define IOC0                    IOCbits.IOC0                    // bit 0, shadows bit in IOCbits
#define IOCA1                   IOCbits.IOCA1                   // bit 1, shadows bit in IOCbits
#define IOC1                    IOCbits.IOC1                    // bit 1, shadows bit in IOCbits
#define IOCA2                   IOCbits.IOCA2                   // bit 2, shadows bit in IOCbits
#define IOC2                    IOCbits.IOC2                    // bit 2, shadows bit in IOCbits
#define IOCA3                   IOCbits.IOCA3                   // bit 3, shadows bit in IOCbits
#define IOC3                    IOCbits.IOC3                    // bit 3, shadows bit in IOCbits
#define IOCA4                   IOCbits.IOCA4                   // bit 4, shadows bit in IOCbits
#define IOC4                    IOCbits.IOC4                    // bit 4, shadows bit in IOCbits
#define IOCA5                   IOCbits.IOCA5                   // bit 5, shadows bit in IOCbits
#define IOC5                    IOCbits.IOC5                    // bit 5, shadows bit in IOCbits

#define IOCB4                   IOCBbits.IOCB4                  // bit 4
#define IOCB5                   IOCBbits.IOCB5                  // bit 5
#define IOCB6                   IOCBbits.IOCB6                  // bit 6
#define IOCB7                   IOCBbits.IOCB7                  // bit 7

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define T0SE                    OPTION_REGbits.T0SE             // bit 4
#define T0CS                    OPTION_REGbits.T0CS             // bit 5
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_RABPU               OPTION_REGbits.NOT_RABPU        // bit 7

#define SCS                     OSCCONbits.SCS                  // bit 0
#define LTS                     OSCCONbits.LTS                  // bit 1
#define HTS                     OSCCONbits.HTS                  // bit 2
#define OSTS                    OSCCONbits.OSTS                 // bit 3
#define IRCF0                   OSCCONbits.IRCF0                // bit 4
#define IRCF1                   OSCCONbits.IRCF1                // bit 5
#define IRCF2                   OSCCONbits.IRCF2                // bit 6

#define TUN0                    OSCTUNEbits.TUN0                // bit 0
#define TUN1                    OSCTUNEbits.TUN1                // bit 1
#define TUN2                    OSCTUNEbits.TUN2                // bit 2
#define TUN3                    OSCTUNEbits.TUN3                // bit 3
#define TUN4                    OSCTUNEbits.TUN4                // bit 4

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0, shadows bit in PCONbits
#define NOT_BOD                 PCONbits.NOT_BOD                // bit 0, shadows bit in PCONbits
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define SBOREN                  PCONbits.SBOREN                 // bit 4
#define ULPWUE                  PCONbits.ULPWUE                 // bit 5

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0, shadows bit in PIE1bits
#define T1IE                    PIE1bits.T1IE                   // bit 0, shadows bit in PIE1bits
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1, shadows bit in PIE1bits
#define T2IE                    PIE1bits.T2IE                   // bit 1, shadows bit in PIE1bits
#define CCP1IE                  PIE1bits.CCP1IE                 // bit 2
#define ADIE                    PIE1bits.ADIE                   // bit 6

#define EEIE                    PIE2bits.EEIE                   // bit 4
#define C1IE                    PIE2bits.C1IE                   // bit 5
#define C2IE                    PIE2bits.C2IE                   // bit 6
#define OSFIE                   PIE2bits.OSFIE                  // bit 7

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0, shadows bit in PIR1bits
#define T1IF                    PIR1bits.T1IF                   // bit 0, shadows bit in PIR1bits
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1, shadows bit in PIR1bits
#define T2IF                    PIR1bits.T2IF                   // bit 1, shadows bit in PIR1bits
#define CCP1IF                  PIR1bits.CCP1IF                 // bit 2
#define ADIF                    PIR1bits.ADIF                   // bit 6

#define EEIF                    PIR2bits.EEIF                   // bit 4
#define C1IF                    PIR2bits.C1IF                   // bit 5
#define C2IF                    PIR2bits.C2IF                   // bit 6
#define OSFIF                   PIR2bits.OSFIF                  // bit 7

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5

#define RB4                     PORTBbits.RB4                   // bit 4
#define RB5                     PORTBbits.RB5                   // bit 5
#define RB6                     PORTBbits.RB6                   // bit 6
#define RB7                     PORTBbits.RB7                   // bit 7

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5
#define RC6                     PORTCbits.RC6                   // bit 6
#define RC7                     PORTCbits.RC7                   // bit 7

#define STRA                    PSTRCONbits.STRA                // bit 0
#define STRB                    PSTRCONbits.STRB                // bit 1
#define STRC                    PSTRCONbits.STRC                // bit 2
#define STRD                    PSTRCONbits.STRD                // bit 3
#define STRSYNC                 PSTRCONbits.STRSYNC             // bit 4

#define PDC0                    PWM1CONbits.PDC0                // bit 0
#define PDC1                    PWM1CONbits.PDC1                // bit 1
#define PDC2                    PWM1CONbits.PDC2                // bit 2
#define PDC3                    PWM1CONbits.PDC3                // bit 3
#define PDC4                    PWM1CONbits.PDC4                // bit 4
#define PDC5                    PWM1CONbits.PDC5                // bit 5
#define PDC6                    PWM1CONbits.PDC6                // bit 6
#define PRSEN                   PWM1CONbits.PRSEN               // bit 7

#define PULSR                   SRCONbits.PULSR                 // bit 2
#define PULSS                   SRCONbits.PULSS                 // bit 3
#define C2REN                   SRCONbits.C2REN                 // bit 4
#define C1SEN                   SRCONbits.C1SEN                 // bit 5
#define SR0                     SRCONbits.SR0                   // bit 6
#define SR1                     SRCONbits.SR1                   // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4
#define RP0                     STATUSbits.RP0                  // bit 5
#define RP1                     STATUSbits.RP1                  // bit 6
#define IRP                     STATUSbits.IRP                  // bit 7

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define TMR1CS                  T1CONbits.TMR1CS                // bit 1
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2
#define T1OSCEN                 T1CONbits.T1OSCEN               // bit 3
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1GE                  T1CONbits.TMR1GE                // bit 6
#define T1GINV                  T1CONbits.T1GINV                // bit 7

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define TOUTPS0                 T2CONbits.TOUTPS0               // bit 3
#define TOUTPS1                 T2CONbits.TOUTPS1               // bit 4
#define TOUTPS2                 T2CONbits.TOUTPS2               // bit 5
#define TOUTPS3                 T2CONbits.TOUTPS3               // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5

#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5
#define TRISC6                  TRISCbits.TRISC6                // bit 6
#define TRISC7                  TRISCbits.TRISC7                // bit 7

#define VR0                     VRCONbits.VR0                   // bit 0
#define VR1                     VRCONbits.VR1                   // bit 1
#define VR2                     VRCONbits.VR2                   // bit 2
#define VR3                     VRCONbits.VR3                   // bit 3
#define VP6EN                   VRCONbits.VP6EN                 // bit 4
#define VRR                     VRCONbits.VRR                   // bit 5
#define C2VREN                  VRCONbits.C2VREN                // bit 6
#define C1VREN                  VRCONbits.C1VREN                // bit 7

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4

#define WPUA0                   WPUbits.WPUA0                   // bit 0, shadows bit in WPUbits
#define WPU0                    WPUbits.WPU0                    // bit 0, shadows bit in WPUbits
#define WPUA1                   WPUbits.WPUA1                   // bit 1, shadows bit in WPUbits
#define WPU1                    WPUbits.WPU1                    // bit 1, shadows bit in WPUbits
#define WPUA2                   WPUbits.WPUA2                   // bit 2, shadows bit in WPUbits
#define WPU2                    WPUbits.WPU2                    // bit 2, shadows bit in WPUbits
#define WPUA4                   WPUbits.WPUA4                   // bit 4, shadows bit in WPUbits
#define WPU4                    WPUbits.WPU4                    // bit 4, shadows bit in WPUbits
#define WPUA5                   WPUbits.WPUA5                   // bit 5, shadows bit in WPUbits
#define WPU5                    WPUbits.WPU5                    // bit 5, shadows bit in WPUbits

#define WPUB4                   WPUBbits.WPUB4                  // bit 4
#define WPUB5                   WPUBbits.WPUB5                  // bit 5
#define WPUB6                   WPUBbits.WPUB6                  // bit 6
#define WPUB7                   WPUBbits.WPUB7                  // bit 7

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16F685_H__
