/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.standard.DecoratorFigure;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class BorderDecorator
extends DecoratorFigure {
    private static final long serialVersionUID = 1205601808259084917L;
    private int borderDecoratorSerializedDataVersion = 1;
    private Point myBorderOffset;
    private Color myBorderColor;
    private Color myShadowColor;

    public BorderDecorator() {
    }

    public BorderDecorator(Figure figure) {
        super(figure);
    }

    protected void initialize() {
        this.setBorderOffset(new Point(3, 3));
    }

    public void setBorderOffset(Point newBorderOffset) {
        this.myBorderOffset = newBorderOffset;
    }

    public Point getBorderOffset() {
        if (this.myBorderOffset == null) {
            return new Point(0, 0);
        }
        return this.myBorderOffset;
    }

    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        super.draw(g);
        g.setColor(Color.white);
        g.drawLine(r.x, r.y, r.x, r.y + r.height);
        g.drawLine(r.x, r.y, r.x + r.width, r.y);
        g.setColor(Color.gray);
        g.drawLine(r.x + r.width, r.y, r.x + r.width, r.y + r.height);
        g.drawLine(r.x, r.y + r.height, r.x + r.width, r.y + r.height);
    }

    public Rectangle displayBox() {
        Rectangle r = this.getDecoratedFigure().displayBox();
        r.grow(this.getBorderOffset().x, this.getBorderOffset().y);
        return r;
    }

    public void figureInvalidated(FigureChangeEvent e) {
        Rectangle rect = e.getInvalidatedRectangle();
        rect.grow(this.getBorderOffset().x, this.getBorderOffset().y);
        super.figureInvalidated(new FigureChangeEvent(e.getFigure(), rect));
    }

    public Insets connectionInsets() {
        Insets i = super.connectionInsets();
        i.top -= this.getBorderOffset().y;
        i.bottom -= this.getBorderOffset().y;
        i.left -= this.getBorderOffset().x;
        i.right -= this.getBorderOffset().x;
        return i;
    }
}

