/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.uml1_4.changepropagation;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.uml1_4.changepropagation.MetaModelChange;
import ch.ehi.uml1_4.changepropagation.MetaModelListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MetaModel {
    static MetaModel instance = null;
    private Set metaModelListener = new HashSet();
    private boolean doEventLogging = false;
    private boolean doChangePropagation = true;

    public static MetaModel getInstance() {
        if (instance == null) {
            instance = new MetaModel();
        }
        return instance;
    }

    private MetaModel() {
    }

    public void notifyChange(MetaModelChange change) {
        if (!this.doChangePropagation) {
            return;
        }
        if (this.doEventLogging) {
            EhiLogger.traceState(change.toString());
        }
        Iterator it = this.iteratorMetaModelListener();
        while (it.hasNext()) {
            MetaModelListener listener = (MetaModelListener)it.next();
            listener.metaModelChanged(change);
        }
    }

    public void addMetaModelListener(MetaModelListener metaModelListener1) {
        this.metaModelListener.add(metaModelListener1);
    }

    public MetaModelListener removeMetaModelListener(MetaModelListener metaModelListener1) {
        MetaModelListener ret = null;
        if (metaModelListener1 == null || !this.metaModelListener.contains(metaModelListener1)) {
            throw new IllegalArgumentException("cannot remove null or unknown object");
        }
        ret = metaModelListener1;
        this.metaModelListener.remove(metaModelListener1);
        return ret;
    }

    public boolean containsMetaModelListener(MetaModelListener metaModelListener1) {
        return this.metaModelListener.contains(metaModelListener1);
    }

    public Iterator iteratorMetaModelListener() {
        return this.metaModelListener.iterator();
    }

    public void clearMetaModelListener() {
        if (this.sizeMetaModelListener() > 0) {
            this.metaModelListener.clear();
        }
    }

    public int sizeMetaModelListener() {
        return this.metaModelListener.size();
    }

    public static boolean setEventLogging(boolean doIt) {
        boolean ret = MetaModel.getInstance().doEventLogging;
        MetaModel.getInstance().doEventLogging = doIt;
        return ret;
    }

    public static boolean setChangePropagation(boolean doIt) {
        boolean ret = MetaModel.getInstance().doChangePropagation;
        MetaModel.getInstance().doChangePropagation = doIt;
        return ret;
    }
}

