/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.interlis.iliimport;

import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.basics.types.NlsString;
import ch.ehi.interlis.associations.AssociationDef;
import ch.ehi.interlis.associations.Participant;
import ch.ehi.interlis.associations.RoleDef;
import ch.ehi.interlis.attributes.AttributeValueUsage;
import ch.ehi.interlis.attributes.DomainAttribute;
import ch.ehi.interlis.constraints.ConstraintDef;
import ch.ehi.interlis.constraints.ConstraintExpression;
import ch.ehi.interlis.domainsandconstants.DomainDef;
import ch.ehi.interlis.domainsandconstants.DomainExtends;
import ch.ehi.interlis.domainsandconstants.Type;
import ch.ehi.interlis.domainsandconstants.UnknownType;
import ch.ehi.interlis.domainsandconstants.basetypes.BaseType;
import ch.ehi.interlis.domainsandconstants.basetypes.BooleanType;
import ch.ehi.interlis.domainsandconstants.basetypes.ClassType;
import ch.ehi.interlis.domainsandconstants.basetypes.CoordinateType;
import ch.ehi.interlis.domainsandconstants.basetypes.EnumElement;
import ch.ehi.interlis.domainsandconstants.basetypes.HorizAlignment;
import ch.ehi.interlis.domainsandconstants.basetypes.IliDim;
import ch.ehi.interlis.domainsandconstants.basetypes.NumericType;
import ch.ehi.interlis.domainsandconstants.basetypes.NumericalType;
import ch.ehi.interlis.domainsandconstants.basetypes.OidType;
import ch.ehi.interlis.domainsandconstants.basetypes.RefSys;
import ch.ehi.interlis.domainsandconstants.basetypes.RotationDef;
import ch.ehi.interlis.domainsandconstants.basetypes.StructAttrType;
import ch.ehi.interlis.domainsandconstants.basetypes.StructDec;
import ch.ehi.interlis.domainsandconstants.basetypes.StructuredUnitType;
import ch.ehi.interlis.domainsandconstants.basetypes.Text;
import ch.ehi.interlis.domainsandconstants.basetypes.VertAlignment;
import ch.ehi.interlis.domainsandconstants.linetypes.IliPolyline;
import ch.ehi.interlis.domainsandconstants.linetypes.IndividualSurface;
import ch.ehi.interlis.domainsandconstants.linetypes.IntersectionDef;
import ch.ehi.interlis.domainsandconstants.linetypes.LineFormTypeDef;
import ch.ehi.interlis.domainsandconstants.linetypes.LineType;
import ch.ehi.interlis.domainsandconstants.linetypes.SurfaceType;
import ch.ehi.interlis.domainsandconstants.linetypes.Tesselation;
import ch.ehi.interlis.functions.FunctionDef;
import ch.ehi.interlis.graphicdescriptions.GraphicDef;
import ch.ehi.interlis.metaobjects.MetaDataUseDef;
import ch.ehi.interlis.metaobjects.MetaObjectFile;
import ch.ehi.interlis.metaobjects.ParameterDef;
import ch.ehi.interlis.modeltopicclass.AbstractClassDef;
import ch.ehi.interlis.modeltopicclass.ClassDef;
import ch.ehi.interlis.modeltopicclass.ClassExtends;
import ch.ehi.interlis.modeltopicclass.INTERLIS2Def;
import ch.ehi.interlis.modeltopicclass.IliImport;
import ch.ehi.interlis.modeltopicclass.ModelDef;
import ch.ehi.interlis.modeltopicclass.TopicDef;
import ch.ehi.interlis.modeltopicclass.TopicDepends;
import ch.ehi.interlis.modeltopicclass.TopicExtends;
import ch.ehi.interlis.units.UnitDef;
import ch.ehi.interlis.views.ViewDef;
import ch.ehi.interlis.views.ViewProjectionDef;
import ch.ehi.uml1_4.foundation.core.Association;
import ch.ehi.uml1_4.foundation.core.Class;
import ch.ehi.uml1_4.foundation.core.Classifier;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.foundation.core.Namespace;
import ch.ehi.uml1_4.foundation.datatypes.Multiplicity;
import ch.ehi.uml1_4.foundation.extensionmechanisms.TaggedValue;
import ch.ehi.uml1_4.implementation.AbstractModelElement;
import ch.ehi.uml1_4.implementation.UmlMultiplicity;
import ch.ehi.uml1_4.implementation.UmlMultiplicityRange;
import ch.ehi.uml1_4.implementation.UmlPackage;
import ch.ehi.uml1_4.implementation.UmlTaggedValue;
import ch.ehi.uml1_4.implementation.UmlUsage;
import ch.ehi.uml1_4.modelmanagement.Package;
import ch.ehi.uml1_4.tools.NamespaceUtility;
import ch.ehi.umleditor.application.ElementFactory;
import ch.ehi.umleditor.interlis.iliimport.CreateDiagramUtility;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.generator.Interlis2Generator;
import ch.interlis.ili2c.metamodel.AnyOIDType;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Constant;
import ch.interlis.ili2c.metamodel.Constraint;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.DataContainer;
import ch.interlis.ili2c.metamodel.DataModel;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.Graphic;
import ch.interlis.ili2c.metamodel.GraphicParameterDef;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NumericOIDType;
import ch.interlis.ili2c.metamodel.OIDType;
import ch.interlis.ili2c.metamodel.Parameter;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.Projection;
import ch.interlis.ili2c.metamodel.RefSystemModel;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SymbologyModel;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextOIDType;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.TypeModel;
import ch.interlis.ili2c.metamodel.Unit;
import ch.interlis.ili2c.metamodel.View;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class TransferFromIli2cMetamodel {
    public static final String TAGGEDVALUE_ILI_PREFIX = "ili:";
    private final boolean unwrapMultiValueStructAttrs = true;
    private final boolean iliAttrsAsUmlAttrs = true;
    private ArrayList namespaceStack = new ArrayList();
    private HashMap fileMap = new HashMap();
    private HashMap modelMap = new HashMap();
    private HashMap topicMap = new HashMap();
    private HashMap gfxParamMap = new HashMap();
    private HashMap viewableMap = new HashMap();
    private HashMap domainMap = new HashMap();
    private HashMap lineFormTypeMap = new HashMap();
    private HashMap unitMap = new HashMap();
    private HashMap functionMap = new HashMap();
    private HashMap gfxMap = new HashMap();
    private String modelLanguage = "";
    Interlis2Generator makeSyntax = null;
    StringWriter syntaxBuffer = null;
    private PredefinedModel ilibase;
    private Package ili2modelset;
    private static int uniqueName = 1;
    static java.util.ResourceBundle rsrc = ResourceBundle.getBundle(TransferFromIli2cMetamodel.class);

    private void addNamespace(Namespace ns) {
        this.namespaceStack.add(0, ns);
    }

    private Namespace getNamespace() {
        return (Namespace)this.namespaceStack.get(0);
    }

    private void removeNamespace() {
        this.namespaceStack.remove(0);
    }

    private INTERLIS2Def findINTERLIS2Def(String language, String filename) {
        if (this.fileMap.containsKey(filename)) {
            return (INTERLIS2Def)this.fileMap.get(filename);
        }
        INTERLIS2Def ili2Def = new INTERLIS2Def();
        ili2Def.setName(new NlsString(language, filename));
        this.fileMap.put(filename, ili2Def);
        this.ili2modelset.addOwnedElement(ili2Def);
        return ili2Def;
    }

    private ModelDef findModelDef(Model model) {
        if (this.modelMap.containsKey(model)) {
            return (ModelDef)this.modelMap.get(model);
        }
        ModelDef modelDef = new ModelDef();
        this.modelMap.put(model, modelDef);
        return modelDef;
    }

    private TopicDef findTopicDef(Topic topic) {
        if (this.topicMap.containsKey(topic)) {
            return (TopicDef)this.topicMap.get(topic);
        }
        TopicDef topicDef = new TopicDef();
        this.topicMap.put(topic, topicDef);
        return topicDef;
    }

    private ch.ehi.interlis.graphicdescriptions.GraphicParameterDef findGraphicParameterDef(GraphicParameterDef gfxParam) {
        if (this.gfxParamMap.containsKey(gfxParam)) {
            return (ch.ehi.interlis.graphicdescriptions.GraphicParameterDef)this.gfxParamMap.get(gfxParam);
        }
        ch.ehi.interlis.graphicdescriptions.GraphicParameterDef gfxParamDef = new ch.ehi.interlis.graphicdescriptions.GraphicParameterDef();
        this.gfxParamMap.put(gfxParam, gfxParamDef);
        return gfxParamDef;
    }

    private Classifier findViewable(Viewable table) {
        if (this.viewableMap.containsKey(table)) {
            return (Classifier)this.viewableMap.get(table);
        }
        throw new IllegalStateException("this Viewbale not yet seen");
    }

    private ClassDef findClassDef(Table table) {
        if (this.viewableMap.containsKey(table)) {
            return (ClassDef)this.viewableMap.get(table);
        }
        ClassDef classDef = new ClassDef();
        this.viewableMap.put(table, classDef);
        return classDef;
    }

    private AssociationDef findAssociationDef(ch.interlis.ili2c.metamodel.AssociationDef assoc) {
        if (this.viewableMap.containsKey(assoc)) {
            return (AssociationDef)this.viewableMap.get(assoc);
        }
        AssociationDef assocDef = new AssociationDef();
        this.viewableMap.put(assoc, assocDef);
        return assocDef;
    }

    private ViewDef findViewDef(View view) {
        if (this.viewableMap.containsKey(view)) {
            return (ViewDef)this.viewableMap.get(view);
        }
        ViewDef viewDef = new ViewDef();
        this.viewableMap.put(view, viewDef);
        return viewDef;
    }

    private ViewProjectionDef findViewProjectionDef(Projection proj) {
        if (this.viewableMap.containsKey(proj)) {
            return (ViewProjectionDef)this.viewableMap.get(proj);
        }
        ViewProjectionDef projDef = new ViewProjectionDef();
        this.viewableMap.put(proj, projDef);
        return projDef;
    }

    private DomainDef findDomainDef(Domain domain) {
        if (this.domainMap.containsKey(domain)) {
            return (DomainDef)this.domainMap.get(domain);
        }
        DomainDef domainDef = new DomainDef();
        this.domainMap.put(domain, domainDef);
        return domainDef;
    }

    private LineFormTypeDef findLineFormTypeDef(LineForm lineFormType) {
        if (this.lineFormTypeMap.containsKey(lineFormType)) {
            return (LineFormTypeDef)this.lineFormTypeMap.get(lineFormType);
        }
        LineFormTypeDef lineFormTypeDef = new LineFormTypeDef();
        this.lineFormTypeMap.put(lineFormType, lineFormTypeDef);
        return lineFormTypeDef;
    }

    private UnitDef findUnitDef(Unit unit) {
        if (this.unitMap.containsKey(unit)) {
            return (UnitDef)this.unitMap.get(unit);
        }
        UnitDef unitDef = new UnitDef();
        this.unitMap.put(unit, unitDef);
        return unitDef;
    }

    private FunctionDef findFunctionDef(Function f) {
        if (this.functionMap.containsKey(f)) {
            return (FunctionDef)this.functionMap.get(f);
        }
        FunctionDef funcDef = new FunctionDef();
        this.functionMap.put(f, funcDef);
        return funcDef;
    }

    private GraphicDef findGraphicDef(Graphic g) {
        if (this.gfxMap.containsKey(g)) {
            return (GraphicDef)this.gfxMap.get(g);
        }
        GraphicDef gfxDef = new GraphicDef();
        this.gfxMap.put(g, gfxDef);
        return gfxDef;
    }

    private TopicDef visitTopicDef(Topic topic) {
        if (topic == null) {
            return null;
        }
        TopicDef topicdef = this.findTopicDef(topic);
        topicdef.setName(new NlsString(this.modelLanguage, topic.getName()));
        String ilidoc = topic.getDocumentation();
        if (ilidoc != null) {
            topicdef.setDocumentation(new NlsString(this.modelLanguage, ilidoc));
        }
        this.visitMetaValues(topicdef, topic.getMetaValues());
        topicdef.setAbstract(topic.isAbstract());
        topicdef.setPropFinal(topic.isFinal());
        if (topic.isViewTopic()) {
            topicdef.setKind(2);
        } else {
            topicdef.setKind(1);
        }
        Topic extending = (Topic)topic.getExtending();
        if (extending != null) {
            TopicDef parent = this.findTopicDef(extending);
            TopicExtends topicextends = new TopicExtends();
            topicextends.attachParent(parent);
            topicextends.attachChild(topicdef);
        }
        if (topic.getOid() != null) {
            topicdef.attachOiddomain(this.findDomainDef(topic.getOid()));
        }
        Iterator<Topic> it = topic.getDependentOn();
        while (it.hasNext()) {
            Topic depends = it.next();
            TopicDef supplier = this.findTopicDef(depends);
            TopicDepends topicdepends = new TopicDepends();
            topicdepends.addSupplier(supplier);
            topicdepends.addClient(topicdef);
        }
        this.getNamespace().addOwnedElement(topicdef);
        this.addNamespace(topicdef);
        this.visitElements(topic);
        CreateDiagramUtility.classes(topicdef);
        this.removeNamespace();
        return topicdef;
    }

    private ClassDef visitClassDef(Table tdef) {
        ClassDef classdef = this.findClassDef(tdef);
        classdef.setName(new NlsString(this.modelLanguage, tdef.getName()));
        String ilidoc = tdef.getDocumentation();
        if (ilidoc != null) {
            classdef.setDocumentation(new NlsString(this.modelLanguage, ilidoc));
        }
        this.visitMetaValues(classdef, tdef.getMetaValues());
        classdef.setAbstract(tdef.isAbstract());
        classdef.setPropFinal(tdef.isFinal());
        if (tdef.isIdentifiable()) {
            classdef.setKind(1);
        } else {
            classdef.setKind(2);
        }
        Table extending = (Table)tdef.getExtending();
        if (extending != null) {
            ClassDef parent = this.findClassDef(extending);
            ClassExtends classextends = new ClassExtends();
            classextends.attachParent(parent);
            classextends.attachChild(classdef);
            classextends.setExtended(tdef.isExtended());
        }
        this.getNamespace().addOwnedElement(classdef);
        this.addNamespace(classdef);
        this.visitElements(tdef);
        this.removeNamespace();
        return classdef;
    }

    private AssociationDef visitAssociationDef(ch.interlis.ili2c.metamodel.AssociationDef assoc) {
        AssociationDef assocdef = this.findAssociationDef(assoc);
        assocdef.setName(new NlsString(this.modelLanguage, assoc.getName()));
        String ilidoc = assoc.getDocumentation();
        if (ilidoc != null) {
            assocdef.setDocumentation(new NlsString(this.modelLanguage, ilidoc));
        }
        this.visitMetaValues(assocdef, assoc.getMetaValues());
        assocdef.setAbstract(assoc.isAbstract());
        assocdef.setPropFinal(assoc.isFinal());
        ch.interlis.ili2c.metamodel.AssociationDef extending = (ch.interlis.ili2c.metamodel.AssociationDef)assoc.getExtending();
        if (extending != null) {
            AssociationDef parent = this.findAssociationDef(extending);
            ClassExtends classextends = new ClassExtends();
            classextends.attachParent(parent);
            classextends.attachChild(assocdef);
            classextends.setExtended(assoc.isExtended());
        }
        this.getNamespace().addOwnedElement(assocdef);
        this.addNamespace(assocdef);
        this.visitElements(assoc);
        this.removeNamespace();
        return assocdef;
    }

    private ViewDef visitView(View view) {
        ViewDef viewdef = this.findViewDef(view);
        viewdef.setName(new NlsString(this.modelLanguage, view.getName()));
        String ilidoc = view.getDocumentation();
        if (ilidoc != null) {
            viewdef.setDocumentation(new NlsString(this.modelLanguage, ilidoc));
        }
        this.makeSyntax.printView(view);
        viewdef.setSyntax(new NlsString(this.modelLanguage, this.getSyntax()));
        this.getNamespace().addOwnedElement(viewdef);
        return viewdef;
    }

    private GraphicDef visitGraphic(Graphic graph) {
        GraphicDef gfxdef = this.findGraphicDef(graph);
        gfxdef.setName(new NlsString(this.modelLanguage, graph.getName()));
        String ilidoc = graph.getDocumentation();
        if (ilidoc != null) {
            gfxdef.setDocumentation(new NlsString(this.modelLanguage, ilidoc));
        }
        this.makeSyntax.printGraphic(graph);
        gfxdef.setSyntax(new NlsString(this.modelLanguage, this.getSyntax()));
        this.getNamespace().addOwnedElement(gfxdef);
        return gfxdef;
    }

    private UnitDef visitUnit(Unit u) {
        String ilidoc;
        UnitDef unitdef = this.findUnitDef(u);
        unitdef.setName(new NlsString(this.modelLanguage, u.getName()));
        if (!u.getDocName().equals(u.getName())) {
            unitdef.setDescName(new NlsString(this.modelLanguage, u.getDocName()));
        }
        if ((ilidoc = u.getDocumentation()) != null) {
            unitdef.setDocumentation(new NlsString(this.modelLanguage, ilidoc));
        }
        this.makeSyntax.printUnit(u.getContainer(), u);
        unitdef.setSyntax(new NlsString(this.modelLanguage, this.getSyntax()));
        this.getNamespace().addOwnedElement(unitdef);
        return unitdef;
    }

    private void visitParameter(Parameter par) {
        ParameterDef paramdef = new ParameterDef();
        paramdef.setName(new NlsString(this.modelLanguage, par.getName()));
        String ilidoc = par.getDocumentation();
        if (ilidoc != null) {
            paramdef.setDocumentation(new NlsString(this.modelLanguage, ilidoc));
        }
        this.makeSyntax.printParameter(par.getContainer(), par);
        paramdef.setSyntax(new NlsString(this.modelLanguage, this.getSyntax()));
        ((ClassDef)this.getNamespace()).addParameterDef(paramdef);
    }

    private ch.ehi.interlis.graphicdescriptions.GraphicParameterDef visitRuntimeParameterDef(GraphicParameterDef par) {
        ch.ehi.interlis.graphicdescriptions.GraphicParameterDef pdef = this.findGraphicParameterDef(par);
        pdef.setName(new NlsString(this.modelLanguage, par.getName()));
        String ilidoc = par.getDocumentation();
        if (ilidoc != null) {
            pdef.setDocumentation(new NlsString(this.modelLanguage, ilidoc));
        }
        this.makeSyntax.printGraphicParameterDef(par);
        pdef.setSyntax(new NlsString(this.modelLanguage, this.getSyntax()));
        this.getNamespace().addOwnedElement(pdef);
        return pdef;
    }

    private MetaDataUseDef visitMetaDataUseDef(ch.interlis.ili2c.metamodel.MetaDataUseDef mu) {
        TransferDescription td;
        DataContainer basket;
        MetaDataUseDef mdef = new MetaDataUseDef();
        mdef.setName(new NlsString(this.modelLanguage, mu.getName()));
        String ilidoc = mu.getDocumentation();
        if (ilidoc != null) {
            mdef.setDocumentation(new NlsString(this.modelLanguage, ilidoc));
        }
        if ((basket = (td = (TransferDescription)mu.getContainer(TransferDescription.class)).getMetaDataContainer(mu.getScopedName((Container)null))) != null) {
            mdef.setBasketOid(basket.getBoid());
        }
        this.makeSyntax.printMetaDataUseDef(mu);
        mdef.setSyntax(new NlsString(this.modelLanguage, this.getSyntax()));
        this.getNamespace().addOwnedElement(mdef);
        return mdef;
    }

    private void visitConstraint(Constraint constr) {
        ConstraintDef cdef = new ConstraintDef();
        ConstraintExpression expr = new ConstraintExpression();
        this.makeSyntax.printConstraint(constr);
        expr.setSyntax(new NlsString(this.modelLanguage, this.getSyntax()));
        cdef.setBody(expr);
        String ilidoc = constr.getDocumentation();
        if (ilidoc != null) {
            cdef.setDocumentation(new NlsString(this.modelLanguage, ilidoc));
        }
        this.getNamespace().addConstraint(cdef);
    }

    private Multiplicity visitCardinality(Cardinality card) {
        UmlMultiplicityRange mr = new UmlMultiplicityRange();
        mr.setLower(card.getMinimum());
        mr.setUpper(card.getMaximum() != Long.MAX_VALUE ? card.getMaximum() : Long.MAX_VALUE);
        UmlMultiplicity m = new UmlMultiplicity();
        m.addRange(mr);
        return m;
    }

    private void visitAttribute(AttributeDef attrib, int attrIdx) {
        ch.interlis.ili2c.metamodel.Type btype = attrib.getDomain();
        boolean isMultiValueAttr = false;
        if (btype instanceof CompositionType) {
            if (this.isMultiValueAttributeWrapper(btype)) {
                isMultiValueAttr = true;
            } else {
                CompositionType type = (CompositionType)btype;
            }
        } else if (btype instanceof ReferenceType) {
            ReferenceType type = (ReferenceType)btype;
            AssociationDef assoc = new AssociationDef();
            ClassDef dest = this.findClassDef((Table)type.getReferred());
            Class thisclass = (Class)this.getNamespace();
            assoc.setName(new NlsString(this.modelLanguage, dest.getDefLangName() + thisclass.getDefLangName()));
            RoleDef destRole = new RoleDef();
            destRole.setName(new NlsString(this.modelLanguage, attrib.getName()));
            String ilidoc = attrib.getDocumentation();
            if (ilidoc != null) {
                destRole.setDocumentation(new NlsString(this.modelLanguage, ilidoc));
            }
            this.visitMetaValues(destRole, attrib.getMetaValues());
            destRole.attachParticipant(dest);
            destRole.setIliAttributeIdx(attrIdx);
            UmlMultiplicityRange r = new UmlMultiplicityRange();
            r.setLower(btype.isMandatory() ? 1L : 0L);
            r.setUpper(1L);
            UmlMultiplicity m = new UmlMultiplicity();
            m.addRange(r);
            destRole.setMultiplicity(m);
            destRole.setPropExtended(attrib.getExtending() != null);
            destRole.setPropExternal(type.isExternal());
            assoc.addConnection(destRole);
            RoleDef srcRole = new RoleDef();
            srcRole.attachParticipant(thisclass);
            srcRole.setName(thisclass.getName());
            srcRole.setIliAttributeKind(3);
            assoc.addConnection(srcRole);
            Iterator<ch.interlis.ili2c.metamodel.AbstractClassDef> rIt = type.iteratorRestrictedTo();
            while (rIt.hasNext()) {
                destRole.addRestriction(this.findClassDef((Table)rIt.next()));
            }
            thisclass.getNamespace().addOwnedElement(assoc);
            return;
        }
        ch.ehi.interlis.attributes.AttributeDef attrdef = new ch.ehi.interlis.attributes.AttributeDef();
        attrdef.setName(new NlsString(this.modelLanguage, attrib.getName()));
        attrdef.setAbstract(attrib.isAbstract());
        attrdef.setPropFinal(attrib.isFinal());
        attrdef.setPropExtended(attrib.getExtending() != null);
        attrdef.setPropTransient(attrib.isTransient());
        String ilidoc = attrib.getDocumentation();
        if (ilidoc != null) {
            attrdef.setDocumentation(new NlsString(this.modelLanguage, ilidoc));
        }
        this.visitMetaValues(attrdef, attrib.getMetaValues());
        this.makeSyntax.printAttributeBasePath(attrib.getContainer(), attrib);
        String ilitxt = StringUtility.purge(this.getSyntax());
        if (ilitxt != null) {
            AttributeValueUsage value = new AttributeValueUsage();
            value.setSyntax(new NlsString(this.modelLanguage, ilitxt));
            attrdef.attachAttributeValueUsage(value);
        }
        DomainAttribute battrtype = null;
        Multiplicity m = null;
        if (btype instanceof CompositionType) {
            if (isMultiValueAttr) {
                DomainAttribute attrtype;
                battrtype = attrtype = new DomainAttribute();
                CompositionType type = (CompositionType)btype;
                attrdef.setOrdering(type.isOrdered() ? 2 : 1);
                m = this.visitCardinality(type.getCardinality());
                LocalAttribute wrappedValue = (LocalAttribute)type.getComponentType().getElement(LocalAttribute.class, "value");
                TypeAlias wrappedValueType = (TypeAlias)wrappedValue.getDomain();
                attrtype.attachDomainDef(this.findDomainDef(wrappedValueType.getAliasing()));
            } else {
                DomainAttribute attrtype;
                CompositionType type = (CompositionType)btype;
                battrtype = attrtype = new DomainAttribute();
                StructAttrType structAttrType = new StructAttrType();
                attrdef.setOrdering(type.isOrdered() ? 2 : 1);
                if (type.getComponentType() != this.ilibase.ANYSTRUCTURE) {
                    structAttrType.attachParticipant(this.findClassDef(type.getComponentType()));
                }
                Iterator<Table> rIt = type.iteratorRestrictedTo();
                while (rIt.hasNext()) {
                    structAttrType.addRestrictedTo(this.findClassDef(rIt.next()));
                }
                attrtype.attachDirect(structAttrType);
                m = this.visitCardinality(type.getCardinality());
            }
        } else {
            if (attrib instanceof LocalAttribute) {
                DomainAttribute attrtype;
                battrtype = attrtype = new DomainAttribute();
                if (btype instanceof TypeAlias) {
                    Domain predefinedBaseDomain = ((TypeAlias)btype).getAliasing();
                    if (predefinedBaseDomain == this.ilibase.BOOLEAN || predefinedBaseDomain == this.ilibase.HALIGNMENT || predefinedBaseDomain == this.ilibase.VALIGNMENT || predefinedBaseDomain == this.ilibase.NAME || predefinedBaseDomain == this.ilibase.URI) {
                        attrtype.attachDirect(this.visitType(attrib.getContainer(), predefinedBaseDomain.getType()));
                    } else {
                        TypeAlias type = (TypeAlias)btype;
                        attrtype.attachDomainDef(this.findDomainDef(type.getAliasing()));
                    }
                } else if (btype != null) {
                    attrtype.attachDirect(this.visitType(attrib.getContainer(), btype));
                }
            }
            UmlMultiplicityRange r = new UmlMultiplicityRange();
            r.setLower(btype.isMandatory() ? 1L : 0L);
            r.setUpper(1L);
            m = new UmlMultiplicity();
            m.addRange(r);
        }
        attrdef.setMultiplicity(m);
        attrdef.attachAttrType(battrtype);
        ((Classifier)this.getNamespace()).addFeature(attrdef);
    }

    private boolean isMultiValueAttributeWrapper(ch.interlis.ili2c.metamodel.Type btype) {
        if (!(btype instanceof CompositionType)) {
            return false;
        }
        CompositionType type = (CompositionType)btype;
        Table table = type.getComponentType();
        Iterator<ViewableTransferElement> attrIter = table.getAttributesAndRoles2();
        if (!attrIter.hasNext()) {
            return false;
        }
        ViewableTransferElement attr = attrIter.next();
        if (attrIter.hasNext()) {
            return false;
        }
        if (!(attr.obj instanceof LocalAttribute)) {
            return false;
        }
        LocalAttribute a = (LocalAttribute)attr.obj;
        if (!a.getName().equals("value")) {
            return false;
        }
        if (!(a.getDomain() instanceof TypeAlias)) {
            return false;
        }
        TypeAlias attrType = (TypeAlias)a.getDomain();
        return table.getName().equals(attrType.getAliasing().getName() + "_");
    }

    private void visitRoleDef(ch.interlis.ili2c.metamodel.RoleDef role) {
        Iterator<ReferenceType> ri;
        RoleDef roledef = new RoleDef();
        roledef.setName(new NlsString(this.modelLanguage, role.getName()));
        String ilidoc = role.getDocumentation();
        if (ilidoc != null) {
            roledef.setDocumentation(new NlsString(this.modelLanguage, ilidoc));
        }
        this.visitMetaValues(roledef, role.getMetaValues());
        roledef.setAbstract(role.isAbstract());
        roledef.setPropFinal(role.isFinal());
        roledef.setPropExternal(role.isExternal());
        roledef.setPropExtended(role.getExtending() != null);
        roledef.setOrdering(role.isOrdered() ? 2 : 1);
        switch (role.getKind()) {
            case 1: {
                roledef.setAggregation(1);
                break;
            }
            case 2: {
                roledef.setAggregation(2);
                break;
            }
            case 3: {
                roledef.setAggregation(3);
            }
        }
        if (role.getCardinality() != null) {
            roledef.setMultiplicity(this.visitCardinality(role.getCardinality()));
        }
        if ((ri = role.iteratorReference()).hasNext()) {
            ReferenceType first = ri.next();
            roledef.attachParticipant(this.findViewable(first.getReferred()));
            Iterator<ch.interlis.ili2c.metamodel.AbstractClassDef> resti = first.iteratorRestrictedTo();
            while (resti.hasNext()) {
                ch.interlis.ili2c.metamodel.AbstractClassDef rest = resti.next();
                roledef.addRestriction((AbstractClassDef)this.findViewable(rest));
            }
            while (ri.hasNext()) {
                ReferenceType r = ri.next();
                Participant p = new Participant();
                roledef.addXorParticipant(p);
                p.attachParticipant((AbstractClassDef)this.findViewable(r.getReferred()));
                resti = r.iteratorRestrictedTo();
                while (resti.hasNext()) {
                    ch.interlis.ili2c.metamodel.AbstractClassDef rest = resti.next();
                    p.addRestriction((AbstractClassDef)this.findViewable(rest));
                }
            }
        }
        ((Association)((Object)this.getNamespace())).addConnection(roledef);
    }

    private void updateMappingToPredefinedModel(Package root) {
        if (!NamespaceUtility.deepContainsOwnedElement(root, ModelDef.class, this.ilibase.getName())) {
            return;
        }
        ModelDef modelDef = (ModelDef)NamespaceUtility.deepGetOwnedElement(root, ModelDef.class, this.ilibase.getName());
        this.modelMap.put(this.ilibase, modelDef);
        for (Element elt : this.ilibase) {
            if (elt instanceof Unit) {
                UnitDef unitDef = (UnitDef)NamespaceUtility.deepGetOwnedElement(modelDef, UnitDef.class, elt.getName());
                this.unitMap.put(elt, unitDef);
                continue;
            }
            if (elt instanceof Function) {
                FunctionDef funcDef = (FunctionDef)NamespaceUtility.deepGetOwnedElement(modelDef, FunctionDef.class, elt.getName());
                this.functionMap.put(elt, funcDef);
                continue;
            }
            if (elt instanceof Domain) {
                DomainDef domainDef = (DomainDef)NamespaceUtility.deepGetOwnedElement(modelDef, DomainDef.class, elt.getName());
                this.domainMap.put(elt, domainDef);
                continue;
            }
            if (!(elt instanceof Table) || ((Table)elt).isImplicit()) continue;
            ClassDef classDef = (ClassDef)NamespaceUtility.deepGetOwnedElement(modelDef, ClassDef.class, elt.getName());
            this.viewableMap.put(elt, classDef);
        }
    }

    private String getPredefinedName() {
        return "<" + rsrc.getString("CTpredefinedModel") + ">";
    }

    private ModelDef visitModel(Model mdef) {
        if (mdef == this.ilibase && this.modelMap.containsKey(mdef)) {
            return null;
        }
        ModelDef model = this.findModelDef(mdef);
        this.modelLanguage = "";
        if (mdef.getLanguage() != null) {
            this.modelLanguage = mdef.getLanguage();
            model.setBaseLanguage(mdef.getLanguage());
        } else {
            this.modelLanguage = "";
            model.setBaseLanguage(this.modelLanguage);
        }
        model.setName(new NlsString(this.modelLanguage, mdef.getName()));
        String ilidoc = mdef.getDocumentation();
        if (ilidoc != null) {
            model.setDocumentation(new NlsString(this.modelLanguage, ilidoc));
        }
        this.visitMetaValues(model, mdef.getMetaValues());
        if (mdef instanceof DataModel) {
            model.setKind(1);
        } else if (mdef instanceof TypeModel) {
            model.setKind(2);
        } else if (mdef instanceof RefSystemModel) {
            model.setKind(3);
        } else if (mdef instanceof SymbologyModel) {
            model.setKind(4);
        }
        model.setVersion(new NlsString(this.modelLanguage, mdef.getModelVersion()));
        String verCmt = mdef.getModelVersionExpl();
        if (verCmt != null) {
            model.setVersionComment(new NlsString(this.modelLanguage, verCmt));
        }
        model.setIssuerURI(new NlsString(this.modelLanguage, mdef.getIssuer()));
        model.setContracted(mdef.isContracted());
        Model[] imported = mdef.getImporting();
        if (imported.length > 0) {
            for (int i = 0; i < imported.length; ++i) {
                Model curImport = imported[i];
                if (curImport == this.ilibase) continue;
                ModelDef supplier = this.findModelDef(curImport);
                IliImport iliimport = new IliImport();
                iliimport.addSupplier(supplier);
                iliimport.addClient(model);
            }
        }
        INTERLIS2Def ili2def = null;
        if (mdef == this.ilibase) {
            ili2def = this.findINTERLIS2Def(this.modelLanguage, this.getPredefinedName());
            ili2def.setVersion(new Double(mdef.getIliVersion()));
        } else {
            File cache = new File(System.getProperty("user.home"), ".ilicache");
            File ilifile = new File(mdef.getFileName());
            String iliFileName = ilifile.getName();
            if (ilifile.getAbsoluteFile().getParent().startsWith(cache.getAbsolutePath())) {
                iliFileName = "<" + iliFileName + ">";
            }
            ili2def = this.findINTERLIS2Def(this.modelLanguage, iliFileName);
            ili2def.setVersion(new Double(mdef.getIliVersion()));
        }
        ili2def.addOwnedElement(model);
        this.addNamespace(model);
        this.visitElements(mdef);
        CreateDiagramUtility.topicOverview(model);
        this.removeNamespace();
        return model;
    }

    private void visitMetaValues(ModelElement ele, Settings values) {
        if (values != null) {
            Iterator<String> valuei = values.getValuesIterator();
            while (valuei.hasNext()) {
                String name = valuei.next();
                String value = values.getValue(name);
                TaggedValue umlTag = (TaggedValue)ElementFactory.createObject(UmlTaggedValue.class);
                umlTag.setName(new NlsString("", TAGGEDVALUE_ILI_PREFIX + name));
                umlTag.setDataValue(value);
                ele.addTaggedValue(umlTag);
            }
        }
    }

    private DomainDef visitDomainDef(Domain dd) {
        ch.interlis.ili2c.metamodel.Type predefinedBaseType;
        ch.interlis.ili2c.metamodel.Type btype;
        DomainDef domaindef = this.findDomainDef(dd);
        domaindef.setName(new NlsString(this.modelLanguage, dd.getName()));
        String ilidoc = dd.getDocumentation();
        if (ilidoc != null) {
            domaindef.setDocumentation(new NlsString(this.modelLanguage, ilidoc));
        }
        this.visitMetaValues(domaindef, dd.getMetaValues());
        domaindef.setAbstract(dd.isAbstract());
        domaindef.setPropFinal(dd.isFinal());
        Domain extending = dd.getExtending();
        if (extending != null) {
            DomainDef parent = this.findDomainDef(extending);
            DomainExtends domainextends = new DomainExtends();
            domainextends.attachParent(parent);
            domainextends.attachChild(domaindef);
        }
        if ((btype = dd.getType()) instanceof TypeAlias && ((predefinedBaseType = btype.resolveAliases()) == this.ilibase.BOOLEAN.getType() || predefinedBaseType == this.ilibase.HALIGNMENT.getType() || predefinedBaseType == this.ilibase.VALIGNMENT.getType() || predefinedBaseType == this.ilibase.NAME.getType() || predefinedBaseType == this.ilibase.URI.getType())) {
            btype = predefinedBaseType;
        }
        Type type = this.visitType(dd.getContainer(), btype);
        domaindef.attachType(type);
        this.getNamespace().addOwnedElement(domaindef);
        return domaindef;
    }

    private Type visitType(Container scope, ch.interlis.ili2c.metamodel.Type dd) {
        Type ret = null;
        if (dd == this.ilibase.BOOLEAN.getType()) {
            ret = new BooleanType();
        } else if (dd == this.ilibase.HALIGNMENT.getType()) {
            ret = new HorizAlignment();
        } else if (dd == this.ilibase.VALIGNMENT.getType()) {
            ret = new VertAlignment();
        } else if (dd == this.ilibase.NAME.getType()) {
            Text text = new Text();
            ret = text;
            text.setKind(3);
        } else if (dd == this.ilibase.URI.getType()) {
            Text text = new Text();
            ret = text;
            text.setKind(4);
        } else {
            if (dd instanceof ch.interlis.ili2c.metamodel.NumericType) {
                return this.visitNumericalType(scope, (ch.interlis.ili2c.metamodel.NumericType)dd);
            }
            if (dd instanceof TextType) {
                int len = ((TextType)dd).getMaxLength();
                Text text = new Text();
                ret = text;
                if (len != -1) {
                    text.setKind(2);
                    text.setMaxLength(len);
                } else {
                    text.setKind(1);
                }
                text.setMultiline(!((TextType)dd).isNormalized());
            } else if (dd instanceof EnumerationType) {
                EnumerationType et = (EnumerationType)dd;
                ch.ehi.interlis.domainsandconstants.basetypes.Enumeration enumeration = this.visitEnumeration(et.getEnumeration());
                ret = enumeration;
                if (et.isCircular()) {
                    enumeration.setKind(3);
                } else if (et.isOrdered()) {
                    enumeration.setKind(2);
                } else {
                    enumeration.setKind(1);
                }
            } else if (dd instanceof CoordType) {
                CoordinateType coord = new CoordinateType();
                ret = coord;
                ch.interlis.ili2c.metamodel.NumericalType[] nts = ((CoordType)dd).getDimensions();
                for (int i = 0; i < nts.length; ++i) {
                    coord.addDim(this.visitNumericalType(scope, nts[i]));
                }
                int nullAxis = ((CoordType)dd).getNullAxis();
                int piHalfAxis = ((CoordType)dd).getPiHalfAxis();
                if (nullAxis != 0) {
                    RotationDef rot = new RotationDef();
                    rot.setNullAxis(nullAxis);
                    rot.setPihalfAxis(piHalfAxis);
                    coord.attachRotationDef(rot);
                }
            } else if (dd instanceof ch.interlis.ili2c.metamodel.LineType) {
                ch.interlis.ili2c.metamodel.LineType lt = (ch.interlis.ili2c.metamodel.LineType)dd;
                LineType line = null;
                if (lt instanceof PolylineType) {
                    line = new IliPolyline();
                    ((IliPolyline)line).setDirected(((PolylineType)lt).isDirected());
                } else if (lt instanceof ch.interlis.ili2c.metamodel.SurfaceType) {
                    line = new IndividualSurface();
                } else if (lt instanceof AreaType) {
                    line = new Tesselation();
                }
                ret = line;
                LineForm[] lineForms = lt.getLineForms();
                PrecisionDecimal maxOverlap = lt.getMaxOverlap();
                Domain controlPointDomain = lt.getControlPointDomain();
                Table lineAttributeStructure = null;
                if (lt instanceof SurfaceOrAreaType) {
                    lineAttributeStructure = ((SurfaceOrAreaType)lt).getLineAttributeStructure();
                }
                if (lineForms.length > 0) {
                    ch.ehi.interlis.domainsandconstants.linetypes.LineForm lf = new ch.ehi.interlis.domainsandconstants.linetypes.LineForm();
                    line.attachLineForm(lf);
                    for (int i = 0; i < lineForms.length; ++i) {
                        if (lineForms[i] == this.ilibase.ARCS) {
                            lf.setArcs(true);
                            continue;
                        }
                        if (lineForms[i] == this.ilibase.STRAIGHTS) {
                            lf.setStraights(true);
                            continue;
                        }
                        lf.addLineFormTypeDef(this.findLineFormTypeDef(lineForms[i]));
                    }
                }
                if (controlPointDomain != null) {
                    line.attachControlpoints(this.findDomainDef(controlPointDomain));
                }
                if (maxOverlap != null) {
                    IntersectionDef is = new IntersectionDef();
                    is.setMaxi(this.visitIliDim(maxOverlap));
                    line.attachIntersectionDef(is);
                }
                if (lineAttributeStructure != null) {
                    ((SurfaceType)line).attachLinAttrDef(this.findClassDef(lineAttributeStructure));
                }
            } else if (dd instanceof OIDType) {
                OidType oid = new OidType();
                ret = oid;
                if (dd instanceof AnyOIDType) {
                    oid.setKind(1);
                } else if (dd instanceof TextOIDType) {
                    oid.setKind(2);
                    oid.attachOiddomain((BaseType)this.visitType(scope, ((OIDType)dd).getOIDType()));
                } else if (dd instanceof NumericOIDType) {
                    oid.setKind(3);
                    oid.attachOiddomain((BaseType)this.visitType(scope, ((OIDType)dd).getOIDType()));
                }
            } else if (dd instanceof ch.interlis.ili2c.metamodel.ClassType) {
                ClassType classtype = new ClassType();
                ret = classtype;
                ch.interlis.ili2c.metamodel.ClassType ct = (ch.interlis.ili2c.metamodel.ClassType)dd;
                if (ct.isStructure()) {
                    classtype.setKind(2);
                } else {
                    classtype.setKind(1);
                }
                Iterator<Viewable<?>> ri = ct.iteratorRestrictedTo();
                while (ri.hasNext()) {
                    Table r = (Table)ri.next();
                    classtype.addRestrictedTo(this.findClassDef(r));
                }
            } else {
                UnknownType ukn = new UnknownType();
                ret = ukn;
                this.makeSyntax.printType(scope, dd);
                ukn.setSyntax(new NlsString(this.modelLanguage, this.getSyntax()));
            }
        }
        return ret;
    }

    private NumericalType visitNumericalType(Container scope, ch.interlis.ili2c.metamodel.NumericalType btype) {
        NumericalType ret = null;
        if (btype instanceof ch.interlis.ili2c.metamodel.NumericType) {
            ch.interlis.ili2c.metamodel.NumericType type = (ch.interlis.ili2c.metamodel.NumericType)btype;
            PrecisionDecimal min = type.getMinimum();
            PrecisionDecimal max = type.getMaximum();
            NumericType umlType = new NumericType();
            ret = umlType;
            if (min == null) {
                umlType.setRangeDefined(false);
            } else {
                umlType.setRangeDefined(true);
                umlType.setMinDec(this.visitIliDim(min));
                umlType.setMaxDec(this.visitIliDim(max));
            }
        } else if (btype instanceof ch.interlis.ili2c.metamodel.StructuredUnitType) {
            StructuredUnitType umlType = new StructuredUnitType();
            ret = umlType;
            umlType.setMinStruc(this.visitStructDec(((ch.interlis.ili2c.metamodel.StructuredUnitType)btype).getMinimum()));
            umlType.setMaxStruc(this.visitStructDec(((ch.interlis.ili2c.metamodel.StructuredUnitType)btype).getMaximum()));
        }
        ret.setCircular(btype.isCircular());
        if (btype.getUnit() != null) {
            ret.attachUnitDef(this.findUnitDef(btype.getUnit()));
        }
        switch (btype.getRotation()) {
            case 2: {
                ret.setDirection(3);
                break;
            }
            case 1: {
                ret.setDirection(2);
                break;
            }
            case 0: {
                ret.setDirection(1);
            }
        }
        if (btype.getReferenceSystem() != null) {
            this.makeSyntax.printReferenceSysRef(scope, btype.getReferenceSystem());
            RefSys refsys = new RefSys();
            refsys.setSyntax(new NlsString(this.modelLanguage, this.getSyntax()));
            ret.attachRefSys(refsys);
        }
        return ret;
    }

    private StructDec visitStructDec(Constant.Structured val) {
        return StructDec.parseStructDec(val.toString());
    }

    private IliDim visitIliDim(PrecisionDecimal val) {
        IliDim ret = new IliDim();
        ret.setValue(val.doubleValue());
        ret.setBase10shift(val.getExponent());
        ret.setAccuracy(val.getAccuracy());
        return ret;
    }

    private ch.ehi.interlis.domainsandconstants.basetypes.Enumeration visitEnumeration(Enumeration enumer) {
        ch.ehi.interlis.domainsandconstants.basetypes.Enumeration ret = new ch.ehi.interlis.domainsandconstants.basetypes.Enumeration();
        Iterator<Enumeration.Element> iter = enumer.getElements();
        while (iter.hasNext()) {
            ret.addEnumElement(this.visitEnumerationElement(iter.next()));
        }
        return ret;
    }

    private EnumElement visitEnumerationElement(Enumeration.Element ee) {
        EnumElement ret = new EnumElement();
        ret.setName(new NlsString(this.modelLanguage, ee.getName()));
        String ilidoc = ee.getDocumentation();
        if (ilidoc != null) {
            ret.setDocumentation(new NlsString(this.modelLanguage, ilidoc));
        }
        this.visitMetaValues(ret, ee.getMetaValues());
        Enumeration subEnum = ee.getSubEnumeration();
        if (subEnum != null) {
            ret.attachChild(this.visitEnumeration(subEnum));
        }
        return ret;
    }

    private LineFormTypeDef visitLineFormTypeDef(LineForm lf) {
        Table struct;
        LineFormTypeDef lfdef = this.findLineFormTypeDef(lf);
        lfdef.setName(new NlsString(this.modelLanguage, lf.getName()));
        String ilidoc = lf.getDocumentation();
        if (ilidoc != null) {
            lfdef.setDocumentation(new NlsString(this.modelLanguage, ilidoc));
        }
        if ((struct = lf.getSegmentStructure()) != null) {
            lfdef.attachStructure(this.findClassDef(struct));
        }
        this.getNamespace().addOwnedElement(lfdef);
        return lfdef;
    }

    private FunctionDef visitFunctionDeclaration(Function f) {
        FunctionDef funcdef = this.findFunctionDef(f);
        funcdef.setName(new NlsString(this.modelLanguage, f.getName()));
        String ilidoc = f.getDocumentation();
        if (ilidoc != null) {
            funcdef.setDocumentation(new NlsString(this.modelLanguage, ilidoc));
        }
        this.makeSyntax.printFunctionDeclaration(f.getContainer(), f);
        funcdef.setSyntax(new NlsString(this.modelLanguage, this.getSyntax()));
        this.getNamespace().addOwnedElement(funcdef);
        return funcdef;
    }

    private void visitElements(Container container) {
        AbstractModelElement lastUmlEle = null;
        AbstractModelElement nextUmlEle = null;
        int attrIdx = 0;
        for (Element elt : container) {
            if (elt instanceof Model) {
                nextUmlEle = this.visitModel((Model)elt);
            } else if (elt instanceof ch.interlis.ili2c.metamodel.MetaDataUseDef) {
                nextUmlEle = this.visitMetaDataUseDef((ch.interlis.ili2c.metamodel.MetaDataUseDef)elt);
            } else if (elt instanceof Unit) {
                nextUmlEle = this.visitUnit((Unit)elt);
            } else if (elt instanceof Function) {
                nextUmlEle = this.visitFunctionDeclaration((Function)elt);
            } else if (elt instanceof LineForm) {
                nextUmlEle = this.visitLineFormTypeDef((LineForm)elt);
            } else if (elt instanceof Domain) {
                nextUmlEle = this.visitDomainDef((Domain)elt);
            } else if (elt instanceof GraphicParameterDef) {
                nextUmlEle = this.visitRuntimeParameterDef((GraphicParameterDef)elt);
            } else if (elt instanceof Topic) {
                nextUmlEle = this.visitTopicDef((Topic)elt);
            } else if (elt instanceof ch.interlis.ili2c.metamodel.AssociationDef) {
                nextUmlEle = this.visitAssociationDef((ch.interlis.ili2c.metamodel.AssociationDef)elt);
            } else if (elt instanceof Table) {
                if (!((Table)elt).isImplicit()) {
                    nextUmlEle = this.visitClassDef((Table)elt);
                }
            } else if (elt instanceof View) {
                nextUmlEle = this.visitView((View)elt);
            } else if (elt instanceof Graphic) {
                nextUmlEle = this.visitGraphic((Graphic)elt);
            } else if (elt instanceof AttributeDef) {
                this.visitAttribute((AttributeDef)elt, attrIdx);
                ++attrIdx;
            }
            if (elt instanceof ch.interlis.ili2c.metamodel.RoleDef) {
                this.visitRoleDef((ch.interlis.ili2c.metamodel.RoleDef)elt);
            } else if (elt instanceof Parameter) {
                this.visitParameter((Parameter)elt);
            } else if (elt instanceof Constraint) {
                this.visitConstraint((Constraint)elt);
            }
            if (nextUmlEle != null && lastUmlEle != null) {
                ElementFactory.createDependency(UmlUsage.class, nextUmlEle, lastUmlEle);
            }
            if (nextUmlEle == null) continue;
            lastUmlEle = nextUmlEle;
            nextUmlEle = null;
        }
    }

    private void visitMetaDataFiles(ch.ehi.uml1_4.modelmanagement.Model model, Configuration config) {
        Iterator it = config.iteratorFileEntry();
        while (it.hasNext()) {
            FileEntry fileIli = (FileEntry)it.next();
            if (fileIli.getKind() != 2) continue;
            MetaObjectFile fileUml = new MetaObjectFile();
            fileUml.setName(new NlsString("", TransferFromIli2cMetamodel.getBasename(fileIli.getFilename())));
            model.addOwnedElement(fileUml);
        }
    }

    private String getSyntax() {
        String syntax = this.syntaxBuffer.toString();
        this.syntaxBuffer.getBuffer().setLength(0);
        return syntax;
    }

    public void visitTransferDescription(ch.ehi.uml1_4.modelmanagement.Model umlModel, TransferDescription td, String configFilename, Configuration config) {
        this.syntaxBuffer = new StringWriter();
        this.makeSyntax = Interlis2Generator.generateElements(this.syntaxBuffer, td);
        this.ilibase = td.INTERLIS;
        this.updateMappingToPredefinedModel(umlModel);
        this.ili2modelset = new UmlPackage();
        if (configFilename != null) {
            this.ili2modelset.setName(new NlsString("", TransferFromIli2cMetamodel.getBasename(configFilename)));
        } else {
            this.ili2modelset.setName(new NlsString(rsrc.getString("CTunnamedModelsetName") + Integer.toString(uniqueName)));
            ++uniqueName;
        }
        this.visitElements(td);
        umlModel.addOwnedElement(this.ili2modelset);
        this.visitMetaDataFiles(umlModel, config);
    }

    public void loadPredefinedIli2cModel(Package root) {
        TransferDescription td = new TransferDescription();
        this.syntaxBuffer = new StringWriter();
        this.makeSyntax = Interlis2Generator.generateElements(this.syntaxBuffer, td);
        this.ilibase = td.INTERLIS;
        this.ili2modelset = root;
        this.visitElements(td);
    }

    private static String getBasename(String filename) {
        return new File(filename).getName();
    }

    public String getFuncDesc() {
        return rsrc.getString("CIiliimport");
    }
}

