/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.math;

import ch.softenvironment.math.DoubleMatrix;

public class DoubleVector {
    protected double[] v;

    public DoubleVector(double[] array) {
        this(array.length);
        for (int i = 0; i < this.size(); ++i) {
            this.v[i] = array[i];
        }
    }

    public DoubleVector(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.v = new double[initialCapacity];
        for (int i = 0; i < initialCapacity; ++i) {
            this.v[i] = 0.0;
        }
    }

    public DoubleVector(DoubleVector a) {
        this(a.size());
        for (int i = 0; i < a.size(); ++i) {
            this.v[i] = a.v[i];
        }
    }

    public DoubleVector divide(double scalar) {
        for (int i = 0; i < this.size(); ++i) {
            this.v[i] = this.v[i] / scalar;
        }
        return this;
    }

    public double dot(DoubleVector a) {
        if (this.size() != a.size()) {
            // empty if block
        }
        double r = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            r += this.v[i] * a.v[i];
        }
        return r;
    }

    public boolean equals(Object obj) {
        DoubleVector vec = (DoubleVector)obj;
        if (this.size() != vec.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.v[i] == vec.v[i]) continue;
            return false;
        }
        return true;
    }

    public double get(int index) {
        this.rangeCheck(index);
        return this.v[index];
    }

    public double getAbs() {
        double sum = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            sum += this.v[i] * this.v[i];
        }
        return Math.sqrt(sum);
    }

    public static DoubleVector getConstantInstance(int vectorSize, double scalar) {
        DoubleVector vec = new DoubleVector(vectorSize);
        for (int i = 0; i < vectorSize; ++i) {
            vec.v[i] = scalar;
        }
        return vec;
    }

    public DoubleVector getCross(DoubleVector b) {
        if (this.size() < 3 || b.size() < 3) {
            // empty if block
        }
        DoubleVector c = new DoubleVector(this.size());
        c.v[0] = this.v[1] * b.v[2] - this.v[2] * b.v[1];
        c.v[1] = -this.v[0] * b.v[2] + this.v[2] * b.v[0];
        c.v[2] = this.v[0] * b.v[1] - this.v[1] * b.v[0];
        return c;
    }

    public DoubleVector getMultiply(DoubleMatrix m) {
        if (m.getNumberOfVectors() != this.size()) {
            // empty if block
        }
        DoubleVector r = new DoubleVector(m.getVectorSize());
        for (int i = 0; i < m.getVectorSize(); ++i) {
            r.v[i] = 0.0;
            for (int j = 0; j < m.getNumberOfVectors(); ++j) {
                int n = i;
                r.v[n] = r.v[n] + m.getCell(i, j) * this.v[j];
            }
        }
        return r;
    }

    public DoubleVector getNorm() {
        double dist = this.getAbs();
        DoubleVector n = new DoubleVector(this.size());
        if (dist == 0.0) {
            // empty if block
        }
        for (int i = 0; i < this.size(); ++i) {
            n.v[i] = this.v[i] / dist;
        }
        return n;
    }

    public double getSpat(DoubleVector b, DoubleVector c) {
        return this.getCross(b).dot(c);
    }

    public DoubleVector minus(DoubleVector a) {
        this.sizeCheck(a);
        for (int i = 0; i < this.size(); ++i) {
            this.v[i] = this.v[i] - a.v[i];
        }
        return this;
    }

    public DoubleVector multiply(double scalar) {
        for (int i = 0; i < this.size(); ++i) {
            this.v[i] = this.v[i] * scalar;
        }
        return this;
    }

    public DoubleVector plus(DoubleVector a) {
        this.sizeCheck(a);
        for (int i = 0; i < this.v.length; ++i) {
            this.v[i] = this.v[i] + a.v[i];
        }
        return this;
    }

    private void rangeCheck(int index) {
        if (index >= this.size() || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
    }

    public void set(int index, double element) {
        this.rangeCheck(index);
        this.v[index] = element;
    }

    public int size() {
        return this.v.length;
    }

    private void sizeCheck(DoubleVector a) {
        if (this.size() != a.size()) {
            throw new IndexOutOfBoundsException("Vectors not of same size: " + this.size() + " !=  " + a.size());
        }
    }

    public String toString() {
        String str = "[";
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                str = str + ", ";
            }
            str = str + this.v[i];
        }
        return str + "]";
    }
}

