/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.basics.geom;

import com.baselet.control.basics.geom.GeometricFunctions;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.enums.Direction;
import java.util.List;
import org.apache.log4j.Logger;

public class Line {
    private static final Logger log = Logger.getLogger(Line.class);
    private final PointDouble start;
    private final PointDouble end;

    public Line(PointDouble pointDouble, PointDouble pointDouble2) {
        this.start = pointDouble;
        this.end = pointDouble2;
    }

    public PointDouble getStart() {
        return this.start;
    }

    public PointDouble getEnd() {
        return this.end;
    }

    public PointDouble getPoint(boolean bl) {
        return bl ? this.getStart() : this.getEnd();
    }

    public PointDouble getCenter() {
        return new PointDouble((this.start.getX() + this.end.getX()) / 2.0, (this.start.getY() + this.end.getY()) / 2.0);
    }

    public double getLength() {
        return GeometricFunctions.distanceBetweenTwoPoints(this.start, this.end);
    }

    public PointDouble getPointOnLineWithDistanceFrom(boolean bl, double d) {
        if (bl) {
            return GeometricFunctions.getPointOnLineWithDistanceFromStart(this.start, this.end, d);
        }
        return GeometricFunctions.getPointOnLineWithDistanceFromStart(this.end, this.start, d);
    }

    public double getAngleOfSlope() {
        double d = this.getLength();
        double d2 = Math.acos((this.start.x - this.end.x) / d);
        double d3 = Math.toDegrees(d2);
        if (this.start.y < this.end.y) {
            d3 = 360.0 - d3;
        }
        return d3;
    }

    public double getDistanceToPoint(PointDouble pointDouble) {
        double d = GeometricFunctions.getDistanceBetweenLineAndPoint(this.start, this.end, pointDouble);
        log.trace((Object)("Minimal distance between " + this + " and " + pointDouble + " is " + d));
        return d;
    }

    public PointDouble[] toPoints() {
        return new PointDouble[]{this.start, this.end};
    }

    public Direction getDirectionOfLine(boolean bl) {
        double d = this.getAngleOfSlope();
        Direction direction = d > 315.0 || d < 45.0 ? Direction.RIGHT : (d < 135.0 ? Direction.DOWN : (d < 225.0 ? Direction.LEFT : Direction.UP));
        if (!bl) {
            direction = direction.invert();
        }
        return direction;
    }

    public List<PointDouble> getIntersectionPoints(Rectangle rectangle) {
        return GeometricFunctions.getIntersectionPoints(this, rectangle);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.end == null ? 0 : this.end.hashCode());
        n = 31 * n + (this.start == null ? 0 : this.start.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Line line = (Line)object;
        if (this.end == null ? line.end != null : !this.end.equals(line.end)) {
            return false;
        }
        return !(this.start == null ? line.start != null : !this.start.equals(line.start));
    }

    public String toString() {
        return "Line [start=" + this.start + ", end=" + this.end + "]";
    }
}

