/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.util;

import com.baselet.control.enums.Program;
import com.baselet.control.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class Path {
    private static String tempDir;
    private static String homeProgramDir;

    public static String config() {
        return String.valueOf(Path.userHome()) + File.separator + Program.getInstance().getConfigName();
    }

    private static String userHome() {
        File homeDirFile;
        String homeDir = Path.userHomeBase();
        if (!homeDir.endsWith(File.separator)) {
            homeDir = String.valueOf(homeDir) + File.separator;
        }
        if (!(homeDirFile = new File(String.valueOf(homeDir) + Program.getInstance().getProgramName())).exists()) {
            Utils.safeMkDir(homeDirFile, true);
        }
        return homeDirFile.getAbsolutePath();
    }

    private static String userHomeBase() {
        try {
            String xdgConfigHome = System.getenv("XDG_CONFIG_HOME");
            if (xdgConfigHome != null) {
                return xdgConfigHome;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return System.getProperty("user.home");
    }

    public static String customElements() {
        return String.valueOf(Path.homeProgram()) + "custom_elements/";
    }

    public static String temp() {
        if (tempDir == null) {
            String tmp = System.getProperty("java.io.tmpdir");
            if (!tmp.endsWith(File.separator)) {
                tmp = String.valueOf(tmp) + File.separator;
            }
            tempDir = tmp;
        }
        return tempDir;
    }

    public static String homeProgram() {
        return homeProgramDir;
    }

    public static void setHomeProgram(String homeProgramDir) {
        Path.homeProgramDir = homeProgramDir;
    }

    public static String executable() {
        String path = null;
        URL codeSourceUrl = Path.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            path = codeSourceUrl.toURI().getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (path == null) {
            path = codeSourceUrl.getPath().replace("%20", " ");
        }
        return path;
    }

    public static Manifest manifest() throws IOException {
        Manifest manifest;
        if (Path.executable().endsWith(".jar")) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(Path.executable());
                manifest = jarFile.getManifest();
            }
            finally {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
        } else {
            FileInputStream is = new FileInputStream(String.valueOf(Path.homeProgram()) + "META-INF" + File.separator + "MANIFEST.MF");
            manifest = new Manifest(is);
            is.close();
        }
        return manifest;
    }
}

