/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.custom;

import com.baselet.control.config.DerivedConfig;
import com.baselet.custom.CustomFunction;
import com.baselet.element.old.custom.CustomElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class CustomCodeSyntaxPane {
    private final JPanel panel;
    private final RTextScrollPane scrollPane;
    private final RSyntaxTextArea textArea;
    private final DefaultCompletionProvider provider = new DefaultCompletionProvider();

    public CustomCodeSyntaxPane() {
        this.panel = new JPanel(new BorderLayout());
        this.textArea = new RSyntaxTextArea();
        this.textArea.setSyntaxEditingStyle("text/java");
        this.textArea.setAntiAliasingEnabled(true);
        this.textArea.setCodeFoldingEnabled(true);
        this.textArea.setFont(DerivedConfig.getPanelContentFont());
        for (String word : this.getAutocompletionStrings()) {
            this.provider.addCompletion(new BasicCompletion(this.provider, word));
        }
        new AutoCompletion(this.provider).install((JTextComponent)this.textArea);
        this.scrollPane = new RTextScrollPane((Component)this.textArea);
        this.scrollPane.setFoldIndicatorEnabled(true);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.panel.add((Component)this.scrollPane);
        this.textArea.getDocument().putProperty("tabSize", 3);
    }

    public String getText() {
        return this.textArea.getText();
    }

    public JTextComponent getTextComponent() {
        return this.textArea;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void setCode(String text) {
        this.textArea.setText(text);
    }

    private String getStringForCustomElementMethod(Method m) {
        CustomFunction cm = m.getAnnotation(CustomFunction.class);
        StringBuilder sb = new StringBuilder("");
        sb.append(m.getName()).append("(");
        String[] params = cm.param_defaults().split(",");
        Class<?>[] types = m.getParameterTypes();
        int i = 0;
        while (i < params.length && i < types.length) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(types[i].getSimpleName()).append(" ").append(params[i].trim());
            ++i;
        }
        return sb.append(");").toString();
    }

    private ArrayList<String> getAutocompletionStrings() {
        ArrayList<String> descriptors = new ArrayList<String>();
        Method[] methodArray = CustomElement.class.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.isAnnotationPresent(CustomFunction.class)) {
                descriptors.add(this.getStringForCustomElementMethod(m));
            }
            ++n2;
        }
        return descriptors;
    }

    public void repaint() {
        if (this.scrollPane != null) {
            this.scrollPane.repaint();
        }
    }
}

