/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram;

import com.baselet.control.enums.Program;
import com.baselet.diagram.StartUpHelpText;
import com.baselet.gui.BrowserLauncher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;
import java.util.TimerTask;

public class UpdateCheckTimerTask
extends TimerTask {
    private static final UpdateCheckTimerTask instance = new UpdateCheckTimerTask();
    private String filename;

    private UpdateCheckTimerTask() {
    }

    public static UpdateCheckTimerTask getInstance() {
        return instance;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public void run() {
        try {
            String newVersionText = UpdateCheckTimerTask.getNewVersionTextWithStartupHtmlFormat();
            if (newVersionText != null) {
                this.filename = StartUpHelpText.createTempFileWithText(newVersionText);
            }
        }
        catch (Exception e) {
            StartUpHelpText.log.error((Object)("Error at checking for new " + Program.getInstance().getProgramName() + " version"), (Throwable)e);
        }
    }

    private static String getNewVersionTextWithStartupHtmlFormat() throws IOException {
        String textFromURL = UpdateCheckTimerTask.getNewVersionTextFromURL();
        if (textFromURL == null) {
            return null;
        }
        return UpdateCheckTimerTask.wrapUpdateTextIntoStartupFileHtmlStyle(textFromURL);
    }

    private static String wrapUpdateTextIntoStartupFileHtmlStyle(String textFromURL) throws FileNotFoundException {
        StringBuilder sb = new StringBuilder("");
        Scanner sc = null;
        try {
            sc = new Scanner(new File(StartUpHelpText.getStartUpFileName()));
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                if (line.contains("<body>")) break;
                sb.append(line).append("\n");
            }
            sb.append(textFromURL).append("</body></html>");
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
        return sb.toString();
    }

    private static String getNewVersionTextFromURL() throws IOException {
        String versionText = BrowserLauncher.readURL(String.valueOf(Program.getInstance().getWebsite()) + "/current_umlet_version_changes.txt");
        versionText = versionText.replace("<", "&lt;").replace(">", "&gt;").replace("&", "&amp;").replace("\"", "&quot;");
        String[] splitString = versionText.split("\n");
        String actualVersion = splitString[0];
        if (Program.getInstance().getVersion().compareTo(actualVersion) >= 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder("");
        sb.append("<p><b>A new version of ").append(Program.getInstance().getProgramName()).append(" (").append(actualVersion).append(") is available at <a href=\"").append(Program.getInstance().getWebsite()).append("\">").append(Program.getInstance().getWebsite().substring("http://".length())).append("</a></b></p>");
        int i = 1;
        while (i < splitString.length) {
            sb.append("<p>").append(splitString[i]).append("</p>");
            ++i;
        }
        return sb.toString();
    }
}

