/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram.draw.swing;

import com.baselet.control.basics.Converter;
import com.baselet.control.basics.geom.DimensionDouble;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.util.Utils;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.draw.DrawFunction;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.diagram.draw.helper.Style;
import com.baselet.diagram.draw.swing.Text;
import com.baselet.element.interfaces.GridElement;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class DrawHandlerSwing
extends DrawHandler {
    private Graphics2D g2;
    protected DiagramHandler handler;
    private boolean translate;
    private final GridElement gridElement;

    public DrawHandlerSwing(GridElement gridElement) {
        this.gridElement = gridElement;
    }

    private double inBorderHorizontal(double width, double x) {
        return Math.min((double)this.gridElement.getRectangle().getWidth() - x - 1.0, width);
    }

    private double inBorderVertical(double height, double y) {
        return Math.min((double)this.gridElement.getRectangle().getHeight() - y - 1.0, height);
    }

    public void setHandler(DiagramHandler handler) {
        this.handler = handler;
        this.style = new Style();
        this.resetStyle();
    }

    public void setGraphics(Graphics g) {
        this.g2 = (Graphics2D)g;
    }

    private double getZoom() {
        return this.handler.getZoomFactor();
    }

    @Override
    public DimensionDouble textDimensionHelper(String text) {
        boolean specialFontSize;
        boolean bl = specialFontSize = this.style.getFontSize() != this.getDefaultFontSize();
        if (specialFontSize) {
            this.handler.getFontHandler().setFontSize(this.style.getFontSize());
        }
        DimensionDouble returnVal = this.handler.getFontHandler().getTextSize(text, false);
        if (specialFontSize) {
            this.handler.getFontHandler().resetFontSize();
        }
        return returnVal;
    }

    @Override
    public double getDefaultFontSize() {
        return this.handler.getFontHandler().getFontSize(false);
    }

    @Override
    public void drawArc(double x, double y, double width, double height, double start, double extent, boolean open) {
        double xZoomed = x * this.getZoom() + 0.5;
        double yZoomed = y * this.getZoom() + 0.5;
        int arcType = open ? 0 : 2;
        this.addShape(new Arc2D.Double(xZoomed, yZoomed, this.inBorderHorizontal(width * this.getZoom(), xZoomed), this.inBorderVertical(height * this.getZoom(), yZoomed), start, extent, arcType));
    }

    @Override
    public void drawCircle(double x, double y, double radius) {
        double widthAndHeight = radius * 2.0;
        this.drawEllipse(x - radius, y - radius, widthAndHeight, widthAndHeight);
    }

    @Override
    public void drawEllipse(double x, double y, double width, double height) {
        double xZoomed = x * this.getZoom() + 0.5;
        double yZoomed = y * this.getZoom() + 0.5;
        this.addShape(new Ellipse2D.Double(xZoomed, yZoomed, this.inBorderHorizontal(width * this.getZoom(), xZoomed), this.inBorderVertical(height * this.getZoom(), yZoomed)));
    }

    @Override
    public void drawLines(PointDouble ... points) {
        if (points.length > 0) {
            Path2D.Double path = new Path2D.Double();
            boolean first = true;
            PointDouble[] pointDoubleArray = points;
            int n = points.length;
            int n2 = 0;
            while (n2 < n) {
                PointDouble p = pointDoubleArray[n2];
                Double x = this.inBorderHorizontal(p.getX() * this.getZoom() + 0.5, 0.0);
                Double y = this.inBorderVertical(p.getY() * this.getZoom() + 0.5, 0.0);
                if (first) {
                    path.moveTo(x, y);
                    first = false;
                } else {
                    path.lineTo(x, y);
                }
                ++n2;
            }
            boolean fillShape = points[0].equals(points[points.length - 1]);
            this.addShape(path, fillShape);
        }
    }

    @Override
    public void drawRectangle(double x, double y, double width, double height) {
        double xZoomed = x * this.getZoom() + 0.5;
        double yZoomed = y * this.getZoom() + 0.5;
        this.addShape(new Rectangle2D.Double(xZoomed, yZoomed, this.inBorderHorizontal(width * this.getZoom(), xZoomed), this.inBorderVertical(height * this.getZoom(), yZoomed)));
    }

    @Override
    public void drawRectangleRound(double x, double y, double width, double height, double radius) {
        double rad = radius * 2.0 * this.getZoom();
        double xZoomed = x * this.getZoom() + 0.5;
        double yZoomed = y * this.getZoom() + 0.5;
        this.addShape(new RoundRectangle2D.Double(xZoomed, yZoomed, this.inBorderHorizontal(width * this.getZoom(), xZoomed), this.inBorderVertical(height * this.getZoom(), yZoomed), rad, rad));
    }

    @Override
    public void printHelper(String text, PointDouble point, AlignHorizontal align) {
        this.addText(new Text(text, point.x * this.getZoom(), point.y * this.getZoom(), align));
    }

    protected void addShape(Shape s) {
        this.addShape(s, true);
    }

    protected void addShape(final Shape s, final boolean fillShape) {
        final Style styleAtDrawingCall = this.style.cloneFromMe();
        this.addDrawable(new DrawFunction(){

            @Override
            public void run() {
                DrawHandlerSwing.this.drawShape(styleAtDrawingCall, s, fillShape);
            }
        });
    }

    private void drawShape(Style style, Shape s, boolean fillShape) {
        if (fillShape) {
            this.g2.setColor(Converter.convert(style.getBackgroundColor()));
            this.g2.fill(s);
        }
        ColorOwn colOwn = this.getOverlay().getForegroundColor() != null ? this.getOverlay().getForegroundColor() : style.getForegroundColor();
        this.g2.setColor(Converter.convert(colOwn));
        this.g2.setStroke(Utils.getStroke(style.getLineType(), (float)style.getLineWidth()));
        if (this.translate) {
            double xTranslation = s.getBounds().x == 0 ? 0.5 : 0.0;
            double yTranslation = s.getBounds().y == 0 ? 0.5 : 0.0;
            this.g2.translate(xTranslation, yTranslation);
        }
        this.g2.draw(s);
    }

    protected void addText(final Text t) {
        final Style styleAtDrawingCall = this.style.cloneFromMe();
        this.addDrawable(new DrawFunction(){

            @Override
            public void run() {
                DrawHandlerSwing.this.drawText(styleAtDrawingCall, t);
            }
        });
    }

    private void drawText(Style style, Text t) {
        ColorOwn col = this.getOverlay().getForegroundColor() != null ? this.getOverlay().getForegroundColor() : style.getForegroundColor();
        this.g2.setColor(Converter.convert(col));
        this.handler.getFontHandler().setFontSize(style.getFontSize());
        this.g2.setFont(this.handler.getFontHandler().getFont());
        this.handler.getFontHandler().writeText(this.g2, t.getText(), t.getX(), t.getY(), t.getHorizontalAlignment());
        this.handler.getFontHandler().resetFontSize();
    }

    public void setTranslate(boolean translate) {
        this.translate = translate;
    }
}

