/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.old.allinone;

import com.baselet.control.Main;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.Direction;
import com.baselet.control.enums.FormatLabels;
import com.baselet.control.enums.LineType;
import com.baselet.control.util.Utils;
import com.baselet.diagram.FontHandler;
import com.baselet.element.interfaces.GridElementDeprecatedAddons;
import com.baselet.element.old.OldGridElement;
import com.baselet.element.old.allinone.Interaction;
import com.baselet.element.old.allinone.InteractionManagement;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.font.TextLayout;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sourceforge.jlibeps.epsgraphics.EpsGraphics2D;

public class SequenceDiagram
extends OldGridElement {
    public int controlFlowBoxWidth = 20;
    public int rectDistance;
    public int rectHeight;
    public int rectWidth;
    public int borderDistance = 10;
    private int yOffsetforTitle = 0;
    public int rectToFirstLevelDistance = 0;
    public int levelHeight = 30;
    public int arrowX = 5;
    public int arrowY = 5;
    public static final int SYNC = 1;
    public static final int ASYNC = 2;
    public static final int EDGE = 3;
    public static final int FILLED = 4;
    public static final int SOLID = 1;
    public static final int DOTTED = 2;
    private Map<String, Integer> labeltonumber;
    private int levelNum = 0;
    private InteractionManagement im;

    @Override
    public void paintEntity(Graphics g) {
        this.rectDistance = 60;
        this.zoomValues();
        float zoom = Main.getHandlerForElement(this).getZoomFactor();
        Graphics2D g2 = (Graphics2D)g;
        FontHandler fontHandler = Main.getHandlerForElement(this).getFontHandler();
        g2.setFont(fontHandler.getFont());
        g2.setColor(this.fgColor);
        g2.drawRect(0, 0, this.getRectangle().width - 1, this.getRectangle().height - 1);
        this.levelNum = 1;
        Vector<String> lines = Utils.decomposeStrings(this.getPanelAttributes());
        if (lines.size() == 0) {
            return;
        }
        if (lines.elementAt(0).startsWith("title:")) {
            String title = lines.elementAt(0).substring("title:".length());
            if (title != null && title.length() > 0) {
                fontHandler.writeText(g2, title, (int)(5.0f * zoom), (int)fontHandler.getFontSize() + (int)fontHandler.getDistanceBetweenTexts(), AlignHorizontal.LEFT);
                int titlewidth = (int)fontHandler.getTextWidth(title);
                int ty = (int)(8.0f * zoom) + (int)(fontHandler.getFontSize() + fontHandler.getDistanceBetweenTexts());
                g2.drawLine(0, ty, titlewidth + (int)(10.0f * zoom), ty);
                g2.drawLine(titlewidth + (int)(10.0f * zoom), ty, titlewidth + ty + (int)(10.0f * zoom), 0);
                lines.remove(0);
                this.yOffsetforTitle = (int)(25.0f * zoom);
            }
        } else {
            this.yOffsetforTitle = 0;
        }
        int i = 1;
        while (i < lines.size()) {
            String element = lines.elementAt(i);
            if (element.indexOf("iframe{") >= 0) {
                element = "9999->0:" + element;
                lines.set(i, element);
            } else if (element.indexOf("iframe}") >= 0) {
                element = "9999<-0:" + element;
                lines.set(i, element);
            }
            if (!lines.elementAt(i).matches("\\A\\s*\\z")) {
                ++this.levelNum;
            }
            ++i;
        }
        if (lines.size() == 0) {
            return;
        }
        String firstLine = lines.elementAt(0);
        Vector<String> obj = Utils.decomposeStrings(firstLine, "|");
        int numObjects = obj.size();
        StringBuilder sb = new StringBuilder("");
        this.labeltonumber = new HashMap<String, Integer>();
        Pattern p_label = Pattern.compile("([^\\~]+)(\\~([a-zA-Z0-9]+))?(\\_)?");
        int i2 = 1;
        while (i2 <= numObjects) {
            Matcher m = p_label.matcher(obj.get(i2 - 1));
            if (m.matches() && m.group(2) != null) {
                this.labeltonumber.put(m.group(3), i2);
                sb.append("|").append(m.group(1)).append(m.group(4) == null ? "" : m.group(4));
            } else {
                sb.append("|").append(obj.get(i2 - 1));
            }
            if (!this.labeltonumber.containsKey(Integer.toString(i2))) {
                this.labeltonumber.put(Integer.toString(i2), i2);
            }
            ++i2;
        }
        String newhead = sb.toString();
        obj = Utils.decomposeStrings(newhead.length() > 0 ? newhead.substring(1) : "", "|");
        this.calcWidthOfLineHeaderBoxes(g2, fontHandler, obj, numObjects);
        int curLevel = 0;
        this.im = new InteractionManagement(this.levelNum);
        String boxStrings = "";
        int i3 = 1;
        while (i3 < lines.size()) {
            String methodName = "";
            if (!lines.elementAt(i3).matches("\\A\\s*\\z")) {
                ++curLevel;
                Vector<String> interactions = Utils.decomposeStrings(lines.elementAt(i3), ";");
                int j = 0;
                while (j < interactions.size()) {
                    Pattern p = Pattern.compile("\\A(\\w+)(->>|->|-/>|.>>|.>|./>|->>>|.>>>|<<-|<-|</-|<<.|<.|</.|<<<-|<<<.)(\\w+)(:((\\w+)(,(\\w+))*))?(?::(.*))?\\z");
                    Matcher m = p.matcher(interactions.elementAt(j));
                    if (m.matches()) {
                        boolean destObjHasControl;
                        Integer span;
                        Integer srcObj = this.labeltonumber.get(m.group(1));
                        Integer destObj = this.labeltonumber.get(m.group(3));
                        String methodNameFromText = m.group(9);
                        if (srcObj != null && destObj != null && methodNameFromText != null && (span = Integer.valueOf(Math.abs(srcObj - destObj))) != 0) {
                            double lineSpaceRequiredForMessage = fontHandler.getTextWidth(methodNameFromText) / (double)span.intValue();
                            double totalDist = lineSpaceRequiredForMessage - (double)this.rectWidth + (double)this.controlFlowBoxWidth;
                            this.rectDistance = (int)Math.max((double)this.rectDistance, totalDist);
                        }
                        int arrowKind = -1;
                        int lineKind = -1;
                        boolean reverse = false;
                        if (m.group(2).equals("->")) {
                            arrowKind = 2;
                            lineKind = 1;
                        } else if (m.group(2).equals("->>")) {
                            arrowKind = 1;
                            lineKind = 1;
                        } else if (m.group(2).equals("-/>")) {
                            arrowKind = 3;
                            lineKind = 1;
                        } else if (m.group(2).equals("->>>")) {
                            arrowKind = 4;
                            lineKind = 1;
                        } else if (m.group(2).equals(".>")) {
                            arrowKind = 2;
                            lineKind = 2;
                        } else if (m.group(2).equals(".>>")) {
                            arrowKind = 1;
                            lineKind = 2;
                        } else if (m.group(2).equals("./>")) {
                            arrowKind = 3;
                            lineKind = 2;
                        } else if (m.group(2).equals(".>>>")) {
                            arrowKind = 4;
                            lineKind = 2;
                        } else if (m.group(2).equals("<-")) {
                            arrowKind = 2;
                            lineKind = 1;
                            reverse = true;
                        } else if (m.group(2).equals("<<-")) {
                            arrowKind = 1;
                            lineKind = 1;
                            reverse = true;
                        } else if (m.group(2).equals("</-")) {
                            arrowKind = 3;
                            lineKind = 1;
                            reverse = true;
                        } else if (m.group(2).equals("<<<-")) {
                            arrowKind = 4;
                            lineKind = 1;
                            reverse = true;
                        } else if (m.group(2).equals("<.")) {
                            arrowKind = 2;
                            lineKind = 2;
                            reverse = true;
                        } else if (m.group(2).equals("<<.")) {
                            arrowKind = 1;
                            lineKind = 2;
                            reverse = true;
                        } else if (m.group(2).equals("</.")) {
                            arrowKind = 3;
                            lineKind = 2;
                            reverse = true;
                        } else if (m.group(2).equals("<<<.")) {
                            arrowKind = 4;
                            lineKind = 2;
                            reverse = true;
                        }
                        String group = m.group(5);
                        if (group == null) {
                            group = "#";
                            String element = interactions.elementAt(j);
                            if (element.indexOf("iframe") >= 0) {
                                group = String.valueOf(group) + element.substring(element.indexOf("iframe"));
                            }
                        } else {
                            String[] grouparray = group.split(",");
                            group = "";
                            String[] stringArray = grouparray;
                            int n = grouparray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String tmp = stringArray[n2];
                                Integer tempgroup = this.labeltonumber.get(tmp);
                                if (tempgroup != null) {
                                    group = String.valueOf(group) + "," + tempgroup;
                                }
                                ++n2;
                            }
                            if (group.length() > 0) {
                                group = group.substring(1);
                            } else if (grouparray.length == 1) {
                                group = "#";
                                methodName = grouparray[0];
                            }
                        }
                        boxStrings = String.valueOf(boxStrings) + ";" + group;
                        boolean srcObjHasControl = srcObj != null ? group.contains(String.valueOf(srcObj)) : false;
                        boolean bl = destObjHasControl = destObj != null ? group.contains(String.valueOf(destObj)) : false;
                        if (methodName == null || methodName.isEmpty()) {
                            methodName = methodNameFromText;
                        }
                        if (srcObj != null && destObj != null) {
                            if (!reverse) {
                                this.im.add(curLevel, new Interaction(srcObj, srcObjHasControl, arrowKind, lineKind, destObj, destObjHasControl, methodName));
                            } else {
                                this.im.add(curLevel, new Interaction(destObj, destObjHasControl, arrowKind, lineKind, srcObj, srcObjHasControl, methodName));
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i3;
        }
        int ypos = this.borderDistance + this.yOffsetforTitle;
        int xpos = this.borderDistance;
        int i4 = 0;
        while (i4 < numObjects) {
            boolean underline = false;
            String s = obj.elementAt(i4);
            if (s.startsWith(FormatLabels.UNDERLINE.getValue()) && s.endsWith(FormatLabels.UNDERLINE.getValue()) && s.length() > 2) {
                underline = true;
                s = s.substring(1, s.length() - 1);
            }
            TextLayout layout = new TextLayout(s, fontHandler.getFont(), g2.getFontRenderContext());
            g2.drawRect(xpos, ypos, this.rectWidth - 1, this.rectHeight - 1);
            int dx = (this.rectWidth - 2 - (int)Math.floor(layout.getBounds().getWidth() + 1.0)) / 2;
            int dy = (this.rectHeight - 2 - (int)Math.floor(layout.getBounds().getHeight() + 1.0)) / 2;
            int tx = xpos + dx;
            int ty = ypos + dy + (int)layout.getBounds().getHeight();
            layout.draw(g2, tx, ty);
            if (underline) {
                g2.drawLine(tx, ty + (int)fontHandler.getDistanceBetweenTexts() / 2, tx + (int)layout.getBounds().getWidth(), ty + (int)fontHandler.getDistanceBetweenTexts() / 2);
            }
            xpos += this.rectWidth + this.rectDistance;
            ++i4;
        }
        int maxTextXpos = this.drawMessages(g2);
        maxTextXpos = (int)((double)maxTextXpos + 3.0 * fontHandler.getDistanceBetweenTexts());
        if (boxStrings.length() > 1) {
            try {
                this.drawControlFlowBoxesWithLines(g2, boxStrings.substring(1), numObjects);
            }
            catch (ArrayIndexOutOfBoundsException underline) {
                // empty catch block
            }
        }
        int rWidth = this.rectWidth * numObjects + this.rectDistance * (numObjects - 1) + 2 * this.borderDistance;
        int rHeight = 2 * this.borderDistance + this.yOffsetforTitle + this.rectHeight + this.rectToFirstLevelDistance + this.levelNum * this.levelHeight;
        rWidth = rWidth > maxTextXpos ? rWidth : maxTextXpos;
        rWidth += Main.getHandlerForElement(this).getGridSize() - rWidth % Main.getHandlerForElement(this).getGridSize();
        rHeight += Main.getHandlerForElement(this).getGridSize() - rHeight % Main.getHandlerForElement(this).getGridSize();
        this.setSize(rWidth, rHeight);
    }

    private void calcWidthOfLineHeaderBoxes(Graphics2D g2, FontHandler fontHandler, Vector<String> obj, int numObjects) {
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        int i = 0;
        while (i < numObjects) {
            String s = obj.elementAt(i);
            if (s.startsWith(FormatLabels.UNDERLINE.getValue()) && s.endsWith(FormatLabels.UNDERLINE.getValue()) && s.length() > 2) {
                s = s.substring(1, s.length() - 1);
            }
            TextLayout layout = new TextLayout(s, fontHandler.getFont(), g2.getFontRenderContext());
            maxWidth = Math.max(layout.getBounds().getWidth(), maxWidth);
            maxHeight = Math.max(layout.getBounds().getHeight(), maxHeight);
            ++i;
        }
        this.rectWidth = (int)Math.floor(maxWidth + 1.0) + 2 * (int)fontHandler.getDistanceBetweenTexts() + (int)fontHandler.getFontSize();
        this.rectHeight = (int)Math.floor(maxHeight + 1.0) + (int)fontHandler.getDistanceBetweenTexts() + (int)fontHandler.getFontSize();
    }

    private int drawMessages(Graphics2D g2) {
        float zoom = Main.getHandlerForElement(this).getZoomFactor();
        int maxTextXpos = 0;
        int i = 0;
        while (i < this.im.getNumLevels()) {
            Set<Interaction> interactions = this.im.getInteractionsInLevel(i + 1);
            for (Interaction ia : interactions) {
                int tx;
                if (ia.getSrcObj() == ia.getDestObj()) {
                    int xTextOffset = 0;
                    int w = (int)(30.0f * zoom);
                    int h = (int)((double)this.levelHeight * 0.66);
                    int x = this.hCenterForObj(ia.getSrcObj()) - w / 2;
                    int ay = this.vCenterForLevel(i + 1) + (int)(5.0f * zoom);
                    if (this.im.controlBoxExists(i + 1, ia.getSrcObj())) {
                        x += this.controlFlowBoxWidth / 2;
                        xTextOffset = this.controlFlowBoxWidth / 2;
                    }
                    g2.drawArc(x, ay, w, h, 90, -180);
                    Point p1 = new Point(x + w / 2, ay + h);
                    Point d1 = new Point(x + w / 2 + (int)(3.0f * zoom), p1.y - (int)(6.0f * zoom));
                    Point d2 = new Point(x + w / 2 + (int)(4.0f * zoom), p1.y + (int)(4.0f * zoom));
                    if (ia.getArrowKind() == 2) {
                        g2.drawLine(p1.x, p1.y, d1.x, d1.y);
                        g2.drawLine(p1.x, p1.y, d2.x, d2.y);
                    } else if (ia.getArrowKind() == 1) {
                        int[] xs = new int[]{p1.x, d1.x, d2.x};
                        int[] ys = new int[]{p1.y, d1.y, d2.y};
                        Color oldColor = g2.getColor();
                        g2.setColor(this.bgColor);
                        g2.fillPolygon(xs, ys, 3);
                        g2.setColor(oldColor);
                        g2.drawPolygon(xs, ys, 3);
                    } else if (ia.getArrowKind() == 3) {
                        g2.drawLine(p1.x, p1.y, d2.x, d2.y);
                    } else if (ia.getArrowKind() == 4) {
                        Polygon p = new Polygon();
                        p.addPoint(p1.x, p1.y);
                        p.addPoint(d1.x, d1.y);
                        p.addPoint(d2.x, d2.y);
                        g2.fillPolygon(p);
                    }
                    if (ia.getMethodName() == null || ia.getMethodName().equals("")) continue;
                    int fx1 = x + w + 2;
                    int fy1 = ay;
                    int fx2 = this.hCenterForObj(ia.getSrcObj()) + this.rectWidth / 2;
                    int fy2 = ay + h;
                    int tx2 = this.printMethodName(g2, ia.getMethodName(), fx1 + xTextOffset, fx2 + xTextOffset, fy1, fy2, true, false);
                    maxTextXpos = maxTextXpos > tx2 ? maxTextXpos : tx2;
                    continue;
                }
                int begX = this.hCenterForObj(ia.getSrcObj());
                int endX = ia.getSrcObj() < ia.getDestObj() ? this.hCenterForObj(ia.getDestObj()) - 1 : this.hCenterForObj(ia.getDestObj()) + 1;
                int arrowY = this.vCenterForLevel(i + 1) + this.levelHeight / 2 - 1;
                if (ia.getSrcObjHasControl()) {
                    begX += ia.getSrcObj() < ia.getDestObj() ? this.controlFlowBoxWidth / 2 : -this.controlFlowBoxWidth / 2;
                }
                if (ia.getDestObjHasControl()) {
                    endX += ia.getSrcObj() < ia.getDestObj() ? -this.controlFlowBoxWidth / 2 : this.controlFlowBoxWidth / 2;
                }
                this.drawArrow(g2, new Point(begX, arrowY), new Point(endX, arrowY), ia.getArrowKind(), ia.getLineKind());
                if (ia.getMethodName() == null || ia.getMethodName().equals("")) continue;
                int b = 2;
                if (ia.getSrcObj() < ia.getDestObj()) {
                    tx = this.printMethodName(g2, ia.getMethodName(), begX + 2, endX - this.arrowX - 2, arrowY - 1 - this.levelHeight / 1, arrowY - 1, false, true);
                    maxTextXpos = maxTextXpos > tx ? maxTextXpos : tx;
                    continue;
                }
                tx = this.printMethodName(g2, ia.getMethodName(), endX + this.arrowX + 2, begX - 2, arrowY - 1 - this.levelHeight / 2, arrowY - 1, false, true);
                int n = maxTextXpos = maxTextXpos > tx ? maxTextXpos : tx;
            }
            ++i;
        }
        return maxTextXpos;
    }

    private int printMethodName(Graphics2D g2, String methodName, int begX, int endX, int begY, int endY, boolean centerVertically, boolean centerHorizontically) {
        if (methodName == null || methodName.equals("")) {
            log.error((Object)"SequenceDiagram->printMethodName was called with an invalid argument.");
            return 0;
        }
        Font font = Main.getHandlerForElement(this).getFontHandler().getFont();
        TextLayout layout = new TextLayout(methodName, font, g2.getFontRenderContext());
        int dx = centerHorizontically ? (endX - begX - (int)layout.getBounds().getWidth()) / 2 : 0;
        int dy = centerVertically ? (endY - begY - (int)layout.getBounds().getHeight()) / 2 : 1;
        layout.draw(g2, begX + dx, endY - dy);
        return begX + dx + (int)layout.getBounds().getWidth();
    }

    public void drawControlFlowBoxesWithLines(Graphics2D g2, String s, int numObjects) {
        int level = 1;
        StringTokenizer mainTokens = new StringTokenizer(s, ";");
        int tokNum = mainTokens.countTokens();
        int[][] tField = new int[numObjects][tokNum + 2];
        Vector<Integer> interactionframes = new Vector<Integer>();
        HashMap<String, String> interactionframesText = new HashMap<String, String>();
        while (mainTokens.hasMoreTokens()) {
            String main = mainTokens.nextToken();
            if (main.indexOf("#") >= 0) {
                int i = 0;
                while (i < numObjects) {
                    tField[i][level - 1] = 0;
                    ++i;
                }
                if (main.indexOf("#iframe{") >= 0 || main.indexOf("#iframe}") >= 0) {
                    if (main.indexOf("#iframe{") >= 0) {
                        interactionframes.add(level);
                    } else {
                        interactionframes.add(level * -1);
                    }
                    if (main.indexOf("iframe{:") >= 0) {
                        interactionframesText.put("" + level, main.substring(main.indexOf("iframe{:") + 8));
                    }
                }
                ++level;
                continue;
            }
            StringTokenizer innerT = new StringTokenizer(main, ",");
            int i = 0;
            while (i < numObjects) {
                tField[i][level - 1] = 0;
                ++i;
            }
            while (innerT.hasMoreTokens()) {
                String is = innerT.nextToken();
                int objNum = Integer.parseInt(is);
                tField[objNum - 1][level - 1] = 1;
            }
            ++level;
        }
        int actObjNum = 0;
        while (actObjNum < numObjects) {
            int offset = 2;
            int objNum = actObjNum + 1;
            int x1 = this.hCenterForObj(objNum) - this.controlFlowBoxWidth / 2;
            int startLevel = -1;
            int boxSize = 0;
            int lineX = this.hCenterForObj(actObjNum + 1);
            int lineY1 = this.borderDistance + this.yOffsetforTitle + this.rectHeight;
            int i = 0;
            while (i < tokNum + 1) {
                if (tField[actObjNum][i] == 1) {
                    if (startLevel == -1) {
                        startLevel = i;
                    }
                    ++boxSize;
                }
                if (tField[actObjNum][i] == 0 && startLevel != -1) {
                    int y1 = this.vCenterForLevel(startLevel + offset) - this.levelHeight - 1;
                    g2.drawRect(x1, y1, this.controlFlowBoxWidth - 1, this.levelHeight * boxSize);
                    g2.setStroke(Utils.getStroke(LineType.DASHED, 1.0f));
                    g2.drawLine(lineX, lineY1, lineX, y1);
                    g2.setStroke(Utils.getStroke(LineType.SOLID, 1.0f));
                    lineY1 = y1 + this.levelHeight * boxSize;
                    startLevel = -1;
                    boxSize = 0;
                }
                ++i;
            }
            int lineY2 = this.borderDistance + this.yOffsetforTitle + this.rectHeight + this.levelNum * this.levelHeight + this.rectToFirstLevelDistance;
            g2.setStroke(Utils.getStroke(LineType.DASHED, 1.0f));
            g2.drawLine(lineX, lineY1, lineX, lineY2);
            g2.setStroke(Utils.getStroke(LineType.SOLID, 1.0f));
            ++actObjNum;
        }
        int fullSets = interactionframes.size() - interactionframes.size() % 2;
        if (fullSets >= 2) {
            int pos = 0;
            while (pos < fullSets) {
                pos = this.recurseInteractionFrames(g2, interactionframes, interactionframesText, pos, 0);
                ++pos;
            }
        }
    }

    public int recurseInteractionFrames(Graphics2D g2, Vector<Integer> interactionframes, HashMap<String, String> interactionframesText, int pos, int recursionLevel) {
        int posX;
        int pos1 = interactionframes.elementAt(pos);
        while (pos < interactionframes.size() && (posX = interactionframes.elementAt(pos).intValue()) > 0) {
            pos1 = posX;
            ++pos;
            pos = this.recurseInteractionFrames(g2, interactionframes, interactionframesText, pos, recursionLevel + 1);
            if (pos1 <= 0) {
                return pos;
            }
            int pos2 = interactionframes.elementAt(pos) * -1;
            this.drawInteractionFrame(g2, pos1, pos2, recursionLevel, interactionframesText.get("" + pos1));
            ++pos;
        }
        return pos;
    }

    private void drawInteractionFrame(Graphics2D g2, int pos1, int pos2, int recursionLevel, String text) {
        float zoom = Main.getHandlerForElement(this).getZoomFactor();
        int pos11 = (pos1 + 1) * this.levelHeight + this.yOffsetforTitle;
        int h = (pos2 - pos1) * this.levelHeight;
        int x = (int)Main.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts() * 2 + recursionLevel * 4;
        g2.drawRect(x, pos11, this.getRectangle().width - (int)Main.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts() * 4 - 1 - recursionLevel * 8, h);
        int uLinePos = pos11 + (int)Main.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts() + (int)(Main.getHandlerForElement(this).getFontHandler().getFontSize() + (double)((int)Main.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts()));
        int textPos = pos11 + (int)Main.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts() + (int)Main.getHandlerForElement(this).getFontHandler().getFontSize();
        int textWidth = 0;
        if (text == null || text.equals("")) {
            text = " ";
        }
        g2.drawString(text, x + (int)(10.0f * zoom), textPos);
        int pW = (int)Main.getHandlerForElement(this).getFontHandler().getTextWidth(text);
        textWidth = pW > textWidth ? pW : textWidth;
        g2.drawLine(x, uLinePos, x + textWidth + (int)(15.0f * zoom), uLinePos);
        g2.drawLine(x + textWidth + (int)(15.0f * zoom), uLinePos, x + textWidth + (int)(25.0f * zoom), pos11 + (int)(10.0f * zoom));
        g2.drawLine(x + textWidth + (int)(25.0f * zoom), pos11, x + textWidth + (int)(25.0f * zoom), pos11 + (int)(10.0f * zoom));
    }

    public void drawArrow(Graphics2D g2, Point srcObj, Point destObj, int arrowKind, int lineKind) {
        Point p2;
        Point p1;
        if (srcObj.x < destObj.x) {
            p1 = new Point(destObj.x - this.arrowX, destObj.y + this.arrowY);
            p2 = new Point(destObj.x - this.arrowX, destObj.y - this.arrowY);
        } else {
            p1 = new Point(destObj.x + this.arrowX, destObj.y + this.arrowY);
            p2 = new Point(destObj.x + this.arrowX, destObj.y - this.arrowY);
        }
        if (arrowKind == 1) {
            g2.drawLine(p1.x, p1.y, p2.x, p2.y);
            g2.drawLine(destObj.x, destObj.y, p1.x, p1.y);
            g2.drawLine(destObj.x, destObj.y, p2.x, p2.y);
            if (lineKind == 2) {
                g2.setStroke(Utils.getStroke(LineType.DASHED, 1.0f));
            }
            g2.drawLine(srcObj.x, srcObj.y, p1.x, destObj.y);
        } else if (arrowKind == 2) {
            g2.drawLine(destObj.x, destObj.y, p1.x, p1.y);
            g2.drawLine(destObj.x, destObj.y, p2.x, p2.y);
            if (lineKind == 2) {
                g2.setStroke(Utils.getStroke(LineType.DASHED, 1.0f));
            }
            g2.drawLine(srcObj.x, srcObj.y, destObj.x, destObj.y);
        } else if (arrowKind == 3) {
            g2.drawLine(destObj.x, destObj.y, p2.x, p2.y);
            if (lineKind == 2) {
                g2.setStroke(Utils.getStroke(LineType.DASHED, 1.0f));
            }
            g2.drawLine(srcObj.x, srcObj.y, destObj.x, destObj.y);
        } else if (arrowKind == 4) {
            Polygon p = new Polygon();
            p.addPoint(p1.x, p1.y);
            p.addPoint(p2.x, p2.y);
            p.addPoint(destObj.x, destObj.y);
            g2.fillPolygon(p);
            if (lineKind == 2) {
                g2.setStroke(Utils.getStroke(LineType.DASHED, 1.0f));
            }
            g2.drawLine(srcObj.x, srcObj.y, p1.x, destObj.y);
        }
        g2.setStroke(Utils.getStroke(LineType.SOLID, 1.0f));
    }

    protected int hCenterForObj(int objNum) {
        return objNum * this.rectWidth + (objNum - 1) * this.rectDistance + this.borderDistance - this.rectWidth / 2;
    }

    protected int vCenterForLevel(int level) {
        return level * this.levelHeight + this.rectToFirstLevelDistance + this.rectHeight + this.borderDistance + this.yOffsetforTitle - this.levelHeight / 2;
    }

    @Override
    public Set<Direction> getResizeArea(int x, int y) {
        return new HashSet<Direction>();
    }

    public void zoomValues() {
        float zoom = Main.getHandlerForElement(this).getZoomFactor();
        this.controlFlowBoxWidth = (int)(20.0f * zoom);
        this.rectDistance = (int)((float)this.rectDistance * zoom);
        this.borderDistance = (int)(10.0f * zoom);
        this.levelHeight = (int)(30.0f * zoom);
        this.arrowX = (int)(5.0f * zoom);
        this.arrowY = (int)(5.0f * zoom);
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public GridElementDeprecatedAddons getDeprecatedAddons() {
        return new GridElementDeprecatedAddons(){

            @Override
            public void doBeforeExport() {
                SequenceDiagram.this.paintEntity((Graphics)new EpsGraphics2D());
            }
        };
    }
}

