/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.relation;

import com.baselet.control.basics.geom.Point;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.config.SharedConfig;
import com.baselet.control.enums.Direction;
import com.baselet.control.enums.ElementId;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.NewGridElement;
import com.baselet.element.UndoInformation;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.element.facet.Settings;
import com.baselet.element.facet.common.LayerFacet;
import com.baselet.element.relation.facet.RelationLineTypeFacet;
import com.baselet.element.relation.facet.SettingsRelation;
import com.baselet.element.relation.helper.RelationPointHandler;
import com.baselet.element.relation.helper.RelationPointHolder;
import com.baselet.element.relation.helper.RelationPointList;
import com.baselet.element.relation.helper.RelationSelection;
import com.baselet.element.sticking.PointChange;
import com.baselet.element.sticking.PointDoubleIndexed;
import com.baselet.element.sticking.Stickable;
import com.baselet.element.sticking.StickableMap;
import com.baselet.element.sticking.polygon.NoStickingPolygonGenerator;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Relation
extends NewGridElement
implements Stickable,
RelationPointHolder {
    private RelationPointHandler relationPoints;

    @Override
    public ElementId getId() {
        return ElementId.Relation;
    }

    @Override
    protected void drawCommonContent(PropertiesParserState propertiesParserState) {
        propertiesParserState.setStickingPolygonGenerator(NoStickingPolygonGenerator.INSTANCE);
    }

    @Override
    protected void resetAndDrawMetaDrawerContent(DrawHandler drawHandler) {
        drawHandler.clearCache();
        drawHandler.setBackgroundColor(ColorOwn.SELECTION_BG);
        if (SharedConfig.getInstance().isDev_mode()) {
            drawHandler.setForegroundColor(ColorOwn.TRANSPARENT);
            drawHandler.drawRectangle(0.0, 0.0, this.getRealSize().getWidth(), this.getRealSize().getHeight());
            drawHandler.setBackgroundColor(ColorOwn.GREEN.transparency(ColorOwn.Transparency.BACKGROUND));
            this.relationPoints.drawSelectionSpace(drawHandler);
        }
        drawHandler.setForegroundColor(ColorOwn.SELECTION_FG);
        this.relationPoints.drawCirclesAndDragBox(drawHandler);
    }

    @Override
    public void setAdditionalAttributes(String string) {
        super.setAdditionalAttributes(string);
        RelationPointList relationPointList = new RelationPointList();
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; i += 2) {
            relationPointList.add(Double.valueOf(stringArray[i]), Double.valueOf(stringArray[i + 1]));
        }
        this.relationPoints = new RelationPointHandler(this, relationPointList);
        if (this.getHandler().isInitialized()) {
            this.relationPoints.resizeRectAndReposPoints();
        }
    }

    @Override
    public String getAdditionalAttributes() {
        return this.relationPoints.toAdditionalAttributesString();
    }

    @Override
    public void drag(Collection<Direction> collection, int n, int n2, Point point, boolean bl, boolean bl2, StickableMap stickableMap, boolean bl3) {
        String string = this.getAdditionalAttributes();
        Rectangle rectangle = this.getRectangle();
        RelationSelection relationSelection = this.relationPoints.getSelectionAndMovePointsIfNecessary(this.pointAtDefaultZoom(point), this.toDefaultZoom(n), this.toDefaultZoom(n2), bl2);
        if (relationSelection == RelationSelection.DRAG_BOX) {
            this.setLocationDifference(n, n2);
        }
        if (relationSelection != RelationSelection.NOTHING) {
            this.updateModelFromText();
        }
        if (bl3) {
            this.undoStack.add(new UndoInformation(this.getRectangle(), rectangle, new HashMap<Stickable, List<PointChange>>(), this.getGridSize(), string, this.getAdditionalAttributes()));
        }
    }

    private Point pointAtDefaultZoom(Point point) {
        return new Point(this.toDefaultZoom(point.getX()), this.toDefaultZoom(point.getY()));
    }

    private int toDefaultZoom(int n) {
        return n * 10 / this.getGridSize();
    }

    @Override
    public void dragEnd() {
        boolean bl = this.relationPoints.removeRelationPointIfOnLineBetweenNeighbourPoints();
        if (bl) {
            this.updateModelFromText();
        }
    }

    @Override
    public Set<Direction> getResizeArea(int n, int n2) {
        return new HashSet<Direction>();
    }

    @Override
    public boolean isSelectableOn(Point point) {
        Point point2 = new Point(point.getX() - this.getRectangle().getX(), point.getY() - this.getRectangle().getY());
        boolean bl = this.relationPoints.getSelection(this.pointAtDefaultZoom(point2)) != RelationSelection.NOTHING;
        return bl;
    }

    @Override
    public Collection<PointDoubleIndexed> getStickablePoints() {
        return this.relationPoints.getStickablePoints();
    }

    @Override
    public List<PointDoubleIndexed> movePoints(List<PointChange> list) {
        List<PointDoubleIndexed> list2 = this.relationPoints.movePointAndResizeRectangle(list);
        this.updateModelFromText();
        return list2;
    }

    @Override
    public Integer getLayer() {
        return this.state.getFacetResponse(LayerFacet.class, LayerFacet.DEFAULT_VALUE_RELATION);
    }

    @Override
    protected Settings createSettings() {
        return new SettingsRelation(){

            @Override
            public RelationPointHandler getRelationPoints() {
                return Relation.this.relationPoints;
            }
        };
    }

    @Override
    protected void drawError(DrawHandler drawHandler, String string) {
        super.drawError(drawHandler, string.replace(">>", "\\>>").replace("<<", "\\<<"));
        RelationLineTypeFacet.drawDefaultLineAndArrows(drawHandler, this.relationPoints);
    }
}

