/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui;

import com.baselet.control.constants.SystemInfo;
import com.baselet.control.enums.Os;
import java.awt.Desktop;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class BrowserLauncher {
    private static final Logger log = Logger.getLogger(BrowserLauncher.class);

    public static void openURL(String url) {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                desktop.browse(new URI(url));
            } else if (SystemInfo.OS == Os.MAC) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (SystemInfo.OS == Os.WINDOWS) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                int count = 0;
                while (count < browsers.length && browser == null) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() == 0) {
                        browser = browsers[count];
                    }
                    ++count;
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            log.error((Object)"Error at opening the URL.", (Throwable)e);
        }
    }

    public static String readURL(String url) throws IOException {
        StringBuilder sb = new StringBuilder("");
        Scanner sc = null;
        try {
            sc = new Scanner(new URL(url).openStream());
            while (sc.hasNextLine()) {
                sb.append(sc.nextLine()).append("\n");
            }
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
        return sb.toString();
    }
}

