/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.command;

import com.baselet.control.Main;
import com.baselet.diagram.DiagramHandler;
import com.baselet.element.interfaces.GridElement;
import com.baselet.gui.command.Command;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ChangeElementSetting
extends Command {
    private String key;
    private Map<GridElement, String> elementValueMap;
    private Map<GridElement, String> oldValue;

    public ChangeElementSetting(String key, String value, Collection<GridElement> element) {
        this(key, ChangeElementSetting.createSingleValueMap(value, element));
    }

    public ChangeElementSetting(String key, Map<GridElement, String> elementValueMap) {
        this.key = key;
        this.elementValueMap = elementValueMap;
    }

    @Override
    public void execute(DiagramHandler handler) {
        super.execute(handler);
        this.oldValue = new HashMap<GridElement, String>();
        for (Map.Entry<GridElement, String> entry : this.elementValueMap.entrySet()) {
            GridElement e = entry.getKey();
            this.oldValue.put(e, e.getSetting(this.key));
            e.setProperty(this.key, entry.getValue());
            if (!handler.getDrawPanel().getSelector().isSelected(e)) continue;
            Main.getHandlerForElement(e).getDrawPanel().getSelector().updateSelectorInformation();
        }
        handler.getDrawPanel().repaint();
    }

    @Override
    public void undo(DiagramHandler handler) {
        super.undo(handler);
        for (Map.Entry<GridElement, String> entry : this.oldValue.entrySet()) {
            entry.getKey().setProperty(this.key, entry.getValue());
        }
        handler.getDrawPanel().repaint();
    }

    private static Map<GridElement, String> createSingleValueMap(String value, Collection<GridElement> elements) {
        HashMap<GridElement, String> singleValueMap = new HashMap<GridElement, String>(1);
        for (GridElement e : elements) {
            singleValueMap.put(e, value);
        }
        return singleValueMap;
    }
}

