/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.command;

import com.baselet.diagram.DiagramHandler;
import com.baselet.element.ElementFactorySwing;
import com.baselet.element.Selector;
import com.baselet.element.interfaces.GridElement;
import com.baselet.gui.command.AddElement;
import com.baselet.gui.command.ClipBoard;
import com.baselet.gui.command.Command;
import com.baselet.gui.command.RemoveElement;
import java.awt.Point;
import java.util.Vector;

public class Paste
extends Command {
    private Point origin;
    private Vector<GridElement> entities;
    private int viewpX = 0;
    private int viewpY = 0;

    @Override
    public void execute(DiagramHandler handler) {
        super.execute(handler);
        if (this.entities == null) {
            this.entities = new Vector();
            for (GridElement e : ClipBoard.getInstance().paste()) {
                GridElement clone = ElementFactorySwing.createCopy(e, handler);
                this.entities.add(clone);
            }
            Selector.replaceGroupsWithNewGroups(this.entities, handler.getDrawPanel().getSelector());
        }
        if (this.origin == null) {
            this.origin = handler.getDrawPanel().getOriginAtDefaultZoom();
            Point viewp = handler.getDrawPanel().getScrollPane().getViewport().getViewPosition();
            this.viewpX = handler.realignToGrid(false, (int)viewp.getX()) / handler.getGridSize();
            this.viewpY = handler.realignToGrid(false, (int)viewp.getY()) / handler.getGridSize();
        }
        if (this.entities.isEmpty()) {
            return;
        }
        DiagramHandler.zoomEntities(10, handler.getGridSize(), this.entities);
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        for (GridElement e : this.entities) {
            minX = Math.min(e.getRectangle().x, minX);
            minY = Math.min(e.getRectangle().y, minY);
        }
        for (GridElement e : this.entities) {
            e.setLocationDifference(this.viewpX * handler.getGridSize() - minX + handler.getGridSize() * 2, this.viewpY * handler.getGridSize() - minY + handler.getGridSize() * 2);
        }
        int offsetX = this.origin.x - handler.getDrawPanel().getOriginAtDefaultZoom().x;
        int offsetY = this.origin.y - handler.getDrawPanel().getOriginAtDefaultZoom().y;
        offsetX = offsetX * handler.getGridSize() / 10;
        offsetY = offsetY * handler.getGridSize() / 10;
        for (GridElement e : this.entities) {
            new AddElement(e, handler.realignToGrid(e.getRectangle().x + offsetX), handler.realignToGrid(e.getRectangle().y + offsetY), false).execute(handler);
        }
        handler.getDrawPanel().getSelector().deselectAll();
        for (GridElement e : this.entities) {
            handler.getDrawPanel().getSelector().select(e);
        }
        handler.getDrawPanel().updatePanelAndScrollbars();
    }

    @Override
    public void undo(DiagramHandler handler) {
        super.undo(handler);
        DiagramHandler.zoomEntities(handler.getGridSize(), 10, this.entities);
        new RemoveElement(this.entities, false).execute(handler);
        handler.getDrawPanel().updatePanelAndScrollbars();
    }
}

