/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.plugin.gui;

import com.baselet.control.enums.Program;
import com.baselet.element.interfaces.GridElement;
import com.baselet.gui.CurrentGui;
import com.baselet.plugin.gui.EclipseGUI;
import com.baselet.plugin.gui.MenuFactoryEclipse;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorActionBarContributor;

public class Contributor
extends EditorActionBarContributor {
    private final MenuFactoryEclipse menuFactory = MenuFactoryEclipse.getInstance();
    private IAction customnew;
    private IAction customedit;
    private IAction undoActionGlobal;
    private IAction redoActionGlobal;
    private IAction printActionGlobal;
    private IAction copyActionDiagram;
    private IAction cutActionDiagram;
    private IAction pasteActionDiagram;
    private IAction deleteActionDiagram;
    private IAction selectallActionDiagram;
    private IAction searchActionDiagram;
    private IAction copyActionPropPanel;
    private IAction cutActionPropPanel;
    private IAction pasteActionPropPanel;
    private IAction selectAllActionPropPanel;
    private IAction copyActionCustomPanel;
    private IAction cutActionCustomPanel;
    private IAction pasteActionCustomPanel;
    private IAction selectAllActionCustomPanel;
    private List<IAction> exportAsActionList;
    private boolean customPanelEnabled = false;
    private boolean custom_element_selected = false;
    private IMenuManager zoomMenu;

    private Action createPanelAction(final EclipseGUI.Pane pane, final ActionName action) {
        Action copyActionPropPanel = new Action(){

            public void run() {
                ((EclipseGUI)CurrentGui.getInstance().getGui()).panelDoAction(pane, action);
            }
        };
        return copyActionPropPanel;
    }

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        this.customedit = this.menuFactory.createEditSelected();
        this.customedit.setEnabled(false);
        this.undoActionGlobal = this.menuFactory.createUndo();
        this.redoActionGlobal = this.menuFactory.createRedo();
        this.printActionGlobal = this.menuFactory.createPrint();
        this.cutActionDiagram = this.menuFactory.createCut();
        this.cutActionDiagram.setEnabled(false);
        this.pasteActionDiagram = this.menuFactory.createPaste();
        this.pasteActionDiagram.setEnabled(false);
        this.deleteActionDiagram = this.menuFactory.createDelete();
        this.deleteActionDiagram.setEnabled(false);
        this.searchActionDiagram = this.menuFactory.createSearch();
        this.copyActionDiagram = this.menuFactory.createCopy();
        this.selectallActionDiagram = this.menuFactory.createSelectAll();
        this.copyActionCustomPanel = this.createPanelAction(EclipseGUI.Pane.CUSTOMCODE, ActionName.COPY);
        this.cutActionCustomPanel = this.createPanelAction(EclipseGUI.Pane.CUSTOMCODE, ActionName.CUT);
        this.pasteActionCustomPanel = this.createPanelAction(EclipseGUI.Pane.CUSTOMCODE, ActionName.PASTE);
        this.selectAllActionCustomPanel = this.createPanelAction(EclipseGUI.Pane.CUSTOMCODE, ActionName.SELECTALL);
        this.copyActionPropPanel = this.createPanelAction(EclipseGUI.Pane.PROPERTY, ActionName.COPY);
        this.cutActionPropPanel = this.createPanelAction(EclipseGUI.Pane.PROPERTY, ActionName.CUT);
        this.pasteActionPropPanel = this.createPanelAction(EclipseGUI.Pane.PROPERTY, ActionName.PASTE);
        this.selectAllActionPropPanel = this.createPanelAction(EclipseGUI.Pane.PROPERTY, ActionName.SELECTALL);
        this.setGlobalActionHandlers(EclipseGUI.Pane.DIAGRAM);
    }

    public void contributeToMenu(IMenuManager manager) {
        ((EclipseGUI)CurrentGui.getInstance().getGui()).setContributor(this);
        MenuManager menu = new MenuManager(Program.getInstance().getProgramName().toString());
        MenuManager custom = new MenuManager("Custom Elements");
        MenuManager help = new MenuManager("Help");
        manager.appendToGroup("additions", (IContributionItem)menu);
        this.customnew = this.menuFactory.createNewCustomElement();
        custom.add(this.customnew);
        custom.add((IContributionItem)this.menuFactory.createNewCustomElementFromTemplate(this));
        custom.add((IContributionItem)new Separator());
        custom.add((IAction)this.menuFactory.createCustomElementsTutorial());
        help.add((IAction)this.menuFactory.createOnlineHelp());
        help.add((IAction)this.menuFactory.createOnlineSampleDiagrams());
        help.add((IAction)this.menuFactory.createVideoTutorial());
        help.add((IContributionItem)new Separator());
        help.add((IAction)this.menuFactory.createProgramHomepage());
        help.add((IAction)this.menuFactory.createRateProgram());
        help.add((IContributionItem)new Separator());
        help.add((IAction)this.menuFactory.createAboutProgram());
        menu.add(this.menuFactory.createGenerate());
        menu.add(this.menuFactory.createGenerateOptions());
        this.zoomMenu = this.menuFactory.createZoom();
        menu.add((IContributionItem)this.zoomMenu);
        this.exportAsActionList = this.menuFactory.createExportAsActions();
        MenuManager export = new MenuManager("Export as");
        for (IAction action : this.exportAsActionList) {
            export.add(action);
        }
        menu.add((IContributionItem)export);
        menu.add((IAction)this.menuFactory.createEditCurrentPalette());
        menu.add((IContributionItem)custom);
        menu.add((IAction)this.menuFactory.createMailTo());
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)help);
        menu.add((IAction)this.menuFactory.createOptions());
    }

    public void setExportAsEnabled(boolean enabled) {
        for (IAction action : this.exportAsActionList) {
            action.setEnabled(enabled);
        }
    }

    public void setPaste(boolean value) {
        this.pasteActionDiagram.setEnabled(value);
    }

    public void setCustomElementSelected(boolean selected) {
        this.custom_element_selected = selected;
        this.customedit.setEnabled(selected && !this.customPanelEnabled);
    }

    public void setElementsSelected(Collection<GridElement> selectedElements) {
        if (selectedElements.isEmpty()) {
            this.deleteActionDiagram.setEnabled(false);
            this.cutActionDiagram.setEnabled(false);
        } else {
            this.cutActionDiagram.setEnabled(true);
            this.deleteActionDiagram.setEnabled(true);
        }
    }

    public boolean isCustomPanelEnabled() {
        return this.customPanelEnabled;
    }

    public void setCustomPanelEnabled(boolean enable) {
        this.customPanelEnabled = enable;
        this.customedit.setEnabled(!enable && this.custom_element_selected);
        this.customnew.setEnabled(!enable);
        this.searchActionDiagram.setEnabled(!enable);
    }

    public void setGlobalActionHandlers(EclipseGUI.Pane focusedPane) {
        this.getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undoActionGlobal);
        this.getActionBars().setGlobalActionHandler(ActionFactory.REDO.getId(), this.redoActionGlobal);
        this.getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), this.printActionGlobal);
        if (focusedPane == EclipseGUI.Pane.DIAGRAM) {
            this.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), this.copyActionDiagram);
            this.getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), this.cutActionDiagram);
            this.getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), this.pasteActionDiagram);
            this.getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), this.deleteActionDiagram);
            this.getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectallActionDiagram);
            this.getActionBars().setGlobalActionHandler(ActionFactory.FIND.getId(), this.searchActionDiagram);
        } else if (focusedPane == EclipseGUI.Pane.CUSTOMCODE) {
            this.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), this.copyActionCustomPanel);
            this.getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), this.cutActionCustomPanel);
            this.getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), this.pasteActionCustomPanel);
            this.getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), null);
            this.getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectAllActionCustomPanel);
            this.getActionBars().setGlobalActionHandler(ActionFactory.FIND.getId(), null);
        } else if (focusedPane == EclipseGUI.Pane.PROPERTY) {
            this.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), this.copyActionPropPanel);
            this.getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), this.cutActionPropPanel);
            this.getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), this.pasteActionPropPanel);
            this.getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), null);
            this.getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectAllActionPropPanel);
            this.getActionBars().setGlobalActionHandler(ActionFactory.FIND.getId(), null);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Contributor.this.getActionBars().updateActionBars();
            }
        });
    }

    public void updateZoomMenuRadioButton(int newGridSize) {
        IContributionItem[] iContributionItemArray = this.zoomMenu.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            IAction action = ((ActionContributionItem)item).getAction();
            int actionGridSize = Integer.parseInt(action.getText().substring(0, action.getText().length() - 2));
            if (actionGridSize == newGridSize) {
                action.setChecked(true);
            } else {
                action.setChecked(false);
            }
            ++n2;
        }
    }

    public static enum ActionName {
        COPY,
        CUT,
        PASTE,
        SELECTALL;

    }
}

