/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import com.mongodb.DBPort;
import com.mongodb.Mongo;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ConnectionStatus {
    protected BackgroundUpdater _updater;
    protected final Mongo _mongo;
    protected final List<ServerAddress> _mongosAddresses;
    protected volatile boolean _closed;
    protected final MongoOptions _mongoOptions = mongoOptionsDefaults.copy();
    protected static int updaterIntervalMS;
    protected static int updaterIntervalNoMasterMS;
    protected static final MongoOptions mongoOptionsDefaults;
    protected static final float latencySmoothFactor;
    protected static final DBObject isMasterCmd;

    ConnectionStatus(List<ServerAddress> mongosAddresses, Mongo mongo) {
        this._mongoOptions.socketFactory = mongo._options.socketFactory;
        this._mongosAddresses = new ArrayList<ServerAddress>(mongosAddresses);
        this._mongo = mongo;
    }

    void start() {
        if (this._updater != null) {
            this._updater.start();
        }
    }

    void close() {
        this._closed = true;
        if (this._updater != null) {
            this._updater.interrupt();
        }
    }

    abstract List<ServerAddress> getServerAddressList();

    abstract boolean hasServerUp();

    abstract Node ensureMaster();

    void checkClosed() {
        if (this._closed) {
            throw new IllegalStateException("ReplicaSetStatus closed");
        }
    }

    static {
        mongoOptionsDefaults = new MongoOptions();
        isMasterCmd = new BasicDBObject("ismaster", (Object)1);
        updaterIntervalMS = Integer.parseInt(System.getProperty("com.mongodb.updaterIntervalMS", "5000"));
        updaterIntervalNoMasterMS = Integer.parseInt(System.getProperty("com.mongodb.updaterIntervalNoMasterMS", "10"));
        ConnectionStatus.mongoOptionsDefaults.connectTimeout = Integer.parseInt(System.getProperty("com.mongodb.updaterConnectTimeoutMS", "20000"));
        ConnectionStatus.mongoOptionsDefaults.socketTimeout = Integer.parseInt(System.getProperty("com.mongodb.updaterSocketTimeoutMS", "20000"));
        latencySmoothFactor = Float.parseFloat(System.getProperty("com.mongodb.latencySmoothFactor", "4"));
    }

    static abstract class UpdatableNode {
        final ServerAddress _addr;
        final MongoOptions _mongoOptions;
        final Mongo _mongo;
        DBPort _port;
        boolean successfullyContacted = false;
        boolean _ok = false;
        float _pingTimeMS = 0.0f;
        int _maxBsonObjectSize;

        UpdatableNode(ServerAddress addr, Mongo mongo, MongoOptions mongoOptions) {
            this._addr = addr;
            this._mongo = mongo;
            this._mongoOptions = mongoOptions;
            this._port = new DBPort(addr, null, mongoOptions);
        }

        public CommandResult update() {
            CommandResult res = null;
            try {
                long start = System.nanoTime();
                res = this._port.runCommand(this._mongo.getDB("admin"), isMasterCmd);
                long end = System.nanoTime();
                float newPingMS = (float)(end - start) / 1000000.0f;
                this._pingTimeMS = !this.successfullyContacted ? newPingMS : (this._pingTimeMS += (newPingMS - this._pingTimeMS) / latencySmoothFactor);
                this.getLogger().log(Level.FINE, "Latency to " + this._addr + " actual=" + newPingMS + " smoothed=" + this._pingTimeMS);
                this.successfullyContacted = true;
                if (res == null) {
                    throw new MongoInternalException("Invalid null value returned from isMaster");
                }
                if (!this._ok) {
                    this.getLogger().log(Level.INFO, "Server seen up: " + this._addr);
                }
                this._ok = true;
                this._maxBsonObjectSize = res.containsField("maxBsonObjectSize") ? (Integer)res.get("maxBsonObjectSize") : 0x400000;
            }
            catch (Exception e) {
                if (!this._ok && !(Math.random() > 0.1)) {
                    return res;
                }
                StringBuilder logError = new StringBuilder("Server seen down: ").append(this._addr);
                if (e instanceof IOException) {
                    logError.append(" - ").append(IOException.class.getName());
                    if (e.getMessage() != null) {
                        logError.append(" - message: ").append(e.getMessage());
                    }
                    this.getLogger().log(Level.WARNING, logError.toString());
                } else {
                    this.getLogger().log(Level.WARNING, logError.toString(), e);
                }
                this._ok = false;
            }
            return res;
        }

        protected abstract Logger getLogger();
    }

    static class BackgroundUpdater
    extends Thread {
        public BackgroundUpdater(String name) {
            super(name);
            this.setDaemon(true);
        }
    }

    static class Node {
        protected final ServerAddress _addr;
        protected final float _pingTime;
        protected final boolean _ok;
        protected final int _maxBsonObjectSize;

        Node(float pingTime, ServerAddress addr, int maxBsonObjectSize, boolean ok) {
            this._pingTime = pingTime;
            this._addr = addr;
            this._maxBsonObjectSize = maxBsonObjectSize;
            this._ok = ok;
        }

        public boolean isOk() {
            return this._ok;
        }

        public int getMaxBsonObjectSize() {
            return this._maxBsonObjectSize;
        }

        public ServerAddress getServerAddress() {
            return this._addr;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            if (this._maxBsonObjectSize != node._maxBsonObjectSize) {
                return false;
            }
            if (this._ok != node._ok) {
                return false;
            }
            if (Float.compare(node._pingTime, this._pingTime) != 0) {
                return false;
            }
            return this._addr.equals(node._addr);
        }

        public int hashCode() {
            int result = this._addr.hashCode();
            result = 31 * result + (this._pingTime != 0.0f ? Float.floatToIntBits(this._pingTime) : 0);
            result = 31 * result + (this._ok ? 1 : 0);
            result = 31 * result + this._maxBsonObjectSize;
            return result;
        }

        public String toJSON() {
            StringBuilder buf = new StringBuilder();
            buf.append("{");
            buf.append("address:'").append(this._addr).append("', ");
            buf.append("ok:").append(this._ok).append(", ");
            buf.append("ping:").append(this._pingTime).append(", ");
            buf.append("maxBsonObjectSize:").append(this._maxBsonObjectSize).append(", ");
            buf.append("}");
            return buf.toString();
        }
    }
}

