/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;

public class ClusterChangedEvent {
    private final String source;
    private final ClusterState previousState;
    private final ClusterState state;
    private final DiscoveryNodes.Delta nodesDelta;

    public ClusterChangedEvent(String source, ClusterState state, ClusterState previousState) {
        this.source = source;
        this.state = state;
        this.previousState = previousState;
        this.nodesDelta = state.nodes().delta(previousState.nodes());
    }

    public String source() {
        return this.source;
    }

    public ClusterState state() {
        return this.state;
    }

    public ClusterState previousState() {
        return this.previousState;
    }

    public boolean routingTableChanged() {
        return this.state.routingTable() != this.previousState.routingTable();
    }

    public boolean indexRoutingTableChanged(String index) {
        if (!this.state.routingTable().hasIndex(index) && !this.previousState.routingTable().hasIndex(index)) {
            return false;
        }
        if (this.state.routingTable().hasIndex(index) && this.previousState.routingTable().hasIndex(index)) {
            return this.state.routingTable().index(index) != this.previousState.routingTable().index(index);
        }
        return true;
    }

    public List<String> indicesCreated() {
        if (this.previousState == null) {
            return Arrays.asList(this.state.metaData().indices().keys().toArray(String.class));
        }
        if (!this.metaDataChanged()) {
            return Collections.emptyList();
        }
        ArrayList<String> created = null;
        for (ObjectCursor cursor : this.state.metaData().indices().keys()) {
            String index = (String)cursor.value;
            if (this.previousState.metaData().hasIndex(index)) continue;
            if (created == null) {
                created = new ArrayList<String>();
            }
            created.add(index);
        }
        return created == null ? Collections.emptyList() : created;
    }

    public List<String> indicesDeleted() {
        if (this.hasNewMaster() || this.previousState == null) {
            return Collections.emptyList();
        }
        if (!this.metaDataChanged()) {
            return Collections.emptyList();
        }
        ArrayList<String> deleted = null;
        for (ObjectCursor cursor : this.previousState.metaData().indices().keys()) {
            String index = (String)cursor.value;
            if (this.state.metaData().hasIndex(index)) continue;
            if (deleted == null) {
                deleted = new ArrayList<String>();
            }
            deleted.add(index);
        }
        return deleted == null ? Collections.emptyList() : deleted;
    }

    public boolean metaDataChanged() {
        return this.state.metaData() != this.previousState.metaData();
    }

    public boolean indexMetaDataChanged(IndexMetaData current) {
        MetaData previousMetaData = this.previousState.metaData();
        if (previousMetaData == null) {
            return true;
        }
        IndexMetaData previousIndexMetaData = previousMetaData.index(current.getIndex());
        return previousIndexMetaData != current;
    }

    public boolean blocksChanged() {
        return this.state.blocks() != this.previousState.blocks();
    }

    public boolean localNodeMaster() {
        return this.state.nodes().localNodeMaster();
    }

    public DiscoveryNodes.Delta nodesDelta() {
        return this.nodesDelta;
    }

    public boolean nodesRemoved() {
        return this.nodesDelta.removed();
    }

    public boolean nodesAdded() {
        return this.nodesDelta.added();
    }

    public boolean nodesChanged() {
        return this.nodesRemoved() || this.nodesAdded();
    }

    private boolean hasNewMaster() {
        String oldMaster = this.previousState().getNodes().masterNodeId();
        String newMaster = this.state().getNodes().masterNodeId();
        if (oldMaster == null && newMaster == null) {
            return false;
        }
        if (oldMaster == null && newMaster != null) {
            return true;
        }
        return !oldMaster.equals(newMaster);
    }
}

