/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.postingsformat;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.util.BloomFilter;

@Deprecated
public class BloomFilterPostingsFormat
extends PostingsFormat {
    public static final String BLOOM_CODEC_NAME = "XBloomFilter";
    public static final int BLOOM_CODEC_VERSION = 1;
    public static final int BLOOM_CODEC_VERSION_CHECKSUM = 2;
    public static final int BLOOM_CODEC_VERSION_CURRENT = 2;
    static final String BLOOM_EXTENSION = "blm";
    private BloomFilter.Factory bloomFilterFactory = BloomFilter.Factory.DEFAULT;
    private PostingsFormat delegatePostingsFormat;

    public BloomFilterPostingsFormat(PostingsFormat delegatePostingsFormat, BloomFilter.Factory bloomFilterFactory) {
        super(BLOOM_CODEC_NAME);
        this.delegatePostingsFormat = delegatePostingsFormat;
        this.bloomFilterFactory = bloomFilterFactory;
    }

    public BloomFilterPostingsFormat() {
        super(BLOOM_CODEC_NAME);
    }

    public BloomFilteredFieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        throw new UnsupportedOperationException("this codec can only be used for reading");
    }

    public BloomFilteredFieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new BloomFilteredFieldsProducer(state);
    }

    public PostingsFormat getDelegate() {
        return this.delegatePostingsFormat;
    }

    public final class BloomFilteredFieldsConsumer
    extends FieldsConsumer {
        private final FieldsConsumer delegateFieldsConsumer;
        private final Map<FieldInfo, BloomFilter> bloomFilters = new HashMap<FieldInfo, BloomFilter>();
        private final SegmentWriteState state;
        private boolean closed = false;

        public BloomFilteredFieldsConsumer(FieldsConsumer fieldsConsumer, SegmentWriteState state, PostingsFormat delegatePostingsFormat) {
            this.delegateFieldsConsumer = fieldsConsumer;
            this.state = state;
        }

        public FieldsConsumer getDelegate() {
            return this.delegateFieldsConsumer;
        }

        public void write(Fields fields) throws IOException {
            this.delegateFieldsConsumer.write(fields);
            for (String field : fields) {
                BytesRef term;
                Terms terms = fields.terms(field);
                if (terms == null) continue;
                FieldInfo fieldInfo = this.state.fieldInfos.fieldInfo(field);
                TermsEnum termsEnum = terms.iterator();
                BloomFilter bloomFilter = null;
                PostingsEnum postings = null;
                while ((term = termsEnum.next()) != null) {
                    if (bloomFilter == null) {
                        bloomFilter = BloomFilterPostingsFormat.this.bloomFilterFactory.createFilter(this.state.segmentInfo.maxDoc());
                        assert (!this.bloomFilters.containsKey(field));
                        this.bloomFilters.put(fieldInfo, bloomFilter);
                    }
                    if ((postings = termsEnum.postings(postings, 0)).nextDoc() == Integer.MAX_VALUE) continue;
                    bloomFilter.put(term);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.delegateFieldsConsumer.close();
            ArrayList<Map.Entry<FieldInfo, BloomFilter>> nonSaturatedBlooms = new ArrayList<Map.Entry<FieldInfo, BloomFilter>>();
            for (Map.Entry<FieldInfo, BloomFilter> entry : this.bloomFilters.entrySet()) {
                nonSaturatedBlooms.add(entry);
            }
            String bloomFileName = IndexFileNames.segmentFileName((String)this.state.segmentInfo.name, (String)this.state.segmentSuffix, (String)BloomFilterPostingsFormat.BLOOM_EXTENSION);
            IndexOutput bloomOutput = null;
            try {
                bloomOutput = this.state.directory.createOutput(bloomFileName, this.state.context);
                CodecUtil.writeHeader((DataOutput)bloomOutput, (String)BloomFilterPostingsFormat.BLOOM_CODEC_NAME, (int)2);
                bloomOutput.writeString(BloomFilterPostingsFormat.this.delegatePostingsFormat.getName());
                bloomOutput.writeInt(nonSaturatedBlooms.size());
                for (Map.Entry entry : nonSaturatedBlooms) {
                    FieldInfo fieldInfo = (FieldInfo)entry.getKey();
                    BloomFilter bloomFilter = (BloomFilter)entry.getValue();
                    bloomOutput.writeInt(fieldInfo.number);
                    this.saveAppropriatelySizedBloomFilter(bloomOutput, bloomFilter, fieldInfo);
                }
                CodecUtil.writeFooter((IndexOutput)bloomOutput);
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{bloomOutput});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{bloomOutput});
            this.bloomFilters.clear();
        }

        private void saveAppropriatelySizedBloomFilter(IndexOutput bloomOutput, BloomFilter bloomFilter, FieldInfo fieldInfo) throws IOException {
            BloomFilter.serilaize(bloomFilter, (DataOutput)bloomOutput);
        }
    }

    static final class BloomFilteredTermsEnum
    extends TermsEnum {
        private Terms delegateTerms;
        private TermsEnum delegateTermsEnum;
        private BloomFilter filter;

        public BloomFilteredTermsEnum(Terms other, BloomFilter filter) {
            this.delegateTerms = other;
            this.filter = filter;
        }

        void reset(Terms others) {
            this.delegateTermsEnum = null;
            this.delegateTerms = others;
        }

        private TermsEnum getDelegate() throws IOException {
            if (this.delegateTermsEnum == null) {
                this.delegateTermsEnum = this.delegateTerms.iterator();
            }
            return this.delegateTermsEnum;
        }

        public final BytesRef next() throws IOException {
            return this.getDelegate().next();
        }

        public final boolean seekExact(BytesRef text) throws IOException {
            if (!this.filter.mightContain(text)) {
                return false;
            }
            return this.getDelegate().seekExact(text);
        }

        public final TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            return this.getDelegate().seekCeil(text);
        }

        public final void seekExact(long ord) throws IOException {
            this.getDelegate().seekExact(ord);
        }

        public final BytesRef term() throws IOException {
            return this.getDelegate().term();
        }

        public final long ord() throws IOException {
            return this.getDelegate().ord();
        }

        public final int docFreq() throws IOException {
            return this.getDelegate().docFreq();
        }

        public final long totalTermFreq() throws IOException {
            return this.getDelegate().totalTermFreq();
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            return this.getDelegate().postings(reuse, flags);
        }
    }

    public static final class BloomFilteredTerms
    extends FilterLeafReader.FilterTerms {
        private BloomFilter filter;

        public BloomFilteredTerms(Terms terms, BloomFilter filter) {
            super(terms);
            this.filter = filter;
        }

        public BloomFilter getFilter() {
            return this.filter;
        }

        public TermsEnum iterator() throws IOException {
            return new BloomFilteredTermsEnum(this.in, this.filter);
        }
    }

    public final class BloomFilteredFieldsProducer
    extends FieldsProducer {
        private FieldsProducer delegateFieldsProducer;
        HashMap<String, LazyBloomLoader> bloomsByFieldName = new HashMap();
        private final int version;
        private final IndexInput data;

        FieldsProducer getDelegate() {
            return this.delegateFieldsProducer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BloomFilteredFieldsProducer(SegmentReadState state) throws IOException {
            String bloomFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)BloomFilterPostingsFormat.BLOOM_EXTENSION);
            Directory directory = state.directory;
            IndexInput dataInput = directory.openInput(bloomFileName, state.context);
            try {
                BufferedChecksumIndexInput bloomIn = new BufferedChecksumIndexInput(dataInput.clone());
                this.version = CodecUtil.checkHeader((DataInput)bloomIn, (String)BloomFilterPostingsFormat.BLOOM_CODEC_NAME, (int)1, (int)2);
                String delegatePostings = bloomIn.readString();
                this.delegateFieldsProducer = PostingsFormat.forName((String)delegatePostings).fieldsProducer(state);
                this.data = dataInput;
                dataInput = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{dataInput});
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{dataInput});
        }

        public Iterator<String> iterator() {
            return this.delegateFieldsProducer.iterator();
        }

        public void close() throws IOException {
            IOUtils.close((Closeable[])new Closeable[]{this.data, this.delegateFieldsProducer});
        }

        public Terms terms(String field) throws IOException {
            LazyBloomLoader filter = this.bloomsByFieldName.get(field);
            if (filter == null) {
                return this.delegateFieldsProducer.terms(field);
            }
            Terms result = this.delegateFieldsProducer.terms(field);
            if (result == null) {
                return null;
            }
            return new BloomFilteredTerms(result, filter.get());
        }

        public int size() {
            return this.delegateFieldsProducer.size();
        }

        public long ramBytesUsed() {
            long size = this.delegateFieldsProducer.ramBytesUsed();
            for (LazyBloomLoader bloomFilter : this.bloomsByFieldName.values()) {
                size += bloomFilter.ramBytesUsed();
            }
            return size;
        }

        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            resources.addAll(Accountables.namedAccountables((String)"field", this.bloomsByFieldName));
            if (this.delegateFieldsProducer != null) {
                resources.add(Accountables.namedAccountable((String)"delegate", (Accountable)this.delegateFieldsProducer));
            }
            return Collections.unmodifiableList(resources);
        }

        public void checkIntegrity() throws IOException {
            this.delegateFieldsProducer.checkIntegrity();
            if (this.version >= 2) {
                CodecUtil.checksumEntireFile((IndexInput)this.data);
            }
        }

        public FieldsProducer getMergeInstance() throws IOException {
            return this.delegateFieldsProducer.getMergeInstance();
        }
    }

    private final class LazyBloomLoader
    implements Accountable {
        private final long offset;
        private final IndexInput indexInput;
        private BloomFilter filter;

        private LazyBloomLoader(long offset, IndexInput origial) {
            this.offset = offset;
            this.indexInput = origial.clone();
        }

        synchronized BloomFilter get() throws IOException {
            if (this.filter == null) {
                try (IndexInput input = this.indexInput;){
                    input.seek(this.offset);
                    this.filter = BloomFilter.deserialize((DataInput)input);
                }
            }
            return this.filter;
        }

        public long ramBytesUsed() {
            return this.filter == null ? 0L : this.filter.getSizeInBytes();
        }

        public Collection<Accountable> getChildResources() {
            return Collections.singleton(Accountables.namedAccountable((String)"bloom", (long)this.ramBytesUsed()));
        }
    }
}

