/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.MergeResult;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;

public class VersionFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_version";
    public static final String CONTENT_TYPE = "_version";

    private VersionFieldMapper(Settings indexSettings) {
        super("_version", Defaults.FIELD_TYPE, Defaults.FIELD_TYPE, indexSettings);
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        NumericDocValuesField version = new NumericDocValuesField("_version", -1L);
        context.version((Field)version);
        fields.add((Field)version);
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        for (int i = 1; i < context.docs().size(); ++i) {
            ParseContext.Document doc = context.docs().get(i);
            doc.add((IndexableField)new NumericDocValuesField("_version", 1L));
        }
    }

    @Override
    protected String contentType() {
        return "_version";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeResult mergeResult) throws MergeMappingException {
    }

    static final class VersionFieldType
    extends MappedFieldType {
        public VersionFieldType() {
            this.setFieldDataType(new FieldDataType("long"));
        }

        protected VersionFieldType(VersionFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new VersionFieldType(this);
        }

        @Override
        public String typeName() {
            return "_version";
        }

        @Override
        public Long value(Object value) {
            if (value == null || value instanceof Long) {
                return (Long)value;
            }
            return Long.parseLong(value.toString());
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder();
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                if (!fieldName.equals("doc_values_format") || !parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1)) continue;
                iterator.remove();
            }
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(Settings indexSettings, MappedFieldType fieldType, String typeName) {
            return new VersionFieldMapper(indexSettings);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, VersionFieldMapper> {
        public Builder() {
            super("_version", Defaults.FIELD_TYPE);
        }

        @Override
        public VersionFieldMapper build(Mapper.BuilderContext context) {
            return new VersionFieldMapper(context.indexSettings());
        }
    }

    public static class Defaults {
        public static final String NAME = "_version";
        public static final MappedFieldType FIELD_TYPE = new VersionFieldType();

        static {
            FIELD_TYPE.setNames(new MappedFieldType.Names("_version"));
            FIELD_TYPE.setDocValuesType(DocValuesType.NUMERIC);
            FIELD_TYPE.setHasDocValues(true);
            FIELD_TYPE.freeze();
        }
    }
}

