/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.internal.SourceFieldMapper;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.highlight.Highlighter;
import org.elasticsearch.search.highlight.HighlighterContext;
import org.elasticsearch.search.highlight.HighlighterParseElement;
import org.elasticsearch.search.highlight.Highlighters;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.SearchContext;

public class HighlightPhase
extends AbstractComponent
implements FetchSubPhase {
    private static final List<String> STANDARD_HIGHLIGHTERS_BY_PRECEDENCE = Arrays.asList("fvh", "postings", "plain");
    private final Highlighters highlighters;

    @Inject
    public HighlightPhase(Settings settings, Highlighters highlighters) {
        super(settings);
        this.highlighters = highlighters;
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of((Object)"highlight", (Object)new HighlighterParseElement());
    }

    @Override
    public boolean hitsExecutionNeeded(SearchContext context) {
        return false;
    }

    @Override
    public void hitsExecute(SearchContext context, InternalSearchHit[] hits) {
    }

    @Override
    public boolean hitExecutionNeeded(SearchContext context) {
        return context.highlight() != null;
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        HashMap highlightFields = Maps.newHashMap();
        for (SearchContextHighlight.Field field : context.highlight().fields()) {
            SourceFieldMapper sourceFieldMapper;
            Collection<String> fieldNamesToHighlight;
            if (Regex.isSimpleMatchPattern(field.field())) {
                DocumentMapper documentMapper = context.mapperService().documentMapper(hitContext.hit().type());
                fieldNamesToHighlight = documentMapper.mappers().simpleMatchToFullName(field.field());
            } else {
                fieldNamesToHighlight = Collections.singletonList(field.field());
            }
            if (context.highlight().forceSource(field) && !(sourceFieldMapper = context.mapperService().documentMapper(hitContext.hit().type()).sourceMapper()).enabled()) {
                throw new IllegalArgumentException("source is forced for fields " + fieldNamesToHighlight + " but type [" + hitContext.hit().type() + "] has disabled _source");
            }
            boolean fieldNameContainsWildcards = field.field().contains("*");
            for (String fieldName : fieldNamesToHighlight) {
                HighlightField highlightField;
                Highlighter highlighter;
                FieldMapper fieldMapper = this.getMapperForField(fieldName, context, hitContext);
                if (fieldMapper == null) continue;
                String highlighterType = field.fieldOptions().highlighterType();
                if (highlighterType == null) {
                    for (String highlighterCandidate : STANDARD_HIGHLIGHTERS_BY_PRECEDENCE) {
                        if (!this.highlighters.get(highlighterCandidate).canHighlight(fieldMapper)) continue;
                        highlighterType = highlighterCandidate;
                        break;
                    }
                    assert (highlighterType != null);
                }
                if ((highlighter = this.highlighters.get(highlighterType)) == null) {
                    throw new IllegalArgumentException("unknown highlighter type [" + highlighterType + "] for the field [" + fieldName + "]");
                }
                Query highlightQuery = field.fieldOptions().highlightQuery() == null ? context.parsedQuery().query() : field.fieldOptions().highlightQuery();
                HighlighterContext highlighterContext = new HighlighterContext(fieldName, field, fieldMapper, context, hitContext, highlightQuery);
                if (!highlighter.canHighlight(fieldMapper) && fieldNameContainsWildcards || (highlightField = highlighter.highlight(highlighterContext)) == null) continue;
                highlightFields.put(highlightField.name(), highlightField);
            }
        }
        hitContext.hit().highlightFields(highlightFields);
    }

    private FieldMapper getMapperForField(String fieldName, SearchContext searchContext, FetchSubPhase.HitContext hitContext) {
        DocumentMapper documentMapper = searchContext.mapperService().documentMapper(hitContext.hit().type());
        return documentMapper.mappers().smartNameFieldMapper(fieldName);
    }
}

