/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.rhino.worker.internal;

import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorker;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorkerSpec;
import org.gradle.plugins.javascript.rhino.worker.internal.RhinoClientWorkerProtocol;
import org.gradle.plugins.javascript.rhino.worker.internal.RhinoWorkerClientProtocol;
import org.gradle.plugins.javascript.rhino.worker.internal.RhinoWorkerReceiver;
import org.gradle.process.internal.WorkerProcessContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhinoServer<R extends Serializable, P extends Serializable>
implements Action<WorkerProcessContext>,
Serializable {
    private final RhinoWorkerSpec<R, P> workerSpec;

    public RhinoServer(RhinoWorkerSpec<R, P> workerSpec) {
        this.workerSpec = workerSpec;
    }

    public void execute(WorkerProcessContext context) {
        RhinoWorker action;
        RhinoWorkerClientProtocol clientHandle = (RhinoWorkerClientProtocol)context.getServerConnection().addOutgoing(RhinoWorkerClientProtocol.class);
        context.getServerConnection().connect();
        try {
            Class<?> actionClass = this.getClass().getClassLoader().loadClass(this.workerSpec.getWorkerType().getName());
            Object actionObject = actionClass.newInstance();
            if (!(actionObject instanceof RhinoWorker)) {
                throw new IllegalStateException(String.format("Implementation class %s is not a transformer", this.workerSpec.getWorkerType().getName()));
            }
            action = (RhinoWorker)actionObject;
        }
        catch (Exception e) {
            clientHandle.initialisationError(e);
            return;
        }
        RhinoWorkerReceiver<P> receiver = new RhinoWorkerReceiver<P>(this.workerSpec.getPayloadType(), clientHandle, action);
        context.getServerConnection().addIncoming(RhinoClientWorkerProtocol.class, receiver);
        receiver.waitFor();
    }
}

