/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.internal.classloading.GroovySystemLoader;
import org.gradle.api.internal.classloading.GroovySystemLoaderFactory;
import org.gradle.api.internal.tasks.compile.daemon.CompileResult;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemon;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonFactory;
import org.gradle.api.internal.tasks.compile.daemon.DaemonForkOptions;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classloader.MutableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.io.ClassLoaderObjectInputStream;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.GUtil;

public class InProcessCompilerDaemonFactory
implements CompilerDaemonFactory {
    private final ClassLoaderFactory classLoaderFactory;
    private final File gradleUserHomeDir;
    private final GroovySystemLoaderFactory groovySystemLoaderFactory = new GroovySystemLoaderFactory();

    public InProcessCompilerDaemonFactory(ClassLoaderFactory classLoaderFactory, File gradleUserHomeDir) {
        this.classLoaderFactory = classLoaderFactory;
        this.gradleUserHomeDir = gradleUserHomeDir;
    }

    public CompilerDaemon getDaemon(File workingDir, final DaemonForkOptions forkOptions) {
        return new CompilerDaemon(){

            @Override
            public <T extends CompileSpec> CompileResult execute(Compiler<T> compiler, T spec) {
                ClassLoader groovyClassLoader = InProcessCompilerDaemonFactory.this.classLoaderFactory.createIsolatedClassLoader((ClassPath)new DefaultClassPath(forkOptions.getClasspath()));
                GroovySystemLoader groovyLoader = InProcessCompilerDaemonFactory.this.groovySystemLoaderFactory.forClassLoader(groovyClassLoader);
                FilteringClassLoader filteredGroovy = InProcessCompilerDaemonFactory.this.classLoaderFactory.createFilteringClassLoader(groovyClassLoader);
                for (String packageName : forkOptions.getSharedPackages()) {
                    filteredGroovy.allowPackage(packageName);
                }
                FilteringClassLoader loggingClassLoader = InProcessCompilerDaemonFactory.this.classLoaderFactory.createFilteringClassLoader(compiler.getClass().getClassLoader());
                loggingClassLoader.allowPackage("org.slf4j");
                loggingClassLoader.allowClass(Logger.class);
                loggingClassLoader.allowClass(LogLevel.class);
                CachingClassLoader groovyAndLoggingClassLoader = new CachingClassLoader((ClassLoader)new MultiParentClassLoader(new ClassLoader[]{loggingClassLoader, filteredGroovy}));
                MutableURLClassLoader workerClassLoader = new MutableURLClassLoader((ClassLoader)groovyAndLoggingClassLoader, (Collection)ClasspathUtil.getClasspath((ClassLoader)compiler.getClass().getClassLoader()));
                try {
                    byte[] serializedWorker = GUtil.serialize(new Worker(compiler, spec, InProcessCompilerDaemonFactory.this.gradleUserHomeDir, null));
                    ClassLoaderObjectInputStream inputStream = new ClassLoaderObjectInputStream((InputStream)new ByteArrayInputStream(serializedWorker), (ClassLoader)workerClassLoader);
                    Callable worker = (Callable)inputStream.readObject();
                    Object result = worker.call();
                    byte[] serializedResult = GUtil.serialize(result);
                    inputStream = new ClassLoaderObjectInputStream((InputStream)new ByteArrayInputStream(serializedResult), this.getClass().getClassLoader());
                    CompileResult compileResult = (CompileResult)inputStream.readObject();
                    return compileResult;
                }
                catch (Exception e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
                finally {
                    groovyLoader.shutdown();
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Worker<T extends CompileSpec>
    implements Callable<Object>,
    Serializable {
        private final Compiler<T> compiler;
        private final T spec;
        private final File gradleUserHome;

        private Worker(Compiler<T> compiler, T spec, File gradleUserHome) {
            this.compiler = compiler;
            this.spec = spec;
            this.gradleUserHome = gradleUserHome;
        }

        @Override
        public Object call() throws Exception {
            NativeServices.initialize((File)this.gradleUserHome);
            return new CompileResult(this.compiler.execute(this.spec).getDidWork(), null);
        }

        /* synthetic */ Worker(Compiler x0, CompileSpec x1, File x2, 1 x3) {
            this(x0, x1, x2);
        }
    }
}

