/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleResolutionFilter;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultModuleResolutionFilter
implements ModuleResolutionFilter {
    private static final AcceptAllSpec ALL_SPEC = new AcceptAllSpec();
    private static final String WILDCARD = "*";

    public static ModuleResolutionFilter all() {
        return ALL_SPEC;
    }

    public static ModuleResolutionFilter excludeAny(ExcludeRule ... excludeRules) {
        if (excludeRules.length == 0) {
            return ALL_SPEC;
        }
        return new ExcludeRuleBackedSpec(Arrays.asList(excludeRules));
    }

    public static ModuleResolutionFilter excludeAny(Collection<ExcludeRule> excludeRules) {
        if (excludeRules.isEmpty()) {
            return ALL_SPEC;
        }
        return new ExcludeRuleBackedSpec(excludeRules);
    }

    private static boolean isWildcard(String attribute) {
        return WILDCARD.equals(attribute);
    }

    @Override
    public ModuleResolutionFilter union(ModuleResolutionFilter other) {
        if (other == this) {
            return this;
        }
        if (other == ALL_SPEC) {
            return other;
        }
        if (this == ALL_SPEC) {
            return this;
        }
        ArrayList<DefaultModuleResolutionFilter> specs = new ArrayList<DefaultModuleResolutionFilter>();
        this.unpackUnion(specs);
        ((DefaultModuleResolutionFilter)other).unpackUnion(specs);
        int i = 0;
        while (i < specs.size()) {
            DefaultModuleResolutionFilter spec = (DefaultModuleResolutionFilter)specs.get(i);
            DefaultModuleResolutionFilter merged = null;
            for (int j = i + 1; j < specs.size(); ++j) {
                merged = spec.doUnion((DefaultModuleResolutionFilter)specs.get(j));
                if (merged == null) continue;
                specs.remove(j);
                break;
            }
            if (merged != null) {
                specs.set(i, merged);
                continue;
            }
            ++i;
        }
        if (specs.size() == 1) {
            return (ModuleResolutionFilter)specs.get(0);
        }
        return new UnionSpec(specs);
    }

    protected void unpackUnion(Collection<DefaultModuleResolutionFilter> specs) {
        specs.add(this);
    }

    protected DefaultModuleResolutionFilter doUnion(DefaultModuleResolutionFilter other) {
        return null;
    }

    @Override
    public final boolean acceptsSameModulesAs(ModuleResolutionFilter filter) {
        if (filter == this) {
            return true;
        }
        DefaultModuleResolutionFilter other = (DefaultModuleResolutionFilter)filter;
        boolean thisAcceptsEverything = this.acceptsAllModules();
        boolean otherAcceptsEverything = other.acceptsAllModules();
        if (thisAcceptsEverything && otherAcceptsEverything) {
            return true;
        }
        if (thisAcceptsEverything ^ otherAcceptsEverything) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        return this.doAcceptsSameModulesAs(other);
    }

    protected boolean doAcceptsSameModulesAs(DefaultModuleResolutionFilter other) {
        return false;
    }

    protected boolean acceptsAllModules() {
        return false;
    }

    @Override
    public ModuleResolutionFilter intersect(ModuleResolutionFilter other) {
        if (other == this) {
            return this;
        }
        if (other == ALL_SPEC) {
            return this;
        }
        if (this == ALL_SPEC) {
            return other;
        }
        ArrayList<DefaultModuleResolutionFilter> specs = new ArrayList<DefaultModuleResolutionFilter>();
        this.unpackIntersection(specs);
        ((DefaultModuleResolutionFilter)other).unpackIntersection(specs);
        return new ExcludeRuleBackedSpec((Collection<DefaultModuleResolutionFilter>)specs);
    }

    protected void unpackIntersection(Collection<DefaultModuleResolutionFilter> specs) {
        specs.add(this);
    }

    private static class ArtifactExcludeSpec
    extends DefaultModuleResolutionFilter {
        private final ModuleIdentifier moduleId;
        private final IvyArtifactName ivyArtifactName;
        private final PatternMatcher matcher;

        private ArtifactExcludeSpec(ExcludeRule rule) {
            this.moduleId = DefaultModuleIdentifier.newId(rule.getId().getModuleId().getOrganisation(), rule.getId().getModuleId().getName());
            this.ivyArtifactName = new DefaultIvyArtifactName(rule.getId().getName(), rule.getId().getType(), rule.getId().getExt());
            this.matcher = rule.getMatcher();
        }

        public String toString() {
            return String.format("{artifact %s:%s}", this.moduleId, this.ivyArtifactName);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ArtifactExcludeSpec other = (ArtifactExcludeSpec)o;
            return this.moduleId.equals(other.moduleId) && this.ivyArtifactName.equals(other.ivyArtifactName);
        }

        public int hashCode() {
            return this.moduleId.hashCode() ^ this.ivyArtifactName.hashCode();
        }

        protected boolean doAcceptsSameModulesAs(DefaultModuleResolutionFilter other) {
            return true;
        }

        protected boolean acceptsAllModules() {
            return true;
        }

        public boolean acceptModule(ModuleIdentifier module) {
            return true;
        }

        public boolean acceptArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
            return !this.matches(this.moduleId.getGroup(), module.getGroup()) || !this.matches(this.moduleId.getName(), module.getName()) || !this.matches(this.ivyArtifactName.getName(), artifact.getName()) || !this.matches(this.ivyArtifactName.getExtension(), artifact.getExtension()) || !this.matches(this.ivyArtifactName.getType(), artifact.getType());
        }

        public boolean acceptsAllArtifacts() {
            return false;
        }

        private boolean matches(String expression, String input) {
            return this.matcher.getMatcher(expression).matches(input);
        }
    }

    private static class ExcludeRuleSpec
    extends DefaultModuleResolutionFilter {
        private final ModuleIdentifier moduleId;
        private final IvyArtifactName ivyArtifactName;
        private final PatternMatcher matcher;
        private final boolean isArtifactExclude;

        private ExcludeRuleSpec(ExcludeRule rule) {
            this.moduleId = DefaultModuleIdentifier.newId(rule.getId().getModuleId().getOrganisation(), rule.getId().getModuleId().getName());
            this.ivyArtifactName = new DefaultIvyArtifactName(rule.getId().getName(), rule.getId().getType(), rule.getId().getExt());
            this.matcher = rule.getMatcher();
            this.isArtifactExclude = !DefaultModuleResolutionFilter.isWildcard(this.ivyArtifactName.getName()) || !DefaultModuleResolutionFilter.isWildcard(this.ivyArtifactName.getType()) || !DefaultModuleResolutionFilter.isWildcard(this.ivyArtifactName.getExtension());
        }

        public String toString() {
            return String.format("{exclude-rule %s:%s with matcher %s}", this.moduleId, this.ivyArtifactName, this.matcher.getName());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ExcludeRuleSpec other = (ExcludeRuleSpec)o;
            return this.doAcceptsSameModulesAs(other);
        }

        public int hashCode() {
            return this.moduleId.hashCode() ^ this.ivyArtifactName.hashCode();
        }

        protected boolean doAcceptsSameModulesAs(DefaultModuleResolutionFilter other) {
            ExcludeRuleSpec otherSpec = (ExcludeRuleSpec)other;
            return this.moduleId.equals(otherSpec.moduleId) && this.ivyArtifactName.equals(otherSpec.ivyArtifactName) && this.matcher.getName().equals(otherSpec.matcher.getName());
        }

        protected boolean acceptsAllModules() {
            return this.isArtifactExclude;
        }

        public boolean acceptModule(ModuleIdentifier module) {
            return this.isArtifactExclude || !this.matches(this.moduleId.getGroup(), module.getGroup()) || !this.matches(this.moduleId.getName(), module.getName());
        }

        public boolean acceptArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
            if (this.isArtifactExclude) {
                return !this.matches(this.moduleId.getGroup(), module.getGroup()) || !this.matches(this.moduleId.getName(), module.getName()) || !this.matches(this.ivyArtifactName.getName(), artifact.getName()) || !this.matches(this.ivyArtifactName.getExtension(), artifact.getExtension()) || !this.matches(this.ivyArtifactName.getType(), artifact.getType());
            }
            return true;
        }

        public boolean acceptsAllArtifacts() {
            return !this.isArtifactExclude;
        }

        private boolean matches(String expression, String input) {
            return this.matcher.getMatcher(expression).matches(input);
        }
    }

    private static class ExcludeAllModulesSpec
    extends DefaultModuleResolutionFilter {
        private ExcludeAllModulesSpec() {
        }

        public String toString() {
            return "{all modules}";
        }

        public boolean equals(Object o) {
            return o == this || o != null && o.getClass() == this.getClass();
        }

        public int hashCode() {
            return 0;
        }

        public boolean doAcceptsSameModulesAs(DefaultModuleResolutionFilter other) {
            return true;
        }

        public boolean acceptModule(ModuleIdentifier element) {
            return false;
        }

        public boolean acceptArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
            return true;
        }

        public boolean acceptsAllArtifacts() {
            return true;
        }
    }

    private static class GroupNameExcludeSpec
    extends DefaultModuleResolutionFilter {
        private final String group;

        private GroupNameExcludeSpec(String group) {
            this.group = group;
        }

        public String toString() {
            return String.format("{group %s}", this.group);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            GroupNameExcludeSpec other = (GroupNameExcludeSpec)o;
            return this.group.equals(other.group);
        }

        public int hashCode() {
            return this.group.hashCode();
        }

        public boolean doAcceptsSameModulesAs(DefaultModuleResolutionFilter other) {
            GroupNameExcludeSpec groupNameExcludeSpec = (GroupNameExcludeSpec)other;
            return this.group.equals(groupNameExcludeSpec.group);
        }

        public boolean acceptModule(ModuleIdentifier element) {
            return !element.getGroup().equals(this.group);
        }

        public boolean acceptArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
            return true;
        }

        public boolean acceptsAllArtifacts() {
            return true;
        }
    }

    private static class ModuleNameExcludeSpec
    extends DefaultModuleResolutionFilter {
        private final String module;

        private ModuleNameExcludeSpec(String module) {
            this.module = module;
        }

        public String toString() {
            return String.format("{module %s}", this.module);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ModuleNameExcludeSpec other = (ModuleNameExcludeSpec)o;
            return this.module.equals(other.module);
        }

        public int hashCode() {
            return this.module.hashCode();
        }

        public boolean doAcceptsSameModulesAs(DefaultModuleResolutionFilter other) {
            ModuleNameExcludeSpec moduleNameExcludeSpec = (ModuleNameExcludeSpec)other;
            return this.module.equals(moduleNameExcludeSpec.module);
        }

        public boolean acceptModule(ModuleIdentifier element) {
            return !element.getName().equals(this.module);
        }

        public boolean acceptArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
            return true;
        }

        public boolean acceptsAllArtifacts() {
            return true;
        }
    }

    private static class ModuleIdExcludeSpec
    extends DefaultModuleResolutionFilter {
        private final ModuleIdentifier moduleId;

        public ModuleIdExcludeSpec(String group, String name) {
            this.moduleId = DefaultModuleIdentifier.newId(group, name);
        }

        public String toString() {
            return String.format("{module-id %s}", this.moduleId);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ModuleIdExcludeSpec other = (ModuleIdExcludeSpec)o;
            return this.moduleId.equals(other.moduleId);
        }

        public int hashCode() {
            return this.moduleId.hashCode();
        }

        protected boolean doAcceptsSameModulesAs(DefaultModuleResolutionFilter other) {
            ModuleIdExcludeSpec moduleIdExcludeSpec = (ModuleIdExcludeSpec)other;
            return this.moduleId.equals(moduleIdExcludeSpec.moduleId);
        }

        public boolean acceptModule(ModuleIdentifier module) {
            return !module.equals(this.moduleId);
        }

        public boolean acceptArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
            return true;
        }

        public boolean acceptsAllArtifacts() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnionSpec
    extends CompositeSpec {
        private final List<DefaultModuleResolutionFilter> specs;

        public UnionSpec(List<DefaultModuleResolutionFilter> specs) {
            this.specs = specs;
        }

        @Override
        Collection<DefaultModuleResolutionFilter> getSpecs() {
            return this.specs;
        }

        @Override
        protected void unpackUnion(Collection<DefaultModuleResolutionFilter> specs) {
            specs.addAll(this.specs);
        }

        @Override
        protected boolean acceptsAllModules() {
            for (DefaultModuleResolutionFilter excludeSpec : this.specs) {
                if (!excludeSpec.acceptsAllModules()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean acceptModule(ModuleIdentifier element) {
            for (DefaultModuleResolutionFilter spec : this.specs) {
                if (!spec.acceptModule(element)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean acceptArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
            for (DefaultModuleResolutionFilter spec : this.specs) {
                if (!spec.acceptArtifact(module, artifact)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean acceptsAllArtifacts() {
            for (DefaultModuleResolutionFilter spec : this.specs) {
                if (!spec.acceptsAllArtifacts()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExcludeRuleBackedSpec
    extends CompositeSpec {
        private final Set<DefaultModuleResolutionFilter> excludeSpecs = new HashSet<DefaultModuleResolutionFilter>();

        private ExcludeRuleBackedSpec(Iterable<ExcludeRule> excludeRules) {
            for (ExcludeRule rule : excludeRules) {
                boolean anyArtifact;
                if (!(rule.getMatcher() instanceof ExactPatternMatcher)) {
                    this.excludeSpecs.add(new ExcludeRuleSpec(rule));
                    continue;
                }
                ArtifactId artifactId = rule.getId();
                ModuleId moduleId = artifactId.getModuleId();
                boolean anyOrganisation = DefaultModuleResolutionFilter.isWildcard(moduleId.getOrganisation());
                boolean anyModule = DefaultModuleResolutionFilter.isWildcard(moduleId.getName());
                boolean bl = anyArtifact = DefaultModuleResolutionFilter.isWildcard(artifactId.getName()) && DefaultModuleResolutionFilter.isWildcard(artifactId.getType()) && DefaultModuleResolutionFilter.isWildcard(artifactId.getExt());
                if (anyArtifact) {
                    if (!anyOrganisation && !anyModule) {
                        this.excludeSpecs.add(new ModuleIdExcludeSpec(moduleId.getOrganisation(), moduleId.getName()));
                        continue;
                    }
                    if (!anyModule) {
                        this.excludeSpecs.add(new ModuleNameExcludeSpec(moduleId.getName()));
                        continue;
                    }
                    if (!anyOrganisation) {
                        this.excludeSpecs.add(new GroupNameExcludeSpec(moduleId.getOrganisation()));
                        continue;
                    }
                    this.excludeSpecs.add(new ExcludeAllModulesSpec());
                    continue;
                }
                this.excludeSpecs.add(new ArtifactExcludeSpec(rule));
            }
        }

        public ExcludeRuleBackedSpec(Collection<DefaultModuleResolutionFilter> specs) {
            this.excludeSpecs.addAll(specs);
        }

        @Override
        Collection<DefaultModuleResolutionFilter> getSpecs() {
            return this.excludeSpecs;
        }

        @Override
        protected void unpackIntersection(Collection<DefaultModuleResolutionFilter> specs) {
            specs.addAll(this.excludeSpecs);
        }

        @Override
        protected boolean acceptsAllModules() {
            for (DefaultModuleResolutionFilter excludeSpec : this.excludeSpecs) {
                if (excludeSpec.acceptsAllModules()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean acceptModule(ModuleIdentifier element) {
            for (DefaultModuleResolutionFilter excludeSpec : this.excludeSpecs) {
                if (excludeSpec.acceptModule(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean acceptArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
            for (DefaultModuleResolutionFilter excludeSpec : this.excludeSpecs) {
                if (excludeSpec.acceptArtifact(module, artifact)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean acceptsAllArtifacts() {
            for (DefaultModuleResolutionFilter spec : this.excludeSpecs) {
                if (spec.acceptsAllArtifacts()) continue;
                return false;
            }
            return true;
        }

        @Override
        protected DefaultModuleResolutionFilter doUnion(DefaultModuleResolutionFilter other) {
            if (!(other instanceof ExcludeRuleBackedSpec)) {
                return super.doUnion(other);
            }
            ExcludeRuleBackedSpec excludeRuleBackedSpec = (ExcludeRuleBackedSpec)other;
            if (this.excludeSpecs.equals(excludeRuleBackedSpec.excludeSpecs)) {
                return this;
            }
            for (DefaultModuleResolutionFilter excludeSpec : this.excludeSpecs) {
                if (!(excludeSpec instanceof ExcludeRuleSpec)) continue;
                return super.doUnion(other);
            }
            for (DefaultModuleResolutionFilter excludeSpec : excludeRuleBackedSpec.excludeSpecs) {
                if (!(excludeSpec instanceof ExcludeRuleSpec)) continue;
                return super.doUnion(other);
            }
            ArrayList<DefaultModuleResolutionFilter> merged = new ArrayList<DefaultModuleResolutionFilter>();
            for (DefaultModuleResolutionFilter thisSpec : this.excludeSpecs) {
                for (DefaultModuleResolutionFilter otherSpec : excludeRuleBackedSpec.excludeSpecs) {
                    this.intersect(thisSpec, otherSpec, merged);
                }
            }
            if (merged.isEmpty()) {
                return ALL_SPEC;
            }
            return new ExcludeRuleBackedSpec((Collection<DefaultModuleResolutionFilter>)merged);
        }

        private void intersect(DefaultModuleResolutionFilter spec1, DefaultModuleResolutionFilter spec2, List<DefaultModuleResolutionFilter> merged) {
            if (spec1 instanceof ExcludeAllModulesSpec) {
                merged.add(spec2);
            } else if (spec2 instanceof ExcludeAllModulesSpec) {
                merged.add(spec1);
            } else if (spec1 instanceof ArtifactExcludeSpec) {
                merged.add(spec1);
            } else if (spec2 instanceof ArtifactExcludeSpec) {
                merged.add(spec2);
            } else if (spec1 instanceof GroupNameExcludeSpec) {
                this.intersect((GroupNameExcludeSpec)spec1, spec2, merged);
            } else if (spec2 instanceof GroupNameExcludeSpec) {
                this.intersect((GroupNameExcludeSpec)spec2, spec1, merged);
            } else if (spec1 instanceof ModuleNameExcludeSpec) {
                this.intersect((ModuleNameExcludeSpec)spec1, spec2, merged);
            } else if (spec2 instanceof ModuleNameExcludeSpec) {
                this.intersect((ModuleNameExcludeSpec)spec2, spec1, merged);
            } else if (spec1 instanceof ModuleIdExcludeSpec && spec2 instanceof ModuleIdExcludeSpec) {
                ModuleIdExcludeSpec moduleSpec1 = (ModuleIdExcludeSpec)spec1;
                ModuleIdExcludeSpec moduleSpec2 = (ModuleIdExcludeSpec)spec2;
                if (moduleSpec1.moduleId.equals(moduleSpec2.moduleId)) {
                    merged.add(moduleSpec1);
                }
            } else {
                throw new UnsupportedOperationException(String.format("Cannot calculate intersection of exclude rules: %s, %s", spec1, spec2));
            }
        }

        private void intersect(GroupNameExcludeSpec spec1, DefaultModuleResolutionFilter spec2, List<DefaultModuleResolutionFilter> merged) {
            if (spec2 instanceof GroupNameExcludeSpec) {
                GroupNameExcludeSpec groupNameExcludeSpec = (GroupNameExcludeSpec)spec2;
                if (spec1.group.equals(groupNameExcludeSpec.group)) {
                    merged.add(spec1);
                }
            } else if (spec2 instanceof ModuleNameExcludeSpec) {
                ModuleNameExcludeSpec moduleNameExcludeSpec = (ModuleNameExcludeSpec)spec2;
                merged.add(new ModuleIdExcludeSpec(spec1.group, moduleNameExcludeSpec.module));
            } else if (spec2 instanceof ModuleIdExcludeSpec) {
                ModuleIdExcludeSpec moduleIdExcludeSpec = (ModuleIdExcludeSpec)spec2;
                if (moduleIdExcludeSpec.moduleId.getGroup().equals(spec1.group)) {
                    merged.add(spec2);
                }
            } else {
                throw new UnsupportedOperationException(String.format("Cannot calculate intersection of exclude rules: %s, %s", spec1, spec2));
            }
        }

        private void intersect(ModuleNameExcludeSpec spec1, DefaultModuleResolutionFilter spec2, List<DefaultModuleResolutionFilter> merged) {
            if (spec2 instanceof ModuleNameExcludeSpec) {
                ModuleNameExcludeSpec moduleNameExcludeSpec = (ModuleNameExcludeSpec)spec2;
                if (spec1.module.equals(moduleNameExcludeSpec.module)) {
                    merged.add(spec1);
                }
            } else if (spec2 instanceof ModuleIdExcludeSpec) {
                ModuleIdExcludeSpec moduleIdExcludeSpec = (ModuleIdExcludeSpec)spec2;
                if (moduleIdExcludeSpec.moduleId.getName().equals(spec1.module)) {
                    merged.add(spec2);
                }
            } else {
                throw new UnsupportedOperationException(String.format("Cannot calculate intersection of exclude rules: %s, %s", spec1, spec2));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class CompositeSpec
    extends DefaultModuleResolutionFilter {
        private CompositeSpec() {
        }

        abstract Collection<DefaultModuleResolutionFilter> getSpecs();

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            builder.append(this.getClass().getSimpleName());
            for (DefaultModuleResolutionFilter spec : this.getSpecs()) {
                builder.append(' ');
                builder.append(spec);
            }
            builder.append("}");
            return builder.toString();
        }

        @Override
        protected boolean doAcceptsSameModulesAs(DefaultModuleResolutionFilter other) {
            CompositeSpec spec = (CompositeSpec)other;
            return this.implies(spec) && spec.implies(this);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            CompositeSpec other = (CompositeSpec)obj;
            return this.getSpecs().equals(other.getSpecs());
        }

        public int hashCode() {
            return this.getSpecs().hashCode();
        }

        protected boolean implies(CompositeSpec spec) {
            for (DefaultModuleResolutionFilter thisSpec : this.getSpecs()) {
                boolean found = false;
                for (DefaultModuleResolutionFilter otherSpec : spec.getSpecs()) {
                    if (!thisSpec.acceptsSameModulesAs(otherSpec)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
    }

    private static class AcceptAllSpec
    extends DefaultModuleResolutionFilter {
        private AcceptAllSpec() {
        }

        public String toString() {
            return "{accept-all}";
        }

        public boolean acceptModule(ModuleIdentifier element) {
            return true;
        }

        protected boolean acceptsAllModules() {
            return true;
        }

        public boolean acceptArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
            return true;
        }

        public boolean acceptsAllArtifacts() {
            return true;
        }
    }
}

