/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.nativeplatform.StaticLibraryBinary;
import org.gradle.nativeplatform.StaticLibraryBinarySpec;
import org.gradle.nativeplatform.internal.AbstractNativeLibraryBinarySpec;
import org.gradle.nativeplatform.internal.StaticLibraryBinarySpecInternal;
import org.gradle.nativeplatform.tasks.CreateStaticLibrary;
import org.gradle.nativeplatform.tasks.ObjectFilesToBinary;
import org.gradle.platform.base.BinaryTasksCollection;
import org.gradle.platform.base.internal.BinaryTasksCollectionWrapper;

public class DefaultStaticLibraryBinarySpec
extends AbstractNativeLibraryBinarySpec
implements StaticLibraryBinary,
StaticLibraryBinarySpecInternal {
    private final List<FileCollection> additionalLinkFiles = new ArrayList<FileCollection>();
    private final DefaultTasksCollection tasks = new DefaultTasksCollection(super.getTasks());
    private File staticLibraryFile;

    public File getStaticLibraryFile() {
        return this.staticLibraryFile;
    }

    public void setStaticLibraryFile(File staticLibraryFile) {
        this.staticLibraryFile = staticLibraryFile;
    }

    public File getPrimaryOutput() {
        return this.getStaticLibraryFile();
    }

    public void additionalLinkFiles(FileCollection files) {
        this.additionalLinkFiles.add(files);
    }

    public FileCollection getLinkFiles() {
        return new StaticLibraryLinkOutputs();
    }

    public FileCollection getRuntimeFiles() {
        return new SimpleFileCollection(new File[0]);
    }

    protected ObjectFilesToBinary getCreateOrLink() {
        return this.tasks.getCreateStaticLib();
    }

    public StaticLibraryBinarySpec.TasksCollection getTasks() {
        return this.tasks;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StaticLibraryLinkOutputs
    extends AbstractNativeLibraryBinarySpec.LibraryOutputs {
        private StaticLibraryLinkOutputs() {
        }

        @Override
        protected boolean hasOutputs() {
            return DefaultStaticLibraryBinarySpec.this.hasSources() || !DefaultStaticLibraryBinarySpec.this.additionalLinkFiles.isEmpty();
        }

        @Override
        protected Set<File> getOutputs() {
            LinkedHashSet<File> allFiles = new LinkedHashSet<File>();
            if (DefaultStaticLibraryBinarySpec.this.hasSources()) {
                allFiles.add(DefaultStaticLibraryBinarySpec.this.getStaticLibraryFile());
            }
            for (FileCollection resourceSet : DefaultStaticLibraryBinarySpec.this.additionalLinkFiles) {
                allFiles.addAll(resourceSet.getFiles());
            }
            return allFiles;
        }
    }

    private static class DefaultTasksCollection
    extends BinaryTasksCollectionWrapper
    implements StaticLibraryBinarySpec.TasksCollection {
        public DefaultTasksCollection(BinaryTasksCollection delegate) {
            super(delegate);
        }

        public CreateStaticLibrary getCreateStaticLib() {
            return (CreateStaticLibrary)this.findSingleTaskWithType(CreateStaticLibrary.class);
        }
    }
}

