/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.configuration;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Properties;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.jvm.Jvm;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.process.internal.JvmOptions;

public class CurrentProcess {
    private final JavaInfo jvm;
    private final JvmOptions effectiveJvmOptions;

    public CurrentProcess() {
        this(Jvm.current(), CurrentProcess.inferJvmOptions());
    }

    CurrentProcess(JavaInfo jvm, JvmOptions effectiveJvmOptions) {
        this.jvm = jvm;
        this.effectiveJvmOptions = effectiveJvmOptions;
    }

    public JvmOptions getJvmOptions() {
        return this.effectiveJvmOptions;
    }

    public boolean configureForBuild(DaemonParameters requiredBuildParameters) {
        boolean javaHomeMatch = this.jvm.equals(requiredBuildParameters.getEffectiveJvm());
        List<String> currentImmutable = new JvmOptions(new IdentityFileResolver()).getAllImmutableJvmArgs();
        List<String> requiredImmutable = requiredBuildParameters.getEffectiveJvmArgs();
        requiredImmutable.removeAll(DaemonParameters.DEFAULT_JVM_ARGS);
        boolean noImmutableJvmArgsRequired = requiredImmutable.equals(currentImmutable);
        if (javaHomeMatch && noImmutableJvmArgsRequired) {
            Properties properties = new Properties();
            properties.putAll(requiredBuildParameters.getEffectiveSystemProperties());
            System.setProperties(properties);
            return true;
        }
        return false;
    }

    private static JvmOptions inferJvmOptions() {
        JvmOptions jvmOptions = new JvmOptions(new IdentityFileResolver());
        jvmOptions.setAllJvmArgs(ManagementFactory.getRuntimeMXBean().getInputArguments());
        return jvmOptions;
    }
}

