/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;

public class BuildAndRestartConsoleAction
extends AnAction {
    private Module myModule;
    private Project myProject;
    private Executor myExecutor;
    private RunContentDescriptor myContentDescriptor;
    private Consumer<Module> myRestarter;

    public BuildAndRestartConsoleAction(@NotNull Module module, @NotNull Project project, @NotNull Executor executor, @NotNull RunContentDescriptor contentDescriptor, @NotNull Consumer<Module> restarter) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/console/BuildAndRestartConsoleAction", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/console/BuildAndRestartConsoleAction", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/groovy/console/BuildAndRestartConsoleAction", "<init>"));
        }
        if (contentDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentDescriptor", "org/jetbrains/plugins/groovy/console/BuildAndRestartConsoleAction", "<init>"));
        }
        if (restarter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restarter", "org/jetbrains/plugins/groovy/console/BuildAndRestartConsoleAction", "<init>"));
        }
        super("Build and restart", "Build module '" + module.getName() + "' and restart", AllIcons.Actions.Restart);
        this.myModule = module;
        this.myProject = project;
        this.myExecutor = executor;
        this.myContentDescriptor = contentDescriptor;
        this.myRestarter = restarter;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(this.isEnabled());
    }

    private boolean isEnabled() {
        if (this.myModule == null || this.myModule.isDisposed()) {
            return false;
        }
        ProcessHandler processHandler = this.myContentDescriptor.getProcessHandler();
        return processHandler != null && !processHandler.isProcessTerminated();
    }

    public void actionPerformed(AnActionEvent e) {
        if (ExecutionManager.getInstance((Project)this.myProject).getContentManager().removeRunContent(this.myExecutor, this.myContentDescriptor)) {
            CompilerManager.getInstance((Project)this.myProject).compile(this.myModule, new CompileStatusNotification(){

                public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                    if (!BuildAndRestartConsoleAction.this.myModule.isDisposed()) {
                        BuildAndRestartConsoleAction.this.myRestarter.consume((Object)BuildAndRestartConsoleAction.this.myModule);
                    }
                }
            });
        }
    }
}

