/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.util.Processor;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;

public class LiteralConstructorSearcher {
    private final PsiMethod myConstructor;
    private final Processor<PsiReference> myConsumer;
    private final boolean myIncludeOverloads;

    public LiteralConstructorSearcher(PsiMethod constructor, Processor<PsiReference> consumer, boolean includeOverloads) {
        this.myConstructor = constructor;
        this.myConsumer = consumer;
        this.myIncludeOverloads = includeOverloads;
    }

    public boolean processLiteral(GrListOrMap literal) {
        PsiReference reference = literal.getReference();
        return !(reference instanceof LiteralConstructorReference) || !this.isCorrectReference((LiteralConstructorReference)reference) || this.myConsumer.process((Object)reference);
    }

    private boolean isCorrectReference(LiteralConstructorReference reference) {
        if (reference.isReferenceTo((PsiElement)this.myConstructor)) {
            return true;
        }
        if (!this.myIncludeOverloads) {
            return false;
        }
        PsiClassType constructedClassType = reference.getConstructedClassType();
        if (constructedClassType == null) {
            return false;
        }
        PsiClass psiClass = constructedClassType.resolve();
        return this.myConstructor.getManager().areElementsEquivalent((PsiElement)this.myConstructor.getContainingClass(), (PsiElement)psiClass);
    }
}

