/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.parameter.java2groovy;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class FieldConflictsResolver {
    private final GrCodeBlock myScope;
    private final PsiField myField;
    private final List<GrReferenceExpression> myReferenceExpressions;
    private PsiClass myQualifyingClass;

    public FieldConflictsResolver(String name, GrCodeBlock scope) {
        this.myScope = scope;
        if (this.myScope == null) {
            this.myField = null;
            this.myReferenceExpressions = null;
            return;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myScope.getProject());
        PsiVariable oldVariable = facade.getResolveHelper().resolveAccessibleReferencedVariable(name, (PsiElement)this.myScope);
        PsiField psiField = this.myField = oldVariable instanceof PsiField ? (PsiField)oldVariable : null;
        if (!(oldVariable instanceof PsiField)) {
            this.myReferenceExpressions = null;
            return;
        }
        this.myReferenceExpressions = new ArrayList<GrReferenceExpression>();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)this.myField, (SearchScope)new LocalSearchScope((PsiElement)this.myScope), (boolean)false)) {
            GrReferenceExpression referenceExpression;
            PsiElement element = reference.getElement();
            if (!(element instanceof GrReferenceExpression) || (referenceExpression = (GrReferenceExpression)element).getQualifierExpression() != null) continue;
            this.myReferenceExpressions.add(referenceExpression);
        }
        if (this.myField.hasModifierProperty("static")) {
            this.myQualifyingClass = this.myField.getContainingClass();
        }
    }

    public void fix() throws IncorrectOperationException {
        if (this.myField == null) {
            return;
        }
        PsiManager manager = this.myScope.getManager();
        for (GrReferenceExpression referenceExpression : this.myReferenceExpressions) {
            PsiElement newlyResolved;
            if (!referenceExpression.isValid() || manager.areElementsEquivalent(newlyResolved = referenceExpression.resolve(), (PsiElement)this.myField)) continue;
            FieldConflictsResolver.qualifyReference(referenceExpression, (PsiMember)this.myField, this.myQualifyingClass);
        }
    }

    public static GrReferenceExpression qualifyReference(GrReferenceExpression referenceExpression, PsiMember member, @Nullable PsiClass qualifyingClass) throws IncorrectOperationException {
        GrReferenceExpression expressionFromText;
        PsiManager manager = referenceExpression.getManager();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(manager.getProject());
        if (qualifyingClass == null) {
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiClass.class);
            PsiClass containingClass = member.getContainingClass();
            expressionFromText = parentClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)containingClass, (boolean)true) ? (GrReferenceExpression)factory.createExpressionFromText(containingClass.getQualifiedName() + ".this." + member.getName()) : (GrReferenceExpression)factory.createExpressionFromText("this." + member.getName());
        } else {
            expressionFromText = (GrReferenceExpression)factory.createExpressionFromText(qualifyingClass.getQualifiedName() + '.' + member.getName());
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
        expressionFromText = (GrReferenceExpression)codeStyleManager.reformat((PsiElement)expressionFromText);
        return (GrReferenceExpression)referenceExpression.replace(expressionFromText);
    }
}

