/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.lang.properties.editor.PropertiesGroupingStructureViewModel;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.lang.properties.structureView.GroupByWordPrefixes;
import com.intellij.lang.properties.structureView.PropertiesFileStructureViewElement;
import com.intellij.lang.properties.structureView.PropertiesPrefixGroup;
import com.intellij.lang.properties.structureView.PropertiesSeparatorManager;
import com.intellij.psi.PsiFile;
import java.util.Comparator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PropertiesFileStructureViewModel
extends TextEditorBasedStructureViewModel
implements PropertiesGroupingStructureViewModel {
    private final PropertiesFileImpl myPropertiesFile;
    private final GroupByWordPrefixes myByWordPrefixesGrouper;
    @NonNls
    public static final String KIND_SORTER_ID = "KIND_SORTER";
    private static final Sorter KIND_SORTER = new Sorter(){

        @NotNull
        public Comparator getComparator() {
            Comparator comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    int weight1 = o1 instanceof PropertiesPrefixGroup ? 1 : 0;
                    int weight2 = o2 instanceof PropertiesPrefixGroup ? 1 : 0;
                    return weight1 - weight2;
                }
            };
            if (comparator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/structureView/PropertiesFileStructureViewModel$1", "getComparator"));
            }
            return comparator;
        }

        public boolean isVisible() {
            return true;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            String name = IdeBundle.message((String)"action.sort.by.type", (Object[])new Object[0]);
            ActionPresentationData actionPresentationData = new ActionPresentationData(name, name, AllIcons.ObjectBrowser.SortByType);
            if (actionPresentationData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/structureView/PropertiesFileStructureViewModel$1", "getPresentation"));
            }
            return actionPresentationData;
        }

        @NotNull
        public String getName() {
            if (PropertiesFileStructureViewModel.KIND_SORTER_ID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/structureView/PropertiesFileStructureViewModel$1", "getName"));
            }
            return PropertiesFileStructureViewModel.KIND_SORTER_ID;
        }
    };

    public PropertiesFileStructureViewModel(PropertiesFileImpl root) {
        super((PsiFile)root);
        this.myPropertiesFile = root;
        String separator = PropertiesSeparatorManager.getInstance(root.getProject()).getSeparator(root.getResourceBundle());
        this.myByWordPrefixesGrouper = new GroupByWordPrefixes(separator);
    }

    @Override
    public void setSeparator(String separator) {
        this.myByWordPrefixesGrouper.setSeparator(separator);
        PropertiesSeparatorManager.getInstance(this.myPropertiesFile.getProject()).setSeparator(this.myPropertiesFile.getResourceBundle(), separator);
    }

    @Override
    public String getSeparator() {
        return this.myByWordPrefixesGrouper.getSeparator();
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        PropertiesFileStructureViewElement propertiesFileStructureViewElement = new PropertiesFileStructureViewElement(this.myPropertiesFile);
        if (propertiesFileStructureViewElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/structureView/PropertiesFileStructureViewModel", "getRoot"));
        }
        return propertiesFileStructureViewElement;
    }

    @NotNull
    public Grouper[] getGroupers() {
        Grouper[] grouperArray = new Grouper[]{this.myByWordPrefixesGrouper};
        if (grouperArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/structureView/PropertiesFileStructureViewModel", "getGroupers"));
        }
        return grouperArray;
    }

    @NotNull
    public Sorter[] getSorters() {
        Sorter[] sorterArray = new Sorter[]{Sorter.ALPHA_SORTER, KIND_SORTER};
        if (sorterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/structureView/PropertiesFileStructureViewModel", "getSorters"));
        }
        return sorterArray;
    }

    protected PsiFile getPsiFile() {
        return this.myPropertiesFile;
    }

    @NotNull
    protected Class[] getSuitableClasses() {
        Class[] classArray = new Class[]{Property.class};
        if (classArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/structureView/PropertiesFileStructureViewModel", "getSuitableClasses"));
        }
        return classArray;
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        return false;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        return false;
    }
}

