/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubCommit;
import org.jetbrains.plugins.github.api.GithubCommitSha;
import org.jetbrains.plugins.github.api.GithubFile;
import org.jetbrains.plugins.github.api.GithubUser;

public class GithubCommitDetailed
extends GithubCommit {
    @NotNull
    private final CommitStats myStats;
    @NotNull
    private final List<GithubFile> myFiles;

    public GithubCommitDetailed(@NotNull String url, @NotNull String sha, @Nullable GithubUser author, @Nullable GithubUser committer, @NotNull List<GithubCommitSha> parents, @NotNull GithubCommit.GitCommit commit, @NotNull CommitStats stats, @NotNull List<GithubFile> files) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/plugins/github/api/GithubCommitDetailed", "<init>"));
        }
        if (sha == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sha", "org/jetbrains/plugins/github/api/GithubCommitDetailed", "<init>"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "org/jetbrains/plugins/github/api/GithubCommitDetailed", "<init>"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "org/jetbrains/plugins/github/api/GithubCommitDetailed", "<init>"));
        }
        if (stats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stats", "org/jetbrains/plugins/github/api/GithubCommitDetailed", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/plugins/github/api/GithubCommitDetailed", "<init>"));
        }
        super(url, sha, author, committer, parents, commit);
        this.myStats = stats;
        this.myFiles = files;
    }

    @NotNull
    public CommitStats getStats() {
        CommitStats commitStats = this.myStats;
        if (commitStats == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommitDetailed", "getStats"));
        }
        return commitStats;
    }

    @NotNull
    public List<GithubFile> getFiles() {
        List<GithubFile> list = this.myFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommitDetailed", "getFiles"));
        }
        return list;
    }

    public static class CommitStats {
        private final int myAdditions;
        private final int myDeletions;
        private final int myTotal;

        public CommitStats(int additions, int deletions, int total) {
            this.myAdditions = additions;
            this.myDeletions = deletions;
            this.myTotal = total;
        }

        public int getAdditions() {
            return this.myAdditions;
        }

        public int getDeletions() {
            return this.myDeletions;
        }

        public int getTotal() {
            return this.myTotal;
        }
    }
}

