/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.flavours.commonmark.CommonMarkMarkerProcessor;
import org.intellij.markdown.flavours.gfm.GFMConstraints;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.flavours.gfm.table.GitHubTableMarkerProvider;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.MarkerProcessorFactory;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t!\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tA\u0002A\r\u00021\u0003i\n!CQ\u000b\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000b\t6!\u0001\u0005\u0004K)!!\u0002c\u0003\u000e\u000f%)\u0011\u0002B\u0005\u0003\u0013\u0005AR\u0001'\u0003\u0019\t\u0015\u0012BA\u0003\u0005\u0007\u001b\u0005Aj!G\u0003\t\u000f5\u0019\u0001tB\u0015\u00021!I2\u0001#\u0005\u000e\u0003a\u0015\u0011d\u0001\u0005\u0002\u001b\u0005A\u001a!K\u0007\u0005\u0003\"A9!D\u0004\n\u000b%!\u0011BA\u0005\u00021\u0015AJ\u0001\u0007\u0003R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/intellij/markdown/flavours/gfm/GFMMarkerProcessor;", "Lorg/intellij/markdown/flavours/commonmark/CommonMarkMarkerProcessor;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "constraintsBase", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "(Lorg/intellij/markdown/parser/ProductionHolder;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;)V", "markerBlockProviders", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "getMarkerBlockProviders", "populateConstraintsTokens", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "constraints", "Factory"}, moduleName="intellij-markdown")
public final class GFMMarkerProcessor
extends CommonMarkMarkerProcessor {
    private final List<? extends MarkerBlockProvider<MarkerProcessor.StateInfo>> markerBlockProviders;

    @Override
    @NotNull
    protected List<MarkerBlockProvider<MarkerProcessor.StateInfo>> getMarkerBlockProviders() {
        return this.markerBlockProviders;
    }

    @Override
    protected void populateConstraintsTokens(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints, @NotNull ProductionHolder productionHolder) {
        int offset;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        if (!(constraints instanceof GFMConstraints) || !((GFMConstraints)constraints).hasCheckbox()) {
            super.populateConstraintsTokens(pos, constraints, productionHolder);
            return;
        }
        String line = pos.getCurrentLine();
        for (offset = pos.getOffsetInCurrentLine(); offset < line.length() && line.charAt(offset) != '['; ++offset) {
        }
        if (offset == line.length()) {
            super.populateConstraintsTokens(pos, constraints, productionHolder);
            return;
        }
        Character c = ((GFMConstraints)constraints).getLastType();
        IElementType type = Intrinsics.areEqual((Object)c, (Object)Character.valueOf('>')) ? MarkdownTokenTypes.Companion.getBLOCK_QUOTE() : (Intrinsics.areEqual((Object)c, (Object)Character.valueOf('.')) || Intrinsics.areEqual((Object)c, (Object)Character.valueOf(')')) ? MarkdownTokenTypes.Companion.getLIST_NUMBER() : MarkdownTokenTypes.Companion.getLIST_BULLET());
        int middleOffset = pos.getOffset() - pos.getOffsetInCurrentLine() + offset;
        int endOffset = Math.min(pos.getOffset() - pos.getOffsetInCurrentLine() + ((GFMConstraints)constraints).getCharsEaten(pos.getCurrentLine()), pos.getNextLineOrEofOffset());
        productionHolder.addProduction(CollectionsKt.listOf((Object[])new SequentialParser.Node[]{new SequentialParser.Node(new IntRange(pos.getOffset(), middleOffset), type), new SequentialParser.Node(new IntRange(middleOffset, endOffset), GFMTokenTypes.INSTANCE.getCHECK_BOX())}));
    }

    public GFMMarkerProcessor(@NotNull ProductionHolder productionHolder, @NotNull MarkdownConstraints constraintsBase) {
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)constraintsBase, (String)"constraintsBase");
        super(productionHolder, constraintsBase);
        this.markerBlockProviders = CollectionsKt.plus((Collection)super.getMarkerBlockProviders(), (Iterable)CollectionsKt.listOf((Object)new GitHubTableMarkerProvider()));
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0017\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005!1-\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u0015\u0011Y\u00012A\u0007\u0004\u0013\u0005!\u0019\u0001\u0007\u0002\u001a\u0007!\u0015Q\"\u0001\r\u0004"}, strings={"Lorg/intellij/markdown/flavours/gfm/GFMMarkerProcessor$Factory;", "Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "()V", "createMarkerProcessor", "Lorg/intellij/markdown/parser/MarkerProcessor;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;"}, moduleName="intellij-markdown")
    public static final class Factory
    implements MarkerProcessorFactory {
        public static final Factory INSTANCE;
        public static final Factory INSTANCE$;

        @Override
        @NotNull
        public MarkerProcessor<?> createMarkerProcessor(@NotNull ProductionHolder productionHolder) {
            Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
            return new GFMMarkerProcessor(productionHolder, GFMConstraints.Companion.getBASE());
        }

        static {
            new Factory();
        }

        private Factory() {
            INSTANCE = this;
            INSTANCE$ = this;
        }
    }
}

