/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.TypeChooser;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TypeChooserManager {
    private final Map<Type, TypeChooser> myClassChoosers = new ConcurrentHashMap<Type, TypeChooser>();

    public TypeChooser getTypeChooser(final Type type) {
        TypeChooser typeChooser = this.myClassChoosers.get(type);
        return typeChooser != null ? typeChooser : new TypeChooser(){

            @Override
            public Type chooseType(XmlTag tag) {
                return type;
            }

            @Override
            public void distinguishTag(XmlTag tag, Type aClass) {
            }

            @Override
            public Type[] getChooserTypes() {
                return new Type[]{type};
            }
        };
    }

    public void registerTypeChooser(Type aClass, TypeChooser typeChooser) {
        this.myClassChoosers.put(aClass, typeChooser);
    }

    public void unregisterTypeChooser(Type aClass) {
        this.myClassChoosers.remove(aClass);
    }

    public final void copyFrom(TypeChooserManager manager) {
        this.myClassChoosers.putAll(manager.myClassChoosers);
    }
}

