/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.browse;

import com.intellij.util.ObjectUtils;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseNodeDescription;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNURL;

public class DirectoryEntry
extends BaseNodeDescription
implements Comparable<DirectoryEntry> {
    private final String myName;
    @NotNull
    private final CommitInfo myCommitInfo;
    private final String myPath;
    private final SVNURL myUrl;
    private final SVNURL myRepositoryRoot;

    @NotNull
    public static DirectoryEntry create(@NotNull SVNDirEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/idea/svn/browse/DirectoryEntry", "create"));
        }
        DirectoryEntry directoryEntry = new DirectoryEntry(entry.getURL(), entry.getRepositoryRoot(), entry.getName(), NodeKind.from(entry.getKind()), new CommitInfo.Builder(entry.getRevision(), entry.getDate(), entry.getAuthor()).build(), entry.getRelativePath());
        if (directoryEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/browse/DirectoryEntry", "create"));
        }
        return directoryEntry;
    }

    public DirectoryEntry(SVNURL url, SVNURL repositoryRoot, String name, @NotNull NodeKind kind, @Nullable CommitInfo commitInfo, String path) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/idea/svn/browse/DirectoryEntry", "<init>"));
        }
        super(kind);
        this.myUrl = url;
        this.myRepositoryRoot = repositoryRoot;
        this.myName = name;
        this.myCommitInfo = (CommitInfo)ObjectUtils.notNull((Object)commitInfo, (Object)CommitInfo.EMPTY);
        this.myPath = path;
    }

    public SVNURL getUrl() {
        return this.myUrl;
    }

    public SVNURL getRepositoryRoot() {
        return this.myRepositoryRoot;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public NodeKind getKind() {
        NodeKind nodeKind = this.myKind;
        if (nodeKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/browse/DirectoryEntry", "getKind"));
        }
        return nodeKind;
    }

    public Date getDate() {
        return this.myCommitInfo.getDate();
    }

    public long getRevision() {
        return this.myCommitInfo.getRevision();
    }

    public String getAuthor() {
        return this.myCommitInfo.getAuthor();
    }

    public String getRelativePath() {
        return this.myPath == null ? this.myName : this.myPath;
    }

    @Override
    public int compareTo(@NotNull DirectoryEntry o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/idea/svn/browse/DirectoryEntry", "compareTo"));
        }
        int result = this.getKind().compareTo(o.getKind());
        return result != 0 ? result : this.myUrl.toString().compareTo(o.getUrl().toString());
    }
}

