/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactState;

public class MavenArtifactNode
implements Serializable {
    private final MavenArtifactNode myParent;
    private final MavenArtifact myArtifact;
    private final MavenArtifactState myState;
    private final MavenArtifact myRelatedArtifact;
    private final String myOriginalScope;
    private final String myPremanagedVersion;
    private final String myPremanagedScope;
    private List<MavenArtifactNode> myDependencies;

    public MavenArtifactNode(MavenArtifactNode parent, MavenArtifact artifact, MavenArtifactState state, MavenArtifact relatedArtifact, String originalScope, String premanagedVersion, String premanagedScope) {
        this.myParent = parent;
        this.myArtifact = artifact;
        this.myState = state;
        this.myRelatedArtifact = relatedArtifact;
        this.myOriginalScope = originalScope;
        this.myPremanagedVersion = premanagedVersion;
        this.myPremanagedScope = premanagedScope;
    }

    @Nullable
    public MavenArtifactNode getParent() {
        return this.myParent;
    }

    public MavenArtifact getArtifact() {
        return this.myArtifact;
    }

    public MavenArtifactState getState() {
        return this.myState;
    }

    @Nullable
    public MavenArtifact getRelatedArtifact() {
        return this.myRelatedArtifact;
    }

    @Nullable
    public String getOriginalScope() {
        return this.myOriginalScope;
    }

    @Nullable
    public String getPremanagedVersion() {
        return this.myPremanagedVersion;
    }

    @Nullable
    public String getPremanagedScope() {
        return this.myPremanagedScope;
    }

    public List<MavenArtifactNode> getDependencies() {
        return this.myDependencies;
    }

    public void setDependencies(List<MavenArtifactNode> dependencies) {
        this.myDependencies = dependencies;
    }

    public String toString() {
        String result = this.myArtifact.getDisplayStringWithTypeAndClassifier();
        if (this.myState != MavenArtifactState.ADDED) {
            result = result + "[" + (Object)((Object)this.myState) + ":" + this.myRelatedArtifact.getDisplayStringWithTypeAndClassifier() + "]";
        }
        result = result + "->(" + MavenArtifactNode.formatNodesList(this.myDependencies) + ")";
        return result;
    }

    public static String formatNodesList(List<MavenArtifactNode> nodes) {
        return StringUtil.join(nodes, (Function)StringUtil.createToStringFunction(MavenArtifactNode.class), (String)",");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenArtifactNode that = (MavenArtifactNode)o;
        return this.myArtifact.equals(that.myArtifact);
    }

    public int hashCode() {
        return this.myArtifact.hashCode();
    }
}

