/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.lint.checks.Api;
import com.android.tools.lint.checks.ApiClass;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.primitives.UnsignedBytes;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApiLookup {
    private static final String XML_FILE_PATH = "platform-tools/api/api-versions.xml";
    private static final String FILE_HEADER = "API database used by Android lint\u0000";
    private static final int BINARY_FORMAT_VERSION = 6;
    private static final boolean DEBUG_FORCE_REGENERATE_BINARY = false;
    private static final boolean DEBUG_SEARCH = false;
    private static final boolean WRITE_STATS = false;
    private static final int BYTES_PER_ENTRY = 36;
    private final Api mInfo;
    private byte[] mData;
    private int[] mIndices;
    private int mClassCount;
    private String[] mJavaPackages;
    private static WeakReference<ApiLookup> sInstance = new WeakReference<Object>(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ApiLookup get(@NonNull LintClient client) {
        Class<ApiLookup> clazz = ApiLookup.class;
        synchronized (ApiLookup.class) {
            ApiLookup db = (ApiLookup)sInstance.get();
            if (db == null) {
                String build;
                File file = client.findResource(XML_FILE_PATH);
                if (file == null && (build = System.getenv("ANDROID_BUILD_TOP")) != null) {
                    file = new File(build, "development/sdk/api-versions.xml".replace('/', File.separatorChar));
                }
                if (file == null || !file.exists()) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
                db = ApiLookup.get(client, file);
                sInstance = new WeakReference<ApiLookup>(db);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return db;
        }
    }

    @Nullable
    static String getPlatformVersion(@NonNull LintClient client) {
        FullRevision version;
        LocalPkgInfo pkgInfo;
        LocalSdk sdk = client.getSdk();
        if (sdk != null && (pkgInfo = sdk.getPkgInfo(PkgType.PKG_PLATFORM_TOOLS)) != null && (version = pkgInfo.getDesc().getFullRevision()) != null) {
            return version.toShortString();
        }
        return null;
    }

    @NonNull
    static String getCacheFileName(@NonNull String xmlFileName, @Nullable String platformVersion) {
        if (LintUtils.endsWith(xmlFileName, ".xml")) {
            xmlFileName = xmlFileName.substring(0, xmlFileName.length() - ".xml".length());
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append(xmlFileName);
        sb.append('-').append(6);
        if (platformVersion != null) {
            sb.append('-').append(platformVersion);
        }
        sb.append(".bin");
        return sb.toString();
    }

    private static ApiLookup get(LintClient client, File xmlFile) {
        if (!xmlFile.exists()) {
            client.log(null, "The API database file %1$s does not exist", xmlFile);
            return null;
        }
        File cacheDir = client.getCacheDir(true);
        if (cacheDir == null) {
            cacheDir = xmlFile.getParentFile();
        }
        String platformVersion = ApiLookup.getPlatformVersion(client);
        File binaryData = new File(cacheDir, ApiLookup.getCacheFileName(xmlFile.getName(), platformVersion));
        if (!(binaryData.exists() && binaryData.lastModified() >= xmlFile.lastModified() && binaryData.length() != 0L || ApiLookup.createCache(client, xmlFile, binaryData))) {
            return null;
        }
        if (!binaryData.exists()) {
            client.log(null, "The API database file %1$s does not exist", binaryData);
            return null;
        }
        return new ApiLookup(client, xmlFile, binaryData, null);
    }

    private static boolean createCache(LintClient client, File xmlFile, File binaryData) {
        long begin = 0L;
        Api info = Api.parseApi(xmlFile);
        if (info != null) {
            try {
                ApiLookup.writeDatabase(binaryData, info);
                return true;
            }
            catch (IOException ioe) {
                client.log(ioe, "Can't write API cache file", new Object[0]);
            }
        }
        return false;
    }

    private ApiLookup(@NonNull LintClient client, @NonNull File xmlFile, @Nullable File binaryFile, @Nullable Api info) {
        this.mInfo = info;
        if (binaryFile != null) {
            this.readData(client, xmlFile, binaryFile);
        }
    }

    private void readData(@NonNull LintClient client, @NonNull File xmlFile, @NonNull File binaryFile) {
        if (!binaryFile.exists()) {
            client.log(null, "%1$s does not exist", binaryFile);
            return;
        }
        long start = System.currentTimeMillis();
        try {
            MappedByteBuffer buffer = Files.map((File)binaryFile, (FileChannel.MapMode)FileChannel.MapMode.READ_ONLY);
            assert (buffer.order() == ByteOrder.BIG_ENDIAN);
            byte[] expectedHeader = FILE_HEADER.getBytes(Charsets.US_ASCII);
            buffer.rewind();
            for (int offset = 0; offset < expectedHeader.length; ++offset) {
                if (expectedHeader[offset] == buffer.get()) continue;
                client.log(null, "Incorrect file header: not an API database cache file, or a corrupt cache file", new Object[0]);
                return;
            }
            if (buffer.get() != 6) {
                if (ApiLookup.createCache(client, xmlFile, binaryFile)) {
                    this.readData(client, xmlFile, binaryFile);
                }
                return;
            }
            this.mClassCount = buffer.getInt();
            int methodCount = buffer.getInt();
            int javaPackageCount = buffer.getInt();
            this.mJavaPackages = new String[javaPackageCount];
            for (int i = 0; i < javaPackageCount; ++i) {
                int count = UnsignedBytes.toInt((byte)buffer.get());
                byte[] bytes = new byte[count];
                buffer.get(bytes, 0, count);
                this.mJavaPackages[i] = new String(bytes, Charsets.UTF_8);
            }
            int count = this.mClassCount + methodCount;
            int[] offsets = new int[count];
            for (int i = 0; i < count; ++i) {
                offsets[i] = buffer.getInt();
            }
            int size = buffer.limit();
            byte[] b = new byte[size];
            buffer.rewind();
            buffer.get(b);
            this.mData = b;
            this.mIndices = offsets;
        }
        catch (Throwable e) {
            client.log(null, "Failure reading binary cache file %1$s", binaryFile.getPath());
            client.log(null, "Please delete the file and restart the IDE/lint: %1$s", binaryFile.getPath());
            client.log(e, null, new Object[0]);
        }
    }

    private static void writeDatabase(File file, Api info) throws IOException {
        Map<String, ApiClass> classMap = info.getClasses();
        ArrayList<String> classes = new ArrayList<String>(classMap.size());
        HashMap memberMap = Maps.newHashMapWithExpectedSize((int)classMap.size());
        int memberCount = 0;
        HashSet javaPackageSet = Sets.newHashSetWithExpectedSize((int)70);
        for (Map.Entry<String, ApiClass> entry : classMap.entrySet()) {
            Object since;
            String className = entry.getKey();
            ApiClass apiClass = entry.getValue();
            if (className.startsWith("java/") || className.startsWith("javax/")) {
                String pkg = apiClass.getPackage();
                javaPackageSet.add(pkg);
            }
            if (!ApiLookup.isRelevantOwner(className)) {
                System.out.println("Warning: The isRelevantOwner method does not pass " + className);
            }
            Set<String> allMethods = apiClass.getAllMethods(info);
            Set<String> allFields = apiClass.getAllFields(info);
            ArrayList<String> members = new ArrayList<String>(allMethods.size() + allFields.size());
            for (String member : allMethods) {
                since = apiClass.getMethod(member, info);
                if (since == null) {
                    assert (false) : className + ':' + member;
                    since = 1;
                }
                if ((Integer)since == 1) continue;
                members.add(member);
            }
            Iterator<String> iterator = allFields.iterator();
            while (iterator.hasNext()) {
                String member;
                member = iterator.next();
                since = apiClass.getField(member, info);
                if (since == null) {
                    assert (false) : className + ':' + member;
                    since = 1;
                }
                if ((Integer)since == 1) continue;
                members.add(member);
            }
            if (members.isEmpty()) continue;
            classes.add(className);
            memberMap.put(apiClass, members);
            memberCount += members.size();
        }
        Collections.sort(classes);
        ArrayList javaPackages = Lists.newArrayList((Iterable)javaPackageSet);
        Collections.sort(javaPackages);
        int javaPackageCount = javaPackages.size();
        int entryCount = classMap.size() + memberCount;
        int capacity = entryCount * 36;
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.put(FILE_HEADER.getBytes(Charsets.US_ASCII));
        buffer.put((byte)6);
        buffer.putInt(classes.size());
        buffer.putInt(memberCount);
        buffer.putInt(javaPackageCount);
        for (String pkg : javaPackages) {
            byte[] bytes = pkg.getBytes(Charsets.UTF_8);
            assert (bytes.length < 255) : pkg;
            buffer.put((byte)bytes.length);
            buffer.put(bytes);
        }
        int classOffsetTable = buffer.position();
        int n = classes.size();
        for (int i = 0; i < n; ++i) {
            buffer.putInt(0);
        }
        int methodOffsetTable = buffer.position();
        int n2 = memberCount;
        for (int i = 0; i < n2; ++i) {
            buffer.putInt(0);
        }
        int nextEntry = buffer.position();
        int nextOffset = classOffsetTable;
        for (String clz : classes) {
            buffer.position(nextOffset);
            buffer.putInt(nextEntry);
            nextOffset = buffer.position();
            buffer.position(nextEntry);
            buffer.put(clz.getBytes(Charsets.UTF_8));
            buffer.put((byte)0);
            ApiClass apiClass = classMap.get(clz);
            assert (apiClass != null) : clz;
            int since = apiClass.getSince();
            assert (since == UnsignedBytes.toInt((byte)((byte)since))) : since;
            buffer.put((byte)since);
            nextEntry = buffer.position();
        }
        assert (nextOffset == methodOffsetTable);
        int n3 = classes.size();
        for (int classNumber = 0; classNumber < n3; ++classNumber) {
            String clz = (String)classes.get(classNumber);
            ApiClass apiClass = classMap.get(clz);
            assert (apiClass != null) : clz;
            List members = (List)memberMap.get(apiClass);
            Collections.sort(members);
            for (String member : members) {
                buffer.position(nextOffset);
                buffer.putInt(nextEntry);
                nextOffset = buffer.position();
                buffer.position(nextEntry);
                Integer since = member.indexOf(40) != -1 ? Integer.valueOf(apiClass.getMethod(member, info)) : apiClass.getField(member, info);
                if (since == null) {
                    assert (false) : clz + ':' + member;
                    since = 1;
                }
                assert (classNumber == (short)classNumber);
                buffer.putShort((short)classNumber);
                byte[] signature = member.getBytes(Charsets.UTF_8);
                for (int i = 0; i < signature.length; ++i) {
                    byte b = signature[i];
                    assert (b == (b & 0x7F)) : member;
                    buffer.put(b);
                    if (b == 41) break;
                }
                buffer.put((byte)0);
                int api = since;
                assert (api == UnsignedBytes.toInt((byte)((byte)api)));
                buffer.put((byte)api);
                nextEntry = buffer.position();
            }
        }
        int size = buffer.position();
        assert (size <= buffer.limit());
        buffer.mark();
        byte[] b = new byte[size];
        buffer.rewind();
        buffer.get(b);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream output = (FileOutputStream)Files.newOutputStreamSupplier((File)file).getOutput();
        output.write(b);
        output.close();
    }

    private String dumpEntry(int offset) {
        return "<disabled>";
    }

    private static int compare(byte[] data, int offset, byte terminator, String s, int max) {
        int i = offset;
        for (int j = 0; j < max; ++j) {
            byte b = data[i];
            char c = s.charAt(j);
            byte cb = (byte)c;
            int delta = b - cb;
            if (delta != 0) {
                return delta;
            }
            ++i;
        }
        return data[i] - terminator;
    }

    public static boolean isRelevantClass(String name) {
        return true;
    }

    public int getClassVersion(@NonNull String className) {
        if (!ApiLookup.isRelevantClass(className)) {
            return -1;
        }
        if (this.mData != null) {
            int classNumber = this.findClass(className);
            if (classNumber != -1) {
                int offset = this.mIndices[classNumber];
                while (this.mData[offset] != 0) {
                    ++offset;
                }
                return UnsignedBytes.toInt((byte)this.mData[++offset]);
            }
        } else {
            ApiClass clz = this.mInfo.getClass(className);
            if (clz != null) {
                int since = clz.getSince();
                if (since == Integer.MAX_VALUE) {
                    since = -1;
                }
                return since;
            }
        }
        return -1;
    }

    public int getCallVersion(@NonNull String owner, @NonNull String name, @NonNull String desc) {
        if (!ApiLookup.isRelevantClass(owner)) {
            return -1;
        }
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber != -1) {
                return this.findMember(classNumber, name, desc);
            }
        } else {
            ApiClass clz = this.mInfo.getClass(owner);
            if (clz != null) {
                String signature = name + desc;
                int since = clz.getMethod(signature, this.mInfo);
                if (since == Integer.MAX_VALUE) {
                    since = -1;
                }
                return since;
            }
        }
        return -1;
    }

    public int getFieldVersion(@NonNull String owner, @NonNull String name) {
        if (!ApiLookup.isRelevantClass(owner)) {
            return -1;
        }
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber != -1) {
                return this.findMember(classNumber, name, null);
            }
        } else {
            ApiClass clz = this.mInfo.getClass(owner);
            if (clz != null) {
                int since = clz.getField(name, this.mInfo);
                if (since == Integer.MAX_VALUE) {
                    since = -1;
                }
                return since;
            }
        }
        return -1;
    }

    public static boolean isRelevantOwner(@NonNull String owner) {
        if (owner.startsWith("java")) {
            return true;
        }
        if (owner.startsWith("android")) {
            return !owner.startsWith("/support/", 7);
        }
        return owner.startsWith("org/") ? owner.startsWith("xml", 4) || owner.startsWith("w3c/", 4) || owner.startsWith("json/", 4) || owner.startsWith("apache/", 4) : (owner.startsWith("com/") ? owner.startsWith("google/", 4) || owner.startsWith("android/", 4) : owner.startsWith("junit") || owner.startsWith("dalvik"));
    }

    public boolean isValidJavaPackage(@NonNull String owner) {
        int packageLength = owner.lastIndexOf(47);
        if (packageLength == -1) {
            return false;
        }
        int low = 0;
        int high = this.mJavaPackages.length - 1;
        while (low <= high) {
            int middle = low + high >>> 1;
            int offset = middle;
            int compare = ApiLookup.comparePackage(this.mJavaPackages[offset], owner, packageLength);
            if (compare == 0) {
                return true;
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            if (compare > 0) {
                high = middle - 1;
                continue;
            }
            assert (false);
            return false;
        }
        return false;
    }

    private static int comparePackage(String s1, String s2, int max) {
        for (int i = 0; i < max; ++i) {
            char c2;
            if (i == s1.length()) {
                return -1;
            }
            char c1 = s1.charAt(i);
            if (c1 == (c2 = s2.charAt(i))) continue;
            return c1 - c2;
        }
        if (s1.length() > max) {
            return 1;
        }
        return 0;
    }

    private int findClass(@NonNull String owner) {
        assert (owner.indexOf(46) == -1) : "Should use / instead of . in owner: " + owner;
        int low = 0;
        int high = this.mClassCount - 1;
        int classNameLength = owner.length();
        while (low <= high) {
            int middle = low + high >>> 1;
            int offset = this.mIndices[middle];
            int compare = ApiLookup.compare(this.mData, offset, (byte)0, owner, classNameLength);
            if (compare == 0) {
                return middle;
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            if (compare > 0) {
                high = middle - 1;
                continue;
            }
            assert (false);
            return -1;
        }
        return -1;
    }

    private int findMember(int classNumber, @NonNull String name, @Nullable String desc) {
        int low = this.mClassCount;
        int high = this.mIndices.length - 1;
        while (low <= high) {
            int entryClass;
            int compare;
            int middle = low + high >>> 1;
            int offset = this.mIndices[middle];
            if ((compare = (entryClass = (this.mData[offset++] & 0xFF) << 8 | this.mData[offset++] & 0xFF) - classNumber) == 0) {
                int nameLength;
                if (desc != null) {
                    int argsEnd;
                    nameLength = name.length();
                    compare = ApiLookup.compare(this.mData, offset, (byte)40, name, nameLength);
                    if (compare == 0 && (compare = ApiLookup.compare(this.mData, offset += nameLength, (byte)41, desc, argsEnd = desc.indexOf(41))) == 0) {
                        offset += argsEnd + 1;
                        if (this.mData[offset++] == 0) {
                            return UnsignedBytes.toInt((byte)this.mData[offset]);
                        }
                    }
                } else {
                    nameLength = name.length();
                    compare = ApiLookup.compare(this.mData, offset, (byte)0, name, nameLength);
                    if (compare == 0) {
                        offset += nameLength;
                        if (this.mData[offset++] == 0) {
                            return UnsignedBytes.toInt((byte)this.mData[offset]);
                        }
                    }
                }
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            if (compare > 0) {
                high = middle - 1;
                continue;
            }
            assert (false);
            return -1;
        }
        return -1;
    }

    static void dispose() {
        sInstance.clear();
    }
}

