/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import kotlin.ArraysKt;
import kotlin.StringsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.JvmFunctionSignature;
import kotlin.reflect.jvm.internal.KDeclarationContainerImpl;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectClassUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001C\u0003\taa\u0001!G\u0001\u0019\u0002u\u0015)aa\u0002\u0005\n\u0005\u001eA!A)\u0004\u0003!\tQ\u0005\u0002\u0003\u0014\u0011\u0007i\u0011\u0001\u0007\u0002"}, strings={"Lkotlin/reflect/jvm/internal/JvmFunctionSignature;", "", "()V", "asString", "", "BuiltInFunction", "JavaConstructor", "JavaMethod", "KotlinConstructor", "KotlinFunction"}, moduleName="kotlin-reflection")
public abstract class JvmFunctionSignature {
    @NotNull
    public abstract String asString();

    private JvmFunctionSignature() {
    }

    public /* synthetic */ JvmFunctionSignature(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0013\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\tA\u0001\u0002\u0007\u00013\u0005A\n!)\u0004\n\u0007!\tQ\"\u0001M\u0002#\u000e\t\u0001BA\u0013\u0005\t-AY!D\u0001\u0019\u0004%RAa\u0011\u0005\t\u00065\t\u00014\u0001\u000f$#\u000e\u0019QB\u0001\u0003\u0004\u0011\u000fI#\u0002B\"\t\u0011\u0011i\u0011\u0001g\u0001\u001dGE\u001b1!\u0004\u0002\u0005\n!\u001d\u0011F\u0003\u0003D\u0011!\tQ\"\u0001M\u0002#\u000e!Q\u0001A\u0007\u0003\t\u0015A9\u0001"}, strings={"Lkotlin/reflect/jvm/internal/JvmFunctionSignature$KotlinFunction;", "Lkotlin/reflect/jvm/internal/JvmFunctionSignature;", "signature", "", "(Ljava/lang/String;)V", "methodDesc", "getMethodDesc", "()Ljava/lang/String;", "methodName", "getMethodName", "getSignature", "asString"}, moduleName="kotlin-reflection")
    public static final class KotlinFunction
    extends JvmFunctionSignature {
        @NotNull
        private final String signature;

        @NotNull
        public final String getMethodName() {
            return StringsKt.substringBefore$default(this.signature, '(', null, 2);
        }

        @NotNull
        public final String getMethodDesc() {
            return StringsKt.substring(this.signature, StringsKt.indexOf$default((CharSequence)this.signature, '(', 0, false, 6));
        }

        @Override
        @NotNull
        public String asString() {
            return this.signature;
        }

        @NotNull
        public final String getSignature() {
            return this.signature;
        }

        public KotlinFunction(@NotNull String signature) {
            Intrinsics.checkParameterIsNotNull(signature, "signature");
            super(null);
            this.signature = signature;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0013\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\tAa\u0001\u0007\u00013\u0005A\n!)\u0004\n\u0007!\tQ\"\u0001M\u0002#\u000e\t\u0001BA\u0013\u0005\t-AI!D\u0001\u0019\u0004%RAa\u0011\u0005\t\u00065\t\u00014\u0001\u000f$#\u000e\u0019QB\u0001\u0003\u0004\u0011\u000fI#\u0002B\"\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0011)\u0001!\u0004\u0002\u0005\t!\u001d\u0001"}, strings={"Lkotlin/reflect/jvm/internal/JvmFunctionSignature$KotlinConstructor;", "Lkotlin/reflect/jvm/internal/JvmFunctionSignature;", "signature", "", "(Ljava/lang/String;)V", "constructorDesc", "getConstructorDesc", "()Ljava/lang/String;", "getSignature", "asString"}, moduleName="kotlin-reflection")
    public static final class KotlinConstructor
    extends JvmFunctionSignature {
        @NotNull
        private final String signature;

        @NotNull
        public final String getConstructorDesc() {
            return StringsKt.substring(this.signature, StringsKt.indexOf$default((CharSequence)this.signature, '(', 0, false, 6));
        }

        @Override
        @NotNull
        public String asString() {
            return this.signature;
        }

        @NotNull
        public final String getSignature() {
            return this.signature;
        }

        public KotlinConstructor(@NotNull String signature) {
            Intrinsics.checkParameterIsNotNull(signature, "signature");
            super(null);
            this.signature = signature;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0017\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0011\u001da\u0001!G\u0001\u0019\u0002\u00056\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u0011\t)C\u0001B\u0006\t\b5\t\u0001\u0004B\u0015\u000b\t\rC\u0001\"A\u0007\u00021\u0007\t6\u0001B\u0003\u0001\u001b\t!)\u0001C\u0002"}, strings={"Lkotlin/reflect/jvm/internal/JvmFunctionSignature$JavaMethod;", "Lkotlin/reflect/jvm/internal/JvmFunctionSignature;", "method", "Ljava/lang/reflect/Method;", "(Ljava/lang/reflect/Method;)V", "getMethod", "()Ljava/lang/reflect/Method;", "asString", ""}, moduleName="kotlin-reflection")
    public static final class JavaMethod
    extends JvmFunctionSignature {
        @NotNull
        private final Method method;

        @Override
        @NotNull
        public String asString() {
            return this.method.getName() + ArraysKt.joinToString$default((Object[])this.method.getParameterTypes(), (CharSequence)"", (CharSequence)"(", (CharSequence)")", 0, null, (Function1)asString.1.INSTANCE, 24) + ReflectClassUtilKt.getDesc(this.method.getReturnType());
        }

        @NotNull
        public final Method getMethod() {
            return this.method;
        }

        public JavaMethod(@NotNull Method method) {
            Intrinsics.checkParameterIsNotNull(method, "method");
            super(null);
            this.method = method;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0017\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0011\u001da\u0001!G\u0001\u0019\u0002\u0005F\u0011\"\u0002\u0005\u0002\u001b\rI\u0011\u0001b\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0002&\t\u0011Y\u0001rA\u0007\u00021\u0011IC\u0002B\"\t\u0011\u0005i1!C\u0001\u0005\u0004a\r\u0011k\u0001\u0003\u0006\u00015\u0011AQ\u0001\u0005\u0004"}, strings={"Lkotlin/reflect/jvm/internal/JvmFunctionSignature$JavaConstructor;", "Lkotlin/reflect/jvm/internal/JvmFunctionSignature;", "constructor", "Ljava/lang/reflect/Constructor;", "(Ljava/lang/reflect/Constructor;)V", "getConstructor", "()Ljava/lang/reflect/Constructor;", "asString", ""}, moduleName="kotlin-reflection")
    public static final class JavaConstructor
    extends JvmFunctionSignature {
        @NotNull
        private final Constructor<?> constructor;

        @Override
        @NotNull
        public String asString() {
            return "<init>" + ArraysKt.joinToString$default((Object[])this.constructor.getParameterTypes(), (CharSequence)"", (CharSequence)"(", (CharSequence)")", 0, null, (Function1)asString.1.INSTANCE, 24) + "V";
        }

        @NotNull
        public final Constructor<?> getConstructor() {
            return this.constructor;
        }

        public JavaConstructor(@NotNull Constructor<?> constructor) {
            Intrinsics.checkParameterIsNotNull(constructor, "constructor");
            super(null);
            this.constructor = constructor;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\tA1A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Aa\u0003\u0007\u00013\u0005A\n!(\u0001\u0006C\u001bI1\u0001C\u0001\u000e\u0003a\r\u0011kA\u0001\t\u0005\u0015\"Aa\u0003E\u0003\u001b\u0005A\u001a!J\u0005\u0005\u0017!\u0019QB\u0001G\u00011\u000fI2\u0001\u0003\u0003\u000e\u0003a%\u0011f\u0002\u0003B\u0011!\tQ\"\u0001M\u0002#\u000e\tQ\u0001\u0001"}, strings={"Lkotlin/reflect/jvm/internal/JvmFunctionSignature$BuiltInFunction;", "Lkotlin/reflect/jvm/internal/JvmFunctionSignature;", "signature", "", "(Ljava/lang/String;)V", "asString", "getMember", "Ljava/lang/reflect/Member;", "container", "Lkotlin/reflect/jvm/internal/KDeclarationContainerImpl;", "Predefined"}, moduleName="kotlin-reflection")
    public static class BuiltInFunction
    extends JvmFunctionSignature {
        private final String signature;

        @Nullable
        public Member getMember(@NotNull KDeclarationContainerImpl container) {
            Intrinsics.checkParameterIsNotNull(container, "container");
            return null;
        }

        @Override
        @NotNull
        public String asString() {
            return this.signature;
        }

        public BuiltInFunction(@NotNull String signature) {
            Intrinsics.checkParameterIsNotNull(signature, "signature");
            super(null);
            this.signature = signature;
        }

        @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001d\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u00031\u0001\u0011$\u0001M\u0001C+I1\u0001C\u0001\u000e\u0003a\r\u0011b\u0001\u0005\u0003\u001b\u0005A*!U\u0002\u0002\u0011\r)\u0003\u0002B\u0006\t\b5\t\u0001TA\r\u0004\u0011\u0011i\u0011\u0001'\u0003*\u000f\u0011\t\u0005\u0002\u0003\u0002\u000e\u0003a\u0015\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lkotlin/reflect/jvm/internal/JvmFunctionSignature$BuiltInFunction$Predefined;", "Lkotlin/reflect/jvm/internal/JvmFunctionSignature$BuiltInFunction;", "signature", "", "member", "Ljava/lang/reflect/Member;", "(Ljava/lang/String;Ljava/lang/reflect/Member;)V", "getMember", "container", "Lkotlin/reflect/jvm/internal/KDeclarationContainerImpl;"}, moduleName="kotlin-reflection")
        public static final class Predefined
        extends BuiltInFunction {
            private final Member member;

            @Override
            @NotNull
            public Member getMember(@NotNull KDeclarationContainerImpl container) {
                Intrinsics.checkParameterIsNotNull(container, "container");
                return this.member;
            }

            public Predefined(@NotNull String signature, @NotNull Member member) {
                Intrinsics.checkParameterIsNotNull(signature, "signature");
                Intrinsics.checkParameterIsNotNull(member, "member");
                super(signature);
                this.member = member;
            }
        }
    }
}

