/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.when;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.resolve.constants.EnumValue;

public class WhenByEnumsMapping {
    private final Map<EnumValue, Integer> map;
    private final ClassDescriptor enumClassDescriptor;
    private final String outerClassInternalNameForExpression;
    private final String mappingsClassInternalName;
    private final int fieldNumber;

    public WhenByEnumsMapping(@NotNull ClassDescriptor enumClassDescriptor, @NotNull String outerClassInternalNameForExpression, int fieldNumber) {
        if (enumClassDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassDescriptor", "org/jetbrains/kotlin/codegen/when/WhenByEnumsMapping", "<init>"));
        }
        if (outerClassInternalNameForExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerClassInternalNameForExpression", "org/jetbrains/kotlin/codegen/when/WhenByEnumsMapping", "<init>"));
        }
        this.map = new LinkedHashMap<EnumValue, Integer>();
        this.enumClassDescriptor = enumClassDescriptor;
        this.outerClassInternalNameForExpression = outerClassInternalNameForExpression;
        this.mappingsClassInternalName = outerClassInternalNameForExpression + "$WhenMappings";
        this.fieldNumber = fieldNumber;
    }

    public int getIndexByEntry(@NotNull EnumValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/when/WhenByEnumsMapping", "getIndexByEntry"));
        }
        Integer result2 = this.map.get(value2);
        assert (result2 != null) : "entry " + value2 + " has no mapping";
        return result2;
    }

    public void putFirstTime(@NotNull EnumValue value2, int index2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/when/WhenByEnumsMapping", "putFirstTime"));
        }
        if (!this.map.containsKey(value2)) {
            this.map.put(value2, index2);
        }
    }

    public int size() {
        return this.map.size();
    }

    @NotNull
    public String getFieldName() {
        String string = "$EnumSwitchMapping$" + this.fieldNumber;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/when/WhenByEnumsMapping", "getFieldName"));
        }
        return string;
    }

    @NotNull
    public ClassDescriptor getEnumClassDescriptor() {
        ClassDescriptor classDescriptor = this.enumClassDescriptor;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/when/WhenByEnumsMapping", "getEnumClassDescriptor"));
        }
        return classDescriptor;
    }

    @NotNull
    public String getOuterClassInternalNameForExpression() {
        String string = this.outerClassInternalNameForExpression;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/when/WhenByEnumsMapping", "getOuterClassInternalNameForExpression"));
        }
        return string;
    }

    @NotNull
    public String getMappingsClassInternalName() {
        String string = this.mappingsClassInternalName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/when/WhenByEnumsMapping", "getMappingsClassInternalName"));
        }
        return string;
    }

    @NotNull
    public Iterable<Map.Entry<EnumValue, Integer>> enumValuesToIntMapping() {
        Set<Map.Entry<EnumValue, Integer>> set = this.map.entrySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/when/WhenByEnumsMapping", "enumValuesToIntMapping"));
        }
        return set;
    }
}

