/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.sourceMap;

import com.google.dart.compiler.common.SourceInfo;
import com.google.dart.compiler.util.TextOutput;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairConsumer;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.kotlin.js.sourceMap.SourceMapBuilder;

public class SourceMap3Builder
implements SourceMapBuilder {
    private final StringBuilder out = new StringBuilder(8192);
    private final File generatedFile;
    private final TextOutput textOutput;
    private final PairConsumer<SourceMapBuilder, Object> sourceInfoConsumer;
    private String lastSource;
    private int lastSourceIndex;
    private final TObjectIntHashMap<String> sources = new TObjectIntHashMap<String>(){

        @Override
        public int get(String key) {
            int index2 = this.index(key);
            return index2 < 0 ? -1 : this._values[index2];
        }
    };
    private final List<String> orderedSources = new ArrayList<String>();
    private int previousGeneratedColumn = -1;
    private int previousSourceIndex;
    private int previousSourceLine;
    private int previousSourceColumn;

    public SourceMap3Builder(File generatedFile, TextOutput textOutput, PairConsumer<SourceMapBuilder, Object> sourceInfoConsumer) {
        this.generatedFile = generatedFile;
        this.textOutput = textOutput;
        this.sourceInfoConsumer = sourceInfoConsumer;
    }

    @Override
    public File getOutFile() {
        return new File(this.generatedFile.getParentFile(), this.generatedFile.getName() + ".map");
    }

    @Override
    public String build() {
        StringBuilder sb = new StringBuilder(this.out.length() + 128 * this.orderedSources.size());
        sb.append("{\"version\":3,\"file\":\"").append(this.generatedFile.getName()).append('\"').append(',');
        this.appendSources(sb);
        sb.append(",\"names\":[");
        sb.append("],\"mappings\":\"");
        sb.append((CharSequence)this.out);
        sb.append("\"}");
        return sb.toString();
    }

    private void appendSources(StringBuilder sb) {
        boolean isNotFirst = false;
        sb.append('\"').append("sources").append("\":[");
        for (String source : this.orderedSources) {
            if (isNotFirst) {
                sb.append(',');
            } else {
                isNotFirst = true;
            }
            sb.append('\"').append("file://").append(source).append('\"');
        }
        sb.append(']');
    }

    @Override
    public void newLine() {
        this.out.append(';');
        this.previousGeneratedColumn = -1;
    }

    @Override
    public void skipLinesAtBeginning(int count) {
        this.out.insert(0, StringUtil.repeatSymbol(';', count));
    }

    @Override
    public void processSourceInfo(Object sourceInfo) {
        if (sourceInfo instanceof SourceInfo) {
            throw new UnsupportedOperationException("SourceInfo is not yet supported");
        }
        this.sourceInfoConsumer.consume(this, sourceInfo);
    }

    private int getSourceIndex(String source) {
        if (source.equals(this.lastSource)) {
            return this.lastSourceIndex;
        }
        int sourceIndex = this.sources.get(source);
        if (sourceIndex == -1) {
            sourceIndex = this.orderedSources.size();
            this.sources.put(source, sourceIndex);
            this.orderedSources.add(source);
        }
        this.lastSource = source;
        this.lastSourceIndex = sourceIndex;
        return sourceIndex;
    }

    @Override
    public void addMapping(String source, int sourceLine, int sourceColumn) {
        if (this.previousGeneratedColumn == -1) {
            this.previousGeneratedColumn = 0;
        } else {
            this.out.append(',');
        }
        int columnDiff = this.textOutput.getColumn() - this.previousGeneratedColumn;
        Base64VLQ.encode(this.out, columnDiff);
        this.previousGeneratedColumn = this.textOutput.getColumn();
        int sourceIndex = this.getSourceIndex(source);
        Base64VLQ.encode(this.out, sourceIndex - this.previousSourceIndex);
        this.previousSourceIndex = sourceIndex;
        Base64VLQ.encode(this.out, sourceLine - this.previousSourceLine);
        this.previousSourceLine = sourceLine;
        Base64VLQ.encode(this.out, sourceColumn - this.previousSourceColumn);
        this.previousSourceColumn = sourceColumn;
    }

    @Override
    public void addLink() {
        this.textOutput.print("\n//@ sourceMappingURL=");
        this.textOutput.print(this.generatedFile.getName());
        this.textOutput.print(".map\n");
    }

    private static final class Base64VLQ {
        private static final char[] BASE64_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

        private Base64VLQ() {
        }

        private static int toVLQSigned(int value2) {
            return value2 < 0 ? (-value2 << 1) + 1 : value2 << 1;
        }

        public static void encode(StringBuilder out, int value2) {
            value2 = Base64VLQ.toVLQSigned(value2);
            do {
                int digit = value2 & 0x1F;
                if ((value2 >>>= 5) > 0) {
                    digit |= 0x20;
                }
                out.append(BASE64_MAP[digit]);
            } while (value2 > 0);
        }
    }
}

