/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LocalTimeCounter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegationSpecifier;
import org.jetbrains.kotlin.psi.KtDelegatorToSuperCall;
import org.jetbrains.kotlin.psi.KtDelegatorToSuperClass;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactory$CallableBuilder$WhenMappings;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeCodeFragment;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.resolve.ImportPath;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"]\u0006)\u0011\u0001D\u0001\u0006\u0003!\u0001Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u001d)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005AY!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005AA!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0003\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001\u0003\u0003\u0019\u0001I\u0012\u0001'\u0001\u001e\u0005#\u0007\u0011\u001aAQ\u0007\u0013\rA\u0011!D\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0002&\u001f!\u0015Q\"\u0001\r\u00043\rA9!D\u0001\u0019\te\u0019\u0001\u0012B\u0007\u00021\u0011I2\u0001C\u0003\u000e\u0003a-Qe\u0002\u0005\u0007\u001b\u0005Aj!G\u0002\t\n5\t\u0001\u0004B\u0013\u0004\u0011\u001di\u0011\u0001g\u0004&'!AQ\"\u0001M\t3\u0011A\u0011\"\u0004\u0002\r\u0002aM\u0011$\u0002\u0003\u0002\u0011)i!\u0001$\u0001\u0019\u0016e!A!\u0001\u0005\f\u001b\u0005A:\"J\u0004\t\u00195\t\u0001\u0014D\r\u0004\u00115i\u0011\u0001\u0007\u0003&\u0019!mQ\"\u0001\r\u000f3\rAI!D\u0001\u0019\te!\u0001RD\u0007\u0003\u0019\u0003AZ!J\u0004\t\u001f5\t\u0001tD\r\u0004\u0011%i\u0011\u0001g\u0005&\u000f!\u0001R\"\u0001M\u00113\rAI!D\u0001\u0019\t\u0015:\u0001\"E\u0007\u00021GI2\u0001#\u0003\u000e\u0003a!Qe\u0002\u0005\u0013\u001b\u0005A*#G\u0002\t'5\t\u0001\u0004B\u0013\u0004\u0011Oi\u0011\u0001g\u0003&\u0007!!R\"\u0001M\u0006K\u001dAI#D\u0001\u0019+e\u0019\u0001\u0012B\u0007\u00021\u0011)3\u0001c\u000b\u000e\u0003a1Re\u0002E\u0017\u001b\u0005Ar#G\u0002\t\n5\t\u0001\u0004B\u0013\u0004\u0011_i\u0011\u0001g\u0003&\u001e!AR\"\u0001S\u0019#\u0011!\u0001\u0001#\r\u0016\u0003aI\u0012d\u0001E\u0005\u001b\u0005AB!U\u0002\u0002\u0011g)s\u0001\u0003\u000e\u000e\u0003aU\u0012d\u0001E\u0005\u001b\u0005AB!J\u0004\t75\t\u0001tG\r\u0004\u0011\u0013i\u0011\u0001\u0007\u0003&\u0007!aR\"\u0001M\u0006K\rAI$D\u0001\u0019\f\u0015\u001a\u0001\"H\u0007\u000213)3\u0001c\u000f\u000e\u0003aqRe\u0002E\u001f\u001b\u0005Ar$G\u0002\t\n5\t\u0001\u0004B\u0013\u0004\u0011\u007fi\u0011\u0001\u0007\u0011&\u000f!\u0005S\"\u0001M\n3\rAI!D\u0001\u0019\t\u0015b\u0001\"I\u0007\u00021\u0007J2\u0001#\u0003\u000e\u0003a!\u0011\u0004\u0002E\u000f\u001b\ta\t\u0001g\u0003&\u000f!\u0011S\"\u0001M\u00063\rA)%D\u0001\u0019\t\u0015:\u0001bI\u0007\u00021\rI2\u0001#\u0003\u000e\u0003a!Qe\u0003\u0005$\u001b\u0005A2!G\u0002\t\b5\t\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001\u0007\u0003&\u000f!\u001dS\"\u0001\r%3\rAI%D\u0001\u0019\t\u0015:\u0001\"J\u0007\u00021\u0017J2\u0001#\u0003\u000e\u0003a!Qe\u0002\u0005'\u001b\u0005AZ!G\u0002\t\u00155\t\u0001\u0004B\u0013\u0012\u0011\u001bj\u0011\u0001G\u0014\u001a\u0007!=S\"\u0001M\n3\rA\u0001&D\u0001\u0019\u0014e)A!\u0001E)\u001b\ta\t\u0001g\u0005&\u000f!IS\"\u0001M*3\rA!&D\u0001\u0019V\u0015:\u0001bK\u0007\u00021/J2\u0001\u0003\u0016\u000e\u0003aUSe\u0002\u0005-\u001b\u0005AJ&G\u0002\t[5\t\u0001\u0004B\u0013\b\u00117j\u0011\u0001g\u0003\u001a\u0007!qS\"\u0001M/K\u001dAq&D\u0001\u0019`e\u0019\u0001\u0012B\u0007\u00021\u0011)s\u0001C\u0018\u000e\u0003a}\u0013d\u0001\u0005/\u001b\u0005Aj&J\u0004\ta5\t\u00014B\r\u0004\u0011)i\u0011\u0001\u0007\u0003&\u0007!\u0005T\"\u0001M\u0006K\u001dA\t'D\u0001\u0019\fe\u0019\u0001\"M\u0007\u00021G*s\u0001\u0003\u001a\u000e\u0003a\u0015\u0014d\u0001\u0005\u000b\u001b\u0005AB!J\u0004\tg5\t\u0001tM\r\u0004\u0011Qj\u0011\u0001'\u001b&\u0011!)TB\u0001G\u00011OJ2\u0001\u0003\u001b\u000e\u0003a%Te\u0002E6\u001b\u0005Ab'G\u0002\t\n5\t\u0001\u0004B\u0013\b\u0011[j\u0011\u0001g\u0013\u001a\u0007!%Q\"\u0001\r\u0005K-Aq'D\u0001\u0019\u0007e\u0019\u0001rA\u0007\u00021\u0011I2\u0001#\u0003\u000e\u0003a!Qe\u0001E8\u001b\u0005A\u0002(J\u0004\tr5\t\u0001$O\r\u0004\u0011\u0013i\u0011\u0001\u0007\u0003&!!ET\"\u0001\r:3\rA!\"D\u0001\u0019\te!\u00012O\u0007\u0003\u0019\u0003AB!G\u0002\tu5\t\u0001tC\u0013\u0016\u0011cj\u0011\u0001G\u001d\u001a\u0007!QQ\"\u0001\r\u00053\u0011A\u0019(\u0004\u0002\r\u0002a!\u0011d\u0001\u0005;\u001b\u0005A:\"\u0007\u0003\tv5\u0011A\u0012\u0001\r\u0005K\rA1(D\u0001\u0019x\u0015:\u0001\u0002P\u0007\u00021sJ2\u0001C\u001f\u000e\u0003a!Qe\u0001E>\u001b\u0005AZ!J\u0004\t}5\t\u0001TM\r\u0004\u0011)i\u0011\u0001\u0007\u0003&\u000f!uT\"\u0001M\u00103\rA!\"D\u0001\u0019\t\u0015:\u0001bP\u0007\u000213I2\u0001c \u000e\u0003aMQu\u0001\u0005A\u00025\t\u00014B\u0013\t\u0011\u0003\u0007Q2\u0001\rB\u0002e\u0019\u00012O\u0007\u00021\u0011)\u0003\u0002ca\u0001\u001b\u0007A\"\u0019A\r\u0004\u0011\u0013i\u0011\u0001\u0007\u0003&\u001b!\u0015\r!d\u0001\u0019\u0007\u0004I2\u0001#\u0003\u000e\u0003a!\u0011\u0004\u0002E\u000f\u001b\ta\t\u0001g\u0003&\b!\u001d\r!D\u0001\u0019\f\u0015\u001e\u0001\u00022\u0001\u000e\u0003a-Q\u0015\u0003EE\u00025\r\u0001$2\u0001\u001a\b!-\r!D\u0001\u0019\t\u0015\u001e\u0001B2\u0001\u000e\u0003a-Qu\u0002\u0005G\u00025\t\u00014B\r\u0004\u0011\u0013i\u0011\u0001\u0007\u0003&\u0015!5\r!d\u0004\n\u0005%\t\u00014B\u0005\u0003\u0013\u0005AZ\u0001Gd\u0001K3!\u0011\u0001cd\u0001\u001b\u0005A2!G\u0002\t\b5\t\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001\u0007\u0003&\u0010!A\r!D\u0001\u0019\u001ae\u0019\u0001\"C\u0007\u00021'Is\u0001B!\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createAnalyzableFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "fileName", "", "text", "contextToAnalyzeIn", "Lcom/intellij/psi/PsiElement;", "createAnnotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "createAnonymousInitializer", "Lorg/jetbrains/kotlin/psi/KtClassInitializer;", "createArgument", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "name", "Lorg/jetbrains/kotlin/name/Name;", "isSpread", "", "createBlock", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "bodyText", "createBlockCodeFragment", "Lorg/jetbrains/kotlin/psi/KtBlockCodeFragment;", "context", "createBlockStringTemplateEntry", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntryWithExpression;", "createCallArguments", "Lorg/jetbrains/kotlin/psi/KtValueArgumentList;", "createClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "createClassLiteral", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "className", "createColon", "createComma", "createComment", "Lcom/intellij/psi/PsiComment;", "createCompanionObject", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "createConstructorDelegationCall", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "createConstructorKeyword", "createDeclaration", "TDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "createDelegatorToSuperCall", "Lorg/jetbrains/kotlin/psi/KtDelegatorToSuperCall;", "createDelegatorToSuperClass", "Lorg/jetbrains/kotlin/psi/KtDelegatorToSuperClass;", "createDot", "createEQ", "createEmptyBody", "createEmptyClassBody", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "createEnumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "createEnumEntryInitializerList", "Lorg/jetbrains/kotlin/psi/KtInitializerList;", "createExpression", "createExpressionCodeFragment", "Lorg/jetbrains/kotlin/psi/KtExpressionCodeFragment;", "createFieldIdentifier", "fieldName", "createFile", "createFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "funDecl", "createFunctionLiteralParameterList", "Lorg/jetbrains/kotlin/psi/KtParameterList;", "createIdentifier", "createIf", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "condition", "thenExpr", "elseExpr", "createImportDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "importPath", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "createImportDirectiveWithImportList", "Lorg/jetbrains/kotlin/psi/KtImportList;", "createLabeledExpression", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "labelName", "createModifier", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "createModifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "createNameIdentifier", "createNewLine", "lineBreaks", "", "createOperationName", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "createPackageDirective", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "createPackageDirectiveIfNeeded", "createParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "createParameterList", "createPhysicalFile", "createPrimaryConstructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "createProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "type", "isVar", "initializer", "createSafeCallNode", "Lcom/intellij/lang/ASTNode;", "createSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "decl", "createSemicolon", "createSimpleName", "createSimpleNameStringTemplateEntry", "createSingleStatementBlock", "statement", "createStar", "createType", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "createTypeArguments", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "createTypeCodeFragment", "Lorg/jetbrains/kotlin/psi/KtTypeCodeFragment;", "createValKeyword", "createVarKeyword", "createWhenEntry", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "entryText", "createWhiteSpace", "createWhitespaceAndArrow", "Lkotlin/Pair;", "doCreateFile", "wrapInABlockWrapper", "BlockWrapper", "CallableBuilder"}, moduleName="kotlin-compiler")
public final class KtPsiFactory {
    private final Project project;

    @NotNull
    public final PsiElement createValKeyword() {
        KtProperty property = this.createProperty("val x = 1");
        PsiElement psiElement2 = property.getValOrVarKeyword();
        Intrinsics.checkExpressionValueIsNotNull(psiElement2, "property.getValOrVarKeyword()");
        return psiElement2;
    }

    @NotNull
    public final PsiElement createVarKeyword() {
        KtProperty property = this.createProperty("var x = 1");
        PsiElement psiElement2 = property.getValOrVarKeyword();
        Intrinsics.checkExpressionValueIsNotNull(psiElement2, "property.getValOrVarKeyword()");
        return psiElement2;
    }

    @NotNull
    public final ASTNode createSafeCallNode() {
        KtExpression ktExpression = this.createExpression("a?.b");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSafeQualifiedExpression");
        }
        ASTNode aSTNode = ((KtSafeQualifiedExpression)ktExpression).getOperationTokenNode();
        Intrinsics.checkExpressionValueIsNotNull(aSTNode, "(createExpression(\"a?.b\"\u2026).getOperationTokenNode()");
        return aSTNode;
    }

    @NotNull
    public final KtExpression createExpression(@NotNull String text) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtExpression ktExpression = this.createProperty("val x =" + "\n" + text).getInitializer();
        if (ktExpression == null) {
            ktExpression = (KtExpression)((Object)PreconditionsKt.error("Failed to create expression from text: '" + text + "'"));
        }
        KtExpression expression = ktExpression;
        boolean value2 = Intrinsics.areEqual(expression.getText(), text);
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value2) {
                String message = "Failed to create expression from text: '" + text + "', resulting expression's text was: '" + expression.getText() + "'";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        KtExpression ktExpression2 = expression;
        Intrinsics.checkExpressionValueIsNotNull(ktExpression2, "expression");
        return ktExpression2;
    }

    @NotNull
    public final KtClassLiteralExpression createClassLiteral(@NotNull String className) {
        Intrinsics.checkParameterIsNotNull(className, "className");
        KtExpression ktExpression = this.createExpression(className + "::class");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassLiteralExpression");
        }
        return (KtClassLiteralExpression)ktExpression;
    }

    @NotNull
    public final KtValueArgumentList createCallArguments(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtProperty property = this.createProperty("val x = foo " + text);
        KtExpression ktExpression = property.getInitializer();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
        }
        KtValueArgumentList ktValueArgumentList = ((KtCallExpression)ktExpression).getValueArgumentList();
        if (ktValueArgumentList == null) {
            Intrinsics.throwNpe();
        }
        return ktValueArgumentList;
    }

    @NotNull
    public final KtTypeArgumentList createTypeArguments(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtProperty property = this.createProperty("val x = foo" + text + "()");
        KtExpression ktExpression = property.getInitializer();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
        }
        KtTypeArgumentList ktTypeArgumentList = ((KtCallExpression)ktExpression).getTypeArgumentList();
        if (ktTypeArgumentList == null) {
            Intrinsics.throwNpe();
        }
        return ktTypeArgumentList;
    }

    @NotNull
    public final KtTypeReference createType(@NotNull String type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        KtTypeReference typeReference = this.createProperty("val x : " + type2).getTypeReference();
        if (typeReference == null || Intrinsics.areEqual(typeReference.getText(), type2) ^ true) {
            throw (Throwable)new IllegalArgumentException("Incorrect type: " + type2);
        }
        return typeReference;
    }

    @NotNull
    public final PsiElement createStar() {
        PsiElement psiElement2 = this.createType("List<*>").findElementAt(5);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return psiElement2;
    }

    @NotNull
    public final PsiElement createComma() {
        PsiElement psiElement2 = this.createType("T<X, Y>").findElementAt(3);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return psiElement2;
    }

    @NotNull
    public final PsiElement createDot() {
        PsiElement psiElement2 = this.createType("T.(X)").findElementAt(1);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return psiElement2;
    }

    @NotNull
    public final PsiElement createColon() {
        PsiElement psiElement2 = this.createProperty("val x: Int").findElementAt(5);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return psiElement2;
    }

    @NotNull
    public final PsiElement createEQ() {
        PsiElement psiElement2 = this.createFunction("fun foo() = foo").getEqualsToken();
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return psiElement2;
    }

    @NotNull
    public final PsiElement createSemicolon() {
        PsiElement psiElement2 = this.createProperty("val x: Int;").findElementAt(10);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return psiElement2;
    }

    @NotNull
    public final Pair<PsiElement, PsiElement> createWhitespaceAndArrow() {
        KtTypeElement ktTypeElement = this.createType("() -> Int").getTypeElement();
        if (ktTypeElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunctionType");
        }
        KtFunctionType functionType = (KtFunctionType)ktTypeElement;
        PsiElement psiElement2 = functionType.findElementAt(2);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement3 = functionType.findElementAt(3);
        if (psiElement3 == null) {
            Intrinsics.throwNpe();
        }
        return new Pair<PsiElement, PsiElement>(psiElement2, psiElement3);
    }

    @NotNull
    public final PsiElement createWhiteSpace() {
        return this.createWhiteSpace(" ");
    }

    @NotNull
    public final PsiElement createWhiteSpace(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        PsiElement psiElement2 = this.createProperty("val" + text + "x").findElementAt(3);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return psiElement2;
    }

    @NotNull
    public final PsiElement createNewLine() {
        return this.createWhiteSpace("\n");
    }

    @NotNull
    public final PsiElement createNewLine(int lineBreaks) {
        return this.createWhiteSpace(StringsKt.repeat((CharSequence)"\n", lineBreaks));
    }

    @NotNull
    public final KtClass createClass(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return (KtClass)this.createDeclaration(text);
    }

    @NotNull
    public final KtObjectDeclaration createCompanionObject() {
        return CollectionsKt.first(this.createClass("class A {\n companion object{\n}\n}").getCompanionObjects());
    }

    @NotNull
    public final KtFile createFile(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return this.createFile("dummy.kt", text);
    }

    private final KtFile doCreateFile(String fileName, String text) {
        PsiFile psiFile = PsiFileFactory.getInstance(this.project).createFileFromText(fileName, KotlinFileType.INSTANCE, (CharSequence)text, LocalTimeCounter.currentTime(), false);
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        return (KtFile)psiFile;
    }

    @NotNull
    public final KtFile createFile(@NotNull String fileName, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtFile file = this.doCreateFile(fileName, text);
        KtPsiFactoryKt.setDoNotAnalyze(file, "This file was created by KtPsiFactory and should not be analyzed\n" + "Use createAnalyzableFile to create file that can be analyzed\n");
        return file;
    }

    @NotNull
    public final KtFile createAnalyzableFile(@NotNull String fileName, @NotNull String text, @NotNull PsiElement contextToAnalyzeIn) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        Intrinsics.checkParameterIsNotNull(text, "text");
        Intrinsics.checkParameterIsNotNull(contextToAnalyzeIn, "contextToAnalyzeIn");
        KtFile file = this.doCreateFile(fileName, text);
        KtPsiFactoryKt.setAnalysisContext(file, contextToAnalyzeIn);
        return file;
    }

    @NotNull
    public final KtFile createPhysicalFile(@NotNull String fileName, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        Intrinsics.checkParameterIsNotNull(text, "text");
        PsiFile psiFile = PsiFileFactory.getInstance(this.project).createFileFromText(fileName, KotlinFileType.INSTANCE, (CharSequence)text, LocalTimeCounter.currentTime(), true);
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        return (KtFile)psiFile;
    }

    @NotNull
    public final KtProperty createProperty(@NotNull String name, @Nullable String type2, boolean isVar, @Nullable String initializer2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        String text = (isVar ? "var " : "val ") + name + (type2 != null ? ":" + type2 : "") + (initializer2 == null ? "" : " = " + initializer2);
        return this.createProperty(text);
    }

    @NotNull
    public final KtProperty createProperty(@NotNull String name, @Nullable String type2, boolean isVar) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return this.createProperty(name, type2, isVar, null);
    }

    @NotNull
    public final KtProperty createProperty(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return (KtProperty)this.createDeclaration(text);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <TDeclaration extends KtDeclaration> TDeclaration createDeclaration(@NotNull String text) {
        Unit unit;
        void $receiver22;
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtFile file = this.createFile(text);
        List<KtDeclaration> declarations = file.getDeclarations();
        Collection collection = declarations;
        boolean $receiver22 = $receiver22.size() == 1;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            void value2;
            if (value2 == false) {
                void $receiver;
                Collection $i$f$size = declarations;
                StringBuilder stringBuilder = new StringBuilder();
                int n = $receiver.size();
                String message = stringBuilder.append(n).append(" declarations in ").append(text).toString();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        KtDeclaration ktDeclaration = CollectionsKt.first(declarations);
        if (ktDeclaration == null) {
            throw new TypeCastException("null cannot be cast to non-null type TDeclaration");
        }
        KtDeclaration result2 = ktDeclaration;
        return (TDeclaration)result2;
    }

    @NotNull
    public final PsiElement createNameIdentifier(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        PsiElement psiElement2 = this.createProperty(name, null, false).getNameIdentifier();
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return psiElement2;
    }

    @NotNull
    public final KtSimpleNameExpression createSimpleName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        KtExpression ktExpression = this.createProperty(name, null, false, name).getInitializer();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSimpleNameExpression");
        }
        return (KtSimpleNameExpression)ktExpression;
    }

    @NotNull
    public final KtSimpleNameExpression createOperationName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        KtExpression ktExpression = this.createExpression("0 " + name + " 0");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        KtSimpleNameExpression ktSimpleNameExpression = ((KtBinaryExpression)ktExpression).getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull(ktSimpleNameExpression, "(createExpression(\"0 $na\u2026).getOperationReference()");
        return ktSimpleNameExpression;
    }

    @NotNull
    public final PsiElement createIdentifier(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        PsiElement psiElement2 = this.createSimpleName(name).getIdentifier();
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return psiElement2;
    }

    @NotNull
    public final KtNamedFunction createFunction(@NotNull String funDecl) {
        Intrinsics.checkParameterIsNotNull(funDecl, "funDecl");
        return (KtNamedFunction)this.createDeclaration(funDecl);
    }

    @NotNull
    public final KtSecondaryConstructor createSecondaryConstructor(@NotNull String decl) {
        Intrinsics.checkParameterIsNotNull(decl, "decl");
        return CollectionsKt.first(this.createClass("class Foo {" + "\n" + " " + decl + " " + "\n" + "}").getSecondaryConstructors());
    }

    @NotNull
    public final KtModifierList createModifierList(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkParameterIsNotNull(modifier, "modifier");
        String string = modifier.getValue();
        Intrinsics.checkExpressionValueIsNotNull(string, "modifier.getValue()");
        return this.createModifierList(string);
    }

    @NotNull
    public final KtModifierList createModifierList(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtModifierList ktModifierList = this.createProperty(text + " val x").getModifierList();
        if (ktModifierList == null) {
            Intrinsics.throwNpe();
        }
        return ktModifierList;
    }

    @NotNull
    public final PsiElement createModifier(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkParameterIsNotNull(modifier, "modifier");
        String string = modifier.getValue();
        Intrinsics.checkExpressionValueIsNotNull(string, "modifier.getValue()");
        PsiElement psiElement2 = this.createModifierList(string).getModifier(modifier);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return psiElement2;
    }

    @NotNull
    public final KtAnnotationEntry createAnnotationEntry(@NotNull String text) {
        KtModifierList modifierList;
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtModifierList ktModifierList = modifierList = this.createProperty(text + " val x").getModifierList();
        if (ktModifierList == null) {
            Intrinsics.throwNpe();
        }
        KtAnnotationEntry ktAnnotationEntry = CollectionsKt.first(ktModifierList.getAnnotationEntries());
        Intrinsics.checkExpressionValueIsNotNull(ktAnnotationEntry, "modifierList!!.getAnnotationEntries().first()");
        return ktAnnotationEntry;
    }

    @NotNull
    public final KtBlockExpression createEmptyBody() {
        KtExpression ktExpression = this.createFunction("fun foo() {}").getBodyExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        return (KtBlockExpression)ktExpression;
    }

    @NotNull
    public final KtClassInitializer createAnonymousInitializer() {
        return CollectionsKt.first(this.createClass("class A { init {} }").getAnonymousInitializers());
    }

    @NotNull
    public final KtClassBody createEmptyClassBody() {
        KtClassBody ktClassBody = this.createClass("class A(){}").getBody();
        if (ktClassBody == null) {
            Intrinsics.throwNpe();
        }
        return ktClassBody;
    }

    @NotNull
    public final KtParameter createParameter(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return CollectionsKt.first(this.createClass("class A(" + text + ")").getPrimaryConstructorParameters());
    }

    @NotNull
    public final KtParameterList createParameterList(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtParameterList ktParameterList = this.createFunction("fun foo" + text + "{}").getValueParameterList();
        if (ktParameterList == null) {
            Intrinsics.throwNpe();
        }
        return ktParameterList;
    }

    @NotNull
    public final KtParameterList createFunctionLiteralParameterList(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtExpression ktExpression = this.createExpression("{ " + text + " -> 0}");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunctionLiteralExpression");
        }
        KtParameterList ktParameterList = ((KtFunctionLiteralExpression)ktExpression).getFunctionLiteral().getValueParameterList();
        if (ktParameterList == null) {
            Intrinsics.throwNpe();
        }
        return ktParameterList;
    }

    @NotNull
    public final KtEnumEntry createEnumEntry(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtDeclaration ktDeclaration = ((KtClass)this.createDeclaration("enum class E {" + text + "}")).getDeclarations().get(0);
        if (ktDeclaration == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtEnumEntry");
        }
        return (KtEnumEntry)ktDeclaration;
    }

    @NotNull
    public final KtInitializerList createEnumEntryInitializerList() {
        KtInitializerList ktInitializerList = this.createEnumEntry("Entry()").getInitializerList();
        if (ktInitializerList == null) {
            Intrinsics.throwNpe();
        }
        return ktInitializerList;
    }

    @NotNull
    public final KtWhenEntry createWhenEntry(@NotNull String entryText) {
        Unit unit;
        Unit unit2;
        boolean value2;
        Intrinsics.checkParameterIsNotNull(entryText, "entryText");
        KtNamedFunction function = this.createFunction("fun foo() { when(12) { " + entryText + " } }");
        KtWhenEntry whenEntry = PsiTreeUtil.findChildOfType(function, KtWhenEntry.class);
        boolean bl = whenEntry != null;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value2) {
                String message = "Couldn't generate when entry";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = Unit.INSTANCE;
        }
        KtWhenEntry ktWhenEntry = whenEntry;
        if (ktWhenEntry == null) {
            Intrinsics.throwNpe();
        }
        value2 = Intrinsics.areEqual(entryText, ktWhenEntry.getText());
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value2) {
                String message = "Generate when entry text differs from the given text";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        return whenEntry;
    }

    @NotNull
    public final KtStringTemplateEntryWithExpression createBlockStringTemplateEntry(@NotNull KtExpression expression) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtExpression ktExpression = this.createExpression("\"${" + expression.getText() + "}\"");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        }
        KtStringTemplateExpression stringTemplateExpression = (KtStringTemplateExpression)ktExpression;
        KtStringTemplateEntry ktStringTemplateEntry = stringTemplateExpression.getEntries()[0];
        if (ktStringTemplateEntry == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression");
        }
        return (KtStringTemplateEntryWithExpression)ktStringTemplateEntry;
    }

    @NotNull
    public final KtStringTemplateEntryWithExpression createSimpleNameStringTemplateEntry(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        KtExpression ktExpression = this.createExpression("\"" + "$" + name + "\"");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        }
        KtStringTemplateExpression stringTemplateExpression = (KtStringTemplateExpression)ktExpression;
        KtStringTemplateEntry ktStringTemplateEntry = stringTemplateExpression.getEntries()[0];
        if (ktStringTemplateEntry == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression");
        }
        return (KtStringTemplateEntryWithExpression)ktStringTemplateEntry;
    }

    @NotNull
    public final KtPackageDirective createPackageDirective(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        KtPackageDirective ktPackageDirective = this.createFile("package " + fqName2.asString()).getPackageDirective();
        if (ktPackageDirective == null) {
            Intrinsics.throwNpe();
        }
        return ktPackageDirective;
    }

    @Nullable
    public final KtPackageDirective createPackageDirectiveIfNeeded(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return fqName2.isRoot() ? (KtPackageDirective)null : this.createPackageDirective(fqName2);
    }

    @NotNull
    public final KtImportDirective createImportDirective(@NotNull ImportPath importPath) {
        Intrinsics.checkParameterIsNotNull(importPath, "importPath");
        if (importPath.fqnPart().isRoot()) {
            throw (Throwable)new IllegalArgumentException("import path must not be empty");
        }
        StringBuilder importDirectiveBuilder = new StringBuilder("import ");
        importDirectiveBuilder.append(importPath.getPathStr());
        Name alias = importPath.getAlias();
        if (alias != null) {
            importDirectiveBuilder.append(" as ").append(alias.asString());
        }
        String string = importDirectiveBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "importDirectiveBuilder.toString()");
        KtFile file = this.createFile(string);
        KtImportDirective ktImportDirective = CollectionsKt.first(file.getImportDirectives());
        Intrinsics.checkExpressionValueIsNotNull(ktImportDirective, "file.getImportDirectives().first()");
        return ktImportDirective;
    }

    @NotNull
    public final KtImportList createImportDirectiveWithImportList(@NotNull ImportPath importPath) {
        Intrinsics.checkParameterIsNotNull(importPath, "importPath");
        KtImportDirective importDirective = this.createImportDirective(importPath);
        PsiElement psiElement2 = importDirective.getParent();
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtImportList");
        }
        return (KtImportList)psiElement2;
    }

    @NotNull
    public final KtPrimaryConstructor createPrimaryConstructor() {
        KtPrimaryConstructor ktPrimaryConstructor = this.createClass("class A()").getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            Intrinsics.throwNpe();
        }
        return ktPrimaryConstructor;
    }

    @NotNull
    public final PsiElement createConstructorKeyword() {
        KtPrimaryConstructor ktPrimaryConstructor = this.createClass("class A constructor()").getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement2 = ktPrimaryConstructor.getConstructorKeyword();
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return psiElement2;
    }

    @NotNull
    public final KtLabeledExpression createLabeledExpression(@NotNull String labelName) {
        Intrinsics.checkParameterIsNotNull(labelName, "labelName");
        KtExpression ktExpression = this.createExpression(labelName + "@ 1");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtLabeledExpression");
        }
        return (KtLabeledExpression)ktExpression;
    }

    @NotNull
    public final PsiElement createFieldIdentifier(@NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull(fieldName, "fieldName");
        KtExpression ktExpression = this.createExpression("$" + fieldName);
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
        }
        return ((KtNameReferenceExpression)ktExpression).getReferencedNameElement();
    }

    @NotNull
    public final KtTypeCodeFragment createTypeCodeFragment(@NotNull String text, @Nullable PsiElement context) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return new KtTypeCodeFragment(this.project, "fragment.kt", text, context);
    }

    @NotNull
    public final KtExpressionCodeFragment createExpressionCodeFragment(@NotNull String text, @Nullable PsiElement context) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return new KtExpressionCodeFragment(this.project, "fragment.kt", text, null, context);
    }

    @NotNull
    public final KtBlockCodeFragment createBlockCodeFragment(@NotNull String text, @Nullable PsiElement context) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return new KtBlockCodeFragment(this.project, "fragment.kt", text, null, context);
    }

    @NotNull
    public final KtIfExpression createIf(@NotNull KtExpression condition, @NotNull KtExpression thenExpr, @Nullable KtExpression elseExpr) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull(condition, "condition");
        Intrinsics.checkParameterIsNotNull(thenExpr, "thenExpr");
        if (elseExpr != null) {
            KtExpression ktExpression2 = CreateByPatternKt.createExpressionByPattern(this, "if ($0) $1 else $2", condition, thenExpr, elseExpr);
            if (ktExpression2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
            }
            ktExpression = (KtIfExpression)ktExpression2;
        } else {
            ktExpression = CreateByPatternKt.createExpressionByPattern(this, "if ($0) $1", condition, thenExpr);
        }
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
        }
        return (KtIfExpression)ktExpression;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KtIfExpression createIf$default(KtPsiFactory ktPsiFactory, KtExpression ktExpression, KtExpression ktExpression2, KtExpression ktExpression3, int n) {
        if ((n & 4) != 0) {
            ktExpression3 = null;
        }
        return ktPsiFactory.createIf(ktExpression, ktExpression2, ktExpression3);
    }

    @NotNull
    public final KtValueArgument createArgument(@Nullable KtExpression expression, @Nullable Name name, boolean isSpread) {
        KtValueArgumentList argumentList2 = (KtValueArgumentList)CreateByPatternKt.buildByPattern((Function2)new Function2<String, Object[], KtValueArgumentList>(this){
            final /* synthetic */ KtPsiFactory this$0;

            @NotNull
            public final KtValueArgumentList invoke(@NotNull String pattern, @NotNull Object[] args) {
                Intrinsics.checkParameterIsNotNull(pattern, "pattern");
                Intrinsics.checkParameterIsNotNull(args, "args");
                return (KtValueArgumentList)CreateByPatternKt.createByPattern(pattern, Arrays.copyOf(args, args.length), (Function1)new Function1<String, KtValueArgumentList>(this){
                    final /* synthetic */ createArgument.argumentList.1 this$0;

                    @NotNull
                    public final KtValueArgumentList invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull(it, "it");
                        return this.this$0.this$0.createCallArguments(it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = ktPsiFactory;
                super(2);
            }
        }, (Function1)new Function1<BuilderByPattern<KtValueArgumentList>, Unit>(name, isSpread, expression){
            final /* synthetic */ Name $name;
            final /* synthetic */ boolean $isSpread;
            final /* synthetic */ KtExpression $expression;

            public final void invoke(BuilderByPattern<KtValueArgumentList> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                $receiver.appendFixedText("(");
                if (this.$name != null) {
                    $receiver.appendName(this.$name);
                    $receiver.appendFixedText("=");
                }
                if (this.$isSpread) {
                    $receiver.appendFixedText("*");
                }
                $receiver.appendExpression(this.$expression);
                $receiver.appendFixedText(")");
            }
            {
                this.$name = name;
                this.$isSpread = bl;
                this.$expression = ktExpression;
                super(1);
            }
        });
        KtValueArgument ktValueArgument = CollectionsKt.single(argumentList2.getArguments());
        Intrinsics.checkExpressionValueIsNotNull(ktValueArgument, "argumentList.getArguments().single()");
        return ktValueArgument;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KtValueArgument createArgument$default(KtPsiFactory ktPsiFactory, KtExpression ktExpression, Name name, boolean bl, int n) {
        if ((n & 2) != 0) {
            name = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return ktPsiFactory.createArgument(ktExpression, name, bl);
    }

    @NotNull
    public final KtDelegatorToSuperCall createDelegatorToSuperCall(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtDelegationSpecifier ktDelegationSpecifier = CollectionsKt.first(this.createClass("class A: " + text).getDelegationSpecifiers());
        if (ktDelegationSpecifier == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDelegatorToSuperCall");
        }
        return (KtDelegatorToSuperCall)ktDelegationSpecifier;
    }

    @NotNull
    public final KtDelegatorToSuperClass createDelegatorToSuperClass(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtDelegationSpecifier ktDelegationSpecifier = CollectionsKt.first(this.createClass("class A: " + text).getDelegationSpecifiers());
        if (ktDelegationSpecifier == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDelegatorToSuperClass");
        }
        return (KtDelegatorToSuperClass)ktDelegationSpecifier;
    }

    @NotNull
    public final KtConstructorDelegationCall createConstructorDelegationCall(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        String colonOrEmpty = StringsKt.isEmpty((CharSequence)text) ? "" : ": ";
        return CollectionsKt.first(this.createClass("class A { constructor()" + colonOrEmpty + text + " {}").getSecondaryConstructors()).getDelegationCall();
    }

    @NotNull
    public final KtBlockExpression createBlock(@NotNull String bodyText) {
        Intrinsics.checkParameterIsNotNull(bodyText, "bodyText");
        KtExpression ktExpression = this.createFunction("fun foo() {\n" + bodyText + "\n}").getBodyExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        return (KtBlockExpression)ktExpression;
    }

    @NotNull
    public final KtBlockExpression createSingleStatementBlock(@NotNull KtExpression statement) {
        Intrinsics.checkParameterIsNotNull(statement, "statement");
        KtExpression ktExpression = ((KtNamedFunction)CreateByPatternKt.createDeclarationByPattern(this, "fun foo() {\n$0\n}", statement)).getBodyExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        return (KtBlockExpression)ktExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PsiComment createComment(@NotNull String text) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtFile file = this.createFile(text);
        Object[] objectArray = file.getChildren();
        void var5_4 = $receiver2;
        Collection collection = new ArrayList();
        for (int i = 0; i < ((void)$receiver).length; ++i) {
            void element = $receiver[i];
            if (!(element instanceof PsiComment)) continue;
            destination.add(element);
        }
        List comments = (List)destination;
        PsiComment comment = (PsiComment)CollectionsKt.single(comments);
        PreconditionsKt.assert(Intrinsics.areEqual(comment.getText(), text));
        return comment;
    }

    @NotNull
    public final KtBlockExpression wrapInABlockWrapper(@NotNull KtExpression expression) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        if (expression instanceof KtBlockExpression) {
            return (KtBlockExpression)expression;
        }
        KtNamedFunction function = this.createFunction("fun f() { " + expression.getText() + " }");
        KtExpression ktExpression = function.getBodyExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        KtBlockExpression block = (KtBlockExpression)ktExpression;
        return new BlockWrapper(block, expression);
    }

    public KtPsiFactory(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        this.project = project;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\b\u000b\u0005!!!B\u0001\t\u0003\u0015\tAQB\u0003\u0002\u0011=)\u0011\u0001b\u0001\r\u0001e\t\u0001\u0014A\u000f\u0002 A\tk!C\u0002\t\u00035\t\u00014A)\u0004\u0003!\u0011Qe\u0001E\u0005\u001b\u0005AR!J\u0004\t\f5\t\u0001\u0004A\r\u0004\u0011\u0019i\u0011\u0001G\u0003&\t\u0011\t\u0001RB\u0007\u00021\u0015)C\u0001B\u0001\t\u000f5\t\u0001tB\u0013\b\u0011!i\u0011\u0001\u0007\u0001\u001a\u0007!1Q\"\u0001\r\u0006K\u001dA\t\"D\u0001\u0019\u0001e\u0019\u0001BB\u0007\u00021\u0015)s\u0001C\u0005\u000e\u0003a\u0001\u0011d\u0001\u0005\n\u001b\u0005AR!J\u0004\t\u00145\t\u0001\u0004A\r\u0004\u0011'i\u0011\u0001G\u0003&\u0007!QQ\"\u0001\r\u0001K-A)\"D\u0001\u0019\u0001e\u0019\u00012C\u0007\u00021\u0015I2\u0001C\u0006\u000e\u0003a)Q\u0005\u0002\u0003\u0002\u0011/i\u0011\u0001g\u0004&\u000f!aQ\"\u0001\r\u00013\rAI\"D\u0001\u0019\u000b\u0015:\u0001\"D\u0007\u00021\u0001I2\u0001C\u0006\u000e\u0003a)QE\u0003E\u000e\u001b\u0005A\u0002!\u0007\u0004\t\u001d5!\u0011BA\u0005\u00021\u0015Aj\"\n\u0006\t\u001f5\t\u0001\u0004A\r\u0007\u00119iA!\u0003\u0002\n\u0003a)\u0001TD\u0015\b\t\u0005C\u0001RA\u0007\u00021\r\t6!A\u0003\u0001S\u001d!\u0011\t\bE\u0004\u001b\u0005AB!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder;", "", "target", "Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder$Target;", "(Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder$Target;)V", "sb", "Ljava/lang/StringBuilder;", "state", "Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder$State;", "asString", "", "blockBody", "body", "bodyPrefix", "closeParams", "", "initializer", "lazyBody", "modifier", "name", "noReturnType", "param", "type", "placeKeyword", "receiver", "receiverType", "returnType", "typeConstraints", "values", "", "typeParams", "State", "Target"}, moduleName="kotlin-compiler")
    public static final class CallableBuilder {
        private final StringBuilder sb;
        private State state;
        private final Target target;

        private final void closeParams() {
            if (Intrinsics.areEqual((Object)this.target, (Object)Target.FUNCTION)) {
                PreconditionsKt.assert(Intrinsics.areEqual((Object)this.state, (Object)State.FIRST_PARAM) || Intrinsics.areEqual((Object)this.state, (Object)State.REST_PARAMS));
                this.sb.append(")");
            }
            this.state = State.TYPE_CONSTRAINTS;
        }

        private final void placeKeyword() {
            String string;
            PreconditionsKt.assert(Intrinsics.areEqual((Object)this.state, (Object)State.MODIFIERS));
            if (CollectionsKt.length(this.sb) != 0) {
                this.sb.append(" ");
            }
            switch (KtPsiFactory$CallableBuilder$WhenMappings.$EnumSwitchMapping$0[this.target.ordinal()]) {
                case 1: {
                    string = "fun";
                    break;
                }
                case 2: {
                    string = "val";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String keyword = string;
            this.sb.append(keyword + " ");
            this.state = State.RECEIVER;
        }

        private final String bodyPrefix() {
            String string;
            switch (KtPsiFactory$CallableBuilder$WhenMappings.$EnumSwitchMapping$1[this.target.ordinal()]) {
                case 1: {
                    string = "";
                    break;
                }
                case 2: {
                    string = "\nget()";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        @NotNull
        public final CallableBuilder modifier(@NotNull String modifier) {
            Intrinsics.checkParameterIsNotNull(modifier, "modifier");
            PreconditionsKt.assert(Intrinsics.areEqual((Object)this.state, (Object)State.MODIFIERS));
            this.sb.append(modifier);
            return this;
        }

        @NotNull
        public final CallableBuilder typeParams(@NotNull Collection<? extends String> values) {
            Intrinsics.checkParameterIsNotNull(values, "values");
            this.placeKeyword();
            if (!values.isEmpty()) {
                this.sb.append(CollectionsKt.joinToString$default((Iterable)values, (CharSequence)", ", (CharSequence)"<", (CharSequence)"> ", -1, (CharSequence)"", null, 32));
            }
            return this;
        }

        @NotNull
        public final CallableBuilder receiver(@NotNull String receiverType) {
            Intrinsics.checkParameterIsNotNull(receiverType, "receiverType");
            PreconditionsKt.assert(Intrinsics.areEqual((Object)this.state, (Object)State.RECEIVER));
            this.sb.append(receiverType).append(".");
            this.state = State.NAME;
            return this;
        }

        @NotNull
        public final CallableBuilder name(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            PreconditionsKt.assert(Intrinsics.areEqual((Object)this.state, (Object)State.NAME) || Intrinsics.areEqual((Object)this.state, (Object)State.RECEIVER));
            this.sb.append(name);
            switch (KtPsiFactory$CallableBuilder$WhenMappings.$EnumSwitchMapping$2[this.target.ordinal()]) {
                case 1: {
                    this.sb.append("(");
                    this.state = State.FIRST_PARAM;
                    break;
                }
                default: {
                    this.state = State.TYPE_CONSTRAINTS;
                }
            }
            return this;
        }

        @NotNull
        public final CallableBuilder param(@NotNull String name, @NotNull String type2) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(type2, "type");
            PreconditionsKt.assert(Intrinsics.areEqual((Object)this.target, (Object)Target.FUNCTION));
            PreconditionsKt.assert(Intrinsics.areEqual((Object)this.state, (Object)State.FIRST_PARAM) || Intrinsics.areEqual((Object)this.state, (Object)State.REST_PARAMS));
            if (Intrinsics.areEqual((Object)this.state, (Object)State.REST_PARAMS)) {
                this.sb.append(", ");
            }
            this.sb.append(name).append(": ").append(type2);
            if (Intrinsics.areEqual((Object)this.state, (Object)State.FIRST_PARAM)) {
                this.state = State.REST_PARAMS;
            }
            return this;
        }

        @NotNull
        public final CallableBuilder returnType(@NotNull String type2) {
            Intrinsics.checkParameterIsNotNull(type2, "type");
            this.closeParams();
            this.sb.append(": ").append(type2);
            return this;
        }

        @NotNull
        public final CallableBuilder noReturnType() {
            this.closeParams();
            return this;
        }

        @NotNull
        public final CallableBuilder typeConstraints(@NotNull Collection<? extends String> values) {
            Intrinsics.checkParameterIsNotNull(values, "values");
            PreconditionsKt.assert(Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_CONSTRAINTS));
            if (!values.isEmpty()) {
                this.sb.append(CollectionsKt.joinToString$default((Iterable)values, (CharSequence)", ", (CharSequence)" where ", (CharSequence)"", -1, (CharSequence)"", null, 32));
            }
            this.state = State.BODY;
            return this;
        }

        @NotNull
        public final CallableBuilder blockBody(@NotNull String body) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            PreconditionsKt.assert(Intrinsics.areEqual((Object)this.state, (Object)State.BODY) || Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_CONSTRAINTS));
            this.sb.append(this.bodyPrefix()).append(" {\n").append(body).append("\n}");
            this.state = State.DONE;
            return this;
        }

        @NotNull
        public final CallableBuilder initializer(@NotNull String body) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            PreconditionsKt.assert(Intrinsics.areEqual((Object)this.target, (Object)Target.READ_ONLY_PROPERTY) && (Intrinsics.areEqual((Object)this.state, (Object)State.BODY) || Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_CONSTRAINTS)));
            this.sb.append(" = ").append(body);
            this.state = State.DONE;
            return this;
        }

        @NotNull
        public final CallableBuilder lazyBody(@NotNull String body) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            PreconditionsKt.assert(Intrinsics.areEqual((Object)this.target, (Object)Target.READ_ONLY_PROPERTY) && (Intrinsics.areEqual((Object)this.state, (Object)State.BODY) || Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_CONSTRAINTS)));
            this.sb.append(" by kotlin.lazy {\n").append(body).append("\n}");
            this.state = State.DONE;
            return this;
        }

        @NotNull
        public final String asString() {
            if (Intrinsics.areEqual((Object)this.state, (Object)State.DONE) ^ true) {
                this.state = State.DONE;
            }
            String string = this.sb.toString();
            Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
            return string;
        }

        public CallableBuilder(@NotNull Target target) {
            Intrinsics.checkParameterIsNotNull((Object)target, "target");
            this.target = target;
            this.sb = new StringBuilder();
            this.state = State.MODIFIERS;
        }

        @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\r\u0015\tA\"A\u0003\u0002\u0011!)\u0011\u0001b\u0001\u0005\u0007\u0004a\u0001!\u0007\u0003\n\u0005%\t\u0001\u0004\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005\t\u00141\u0001\u0002"}, strings={"Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder$Target;", "", "(Ljava/lang/String;I)V", "FUNCTION", "READ_ONLY_PROPERTY"}, moduleName="kotlin-compiler")
        public static final class Target
        extends Enum<Target> {
            public static final /* enum */ Target FUNCTION;
            public static final /* enum */ Target READ_ONLY_PROPERTY;
            private static final /* synthetic */ Target[] $VALUES;

            static {
                Target[] targetArray = new Target[2];
                Target[] targetArray2 = targetArray;
                targetArray[0] = FUNCTION = new Target();
                targetArray[1] = READ_ONLY_PROPERTY = new Target();
                $VALUES = targetArray;
            }

            public static Target[] values() {
                return (Target[])$VALUES.clone();
            }

            public static Target valueOf(String string) {
                return Enum.valueOf(Target.class, string);
            }
        }

        @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\r\u0015\tA\"A\u0003\u0002\u0011!)\u0011\u0001\"\u0003\u0005\u0007\u0004a\u0001!\u0007\u0003\n\u0005%\t\u0001\u0004\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005\tD1\u0001B\u0003\u0007\u000f!I!\u0002"}, strings={"Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder$State;", "", "(Ljava/lang/String;I)V", "MODIFIERS", "NAME", "RECEIVER", "FIRST_PARAM", "REST_PARAMS", "TYPE_CONSTRAINTS", "BODY", "DONE"}, moduleName="kotlin-compiler")
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State MODIFIERS;
            public static final /* enum */ State NAME;
            public static final /* enum */ State RECEIVER;
            public static final /* enum */ State FIRST_PARAM;
            public static final /* enum */ State REST_PARAMS;
            public static final /* enum */ State TYPE_CONSTRAINTS;
            public static final /* enum */ State BODY;
            public static final /* enum */ State DONE;
            private static final /* synthetic */ State[] $VALUES;

            static {
                State[] stateArray = new State[8];
                State[] stateArray2 = stateArray;
                stateArray[0] = MODIFIERS = new State();
                stateArray[1] = NAME = new State();
                stateArray[2] = RECEIVER = new State();
                stateArray[3] = FIRST_PARAM = new State();
                stateArray[4] = REST_PARAMS = new State();
                stateArray[5] = TYPE_CONSTRAINTS = new State();
                stateArray[6] = BODY = new State();
                stateArray[7] = DONE = new State();
                $VALUES = stateArray;
            }

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String string) {
                return Enum.valueOf(State.class, string);
            }
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001d\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t!\u0011\tA\u0002A\r\u00021\u0003I\u0012\u0001G\u0001\"\u0016%\u0019\u00012A\u0007\u00021\u0003I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011kA\u0001\t\u0007\u0015\"Aa\u0003E\u0004\u001b\u0005A*!J\u0004\u0005\u0017!!Q\u0002B\u0005\u0003\u0013\u0005A*\u0001'\u0003*\u000f\u0011\t\u0005\u0002\u0003\u0002\u000e\u0003a\u0015\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/psi/KtPsiFactory$BlockWrapper;", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "Lorg/jetbrains/kotlin/psi/KtPsiUtil$KtExpressionWrapper;", "fakeBlockExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/psi/KtBlockExpression;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "getBaseExpression", "getStatements", ""}, moduleName="kotlin-compiler")
    private static final class BlockWrapper
    extends KtBlockExpression
    implements KtPsiUtil.KtExpressionWrapper {
        private final KtExpression expression;

        @Override
        @NotNull
        public List<KtExpression> getStatements() {
            return CollectionsKt.listOf(this.expression);
        }

        @Override
        @NotNull
        public KtExpression getBaseExpression() {
            return this.expression;
        }

        public BlockWrapper(@NotNull KtBlockExpression fakeBlockExpression, @NotNull KtExpression expression) {
            Intrinsics.checkParameterIsNotNull(fakeBlockExpression, "fakeBlockExpression");
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            super(fakeBlockExpression.getNode());
            this.expression = expression;
        }
    }
}

