/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.kotlinSignature;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.components.TypeUsage;
import org.jetbrains.kotlin.load.java.structure.JavaMember;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JavaDescriptorResolverKt;
import org.jetbrains.kotlin.resolve.jvm.JavaResolverUtils;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.AlternativeSignatureMismatchException;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.ElementAlternativeSignatureData;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.SignaturesUtil;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.TypeTransformingVisitor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class AlternativeMethodSignatureData
extends ElementAlternativeSignatureData {
    private final KtNamedFunction altFunDeclaration;
    private List<ValueParameterDescriptor> altValueParameters;
    private KotlinType altReturnType;
    private List<TypeParameterDescriptor> altTypeParameters;
    private Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters;

    public AlternativeMethodSignatureData(@NotNull JavaMember methodOrConstructor, @Nullable KotlinType receiverType, @NotNull Project project, @NotNull List<ValueParameterDescriptor> valueParameters, @Nullable KotlinType originalReturnType, @NotNull List<TypeParameterDescriptor> methodTypeParameters, boolean hasSuperMethods) {
        if (methodOrConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodOrConstructor", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeMethodSignatureData", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeMethodSignatureData", "<init>"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeMethodSignatureData", "<init>"));
        }
        if (methodTypeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodTypeParameters", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeMethodSignatureData", "<init>"));
        }
        String signature = SignaturesUtil.getKotlinSignature(methodOrConstructor);
        if (signature == null) {
            this.setAnnotated(false);
            this.altFunDeclaration = null;
            return;
        }
        if (receiverType != null) {
            throw new UnsupportedOperationException("Alternative annotations for extension functions are not supported yet");
        }
        this.setAnnotated(true);
        this.altFunDeclaration = KtPsiFactoryKt.KtPsiFactory(project).createFunction(signature);
        this.originalToAltTypeParameters = JavaResolverUtils.recreateTypeParametersAndReturnMapping(methodTypeParameters, null);
        try {
            AlternativeMethodSignatureData.checkForSyntaxErrors(this.altFunDeclaration);
            AlternativeMethodSignatureData.checkEqualFunctionNames(this.altFunDeclaration, methodOrConstructor);
            this.computeTypeParameters(methodTypeParameters);
            this.computeValueParameters(valueParameters);
            if (originalReturnType != null) {
                this.altReturnType = AlternativeMethodSignatureData.computeReturnType(originalReturnType, this.altFunDeclaration.getTypeReference(), this.originalToAltTypeParameters);
            }
            if (hasSuperMethods) {
                this.checkParameterAndReturnTypesForOverridingMethods(valueParameters, methodTypeParameters, originalReturnType);
            }
        }
        catch (AlternativeSignatureMismatchException e) {
            this.setError(e.getMessage());
        }
    }

    public static List<ValueParameterDescriptor> updateNames(List<ValueParameterDescriptor> originalValueParameters, List<ValueParameterDescriptor> altValueParameters) {
        ArrayList<ValueParameterDescriptor> result2 = new ArrayList<ValueParameterDescriptor>(originalValueParameters.size());
        for (int i = 0; i < originalValueParameters.size(); ++i) {
            ValueParameterDescriptor originalValueParameter = originalValueParameters.get(i);
            ValueParameterDescriptor altValueParameter = altValueParameters.get(i);
            result2.add(originalValueParameter.copy(originalValueParameter.getContainingDeclaration(), altValueParameter.getName()));
        }
        return result2;
    }

    private void checkParameterAndReturnTypesForOverridingMethods(@NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> methodTypeParameters, @Nullable KotlinType returnType2) {
        KotlinType substituted;
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeMethodSignatureData", "checkParameterAndReturnTypesForOverridingMethods"));
        }
        if (methodTypeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodTypeParameters", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeMethodSignatureData", "checkParameterAndReturnTypesForOverridingMethods"));
        }
        if (JavaDescriptorResolverKt.getPLATFORM_TYPES()) {
            return;
        }
        TypeSubstitutor substitutor2 = JavaResolverUtils.createSubstitutorForTypeParameters(this.originalToAltTypeParameters);
        for (ValueParameterDescriptor valueParameterDescriptor : valueParameters) {
            int index2 = valueParameterDescriptor.getIndex();
            ValueParameterDescriptor altParameter = this.altValueParameters.get(index2);
            substituted = substitutor2.substitute(valueParameterDescriptor.getType(), Variance.INVARIANT);
            assert (substituted != null);
            if (TypeUtils.equalTypes(substituted, altParameter.getType())) continue;
            throw new AlternativeSignatureMismatchException("Parameter type changed for method which overrides another: " + altParameter.getType() + ", was: " + valueParameterDescriptor.getType());
        }
        for (TypeParameterDescriptor typeParameterDescriptor : methodTypeParameters) {
            int index2 = typeParameterDescriptor.getIndex();
            KotlinType upperBoundsAsType = TypeIntersector.getUpperBoundsAsType(typeParameterDescriptor);
            substituted = substitutor2.substitute(upperBoundsAsType, Variance.INVARIANT);
            assert (substituted != null);
            KotlinType altUpperBoundsAsType = TypeIntersector.getUpperBoundsAsType(this.altTypeParameters.get(index2));
            if (TypeUtils.equalTypes(substituted, altUpperBoundsAsType)) continue;
            throw new AlternativeSignatureMismatchException("Type parameter's upper bound changed for method which overrides another: " + altUpperBoundsAsType + ", was: " + upperBoundsAsType);
        }
        if (returnType2 != null) {
            KotlinType substitutedReturnType = substitutor2.substitute(returnType2, Variance.INVARIANT);
            assert (substitutedReturnType != null);
            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(this.altReturnType, substitutedReturnType)) {
                throw new AlternativeSignatureMismatchException("Return type is changed to not subtype for method which overrides another: " + this.altReturnType + ", was: " + returnType2);
            }
        }
    }

    @NotNull
    public List<ValueParameterDescriptor> getValueParameters() {
        this.checkForErrors();
        List<ValueParameterDescriptor> list = this.altValueParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeMethodSignatureData", "getValueParameters"));
        }
        return list;
    }

    @Nullable
    public KotlinType getReturnType() {
        this.checkForErrors();
        return this.altReturnType;
    }

    @NotNull
    public List<TypeParameterDescriptor> getTypeParameters() {
        this.checkForErrors();
        List<TypeParameterDescriptor> list = this.altTypeParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeMethodSignatureData", "getTypeParameters"));
        }
        return list;
    }

    private void computeValueParameters(@NotNull List<ValueParameterDescriptor> parameterDescriptors) {
        if (parameterDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterDescriptors", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeMethodSignatureData", "computeValueParameters"));
        }
        if (parameterDescriptors.size() != this.altFunDeclaration.getValueParameters().size()) {
            throw new AlternativeSignatureMismatchException("Method signature has %d value parameters, but alternative signature has %d", parameterDescriptors.size(), this.altFunDeclaration.getValueParameters().size());
        }
        ArrayList<ValueParameterDescriptor> altParamDescriptors = new ArrayList<ValueParameterDescriptor>(parameterDescriptors.size());
        for (int i = 0; i < parameterDescriptors.size(); ++i) {
            KotlinType alternativeVarargElementType;
            KotlinType alternativeType;
            ValueParameterDescriptor originalParameterDescriptor = parameterDescriptors.get(i);
            KtParameter annotationValueParameter = this.altFunDeclaration.getValueParameters().get(i);
            KtTypeElement alternativeTypeElement = annotationValueParameter.getTypeReference().getTypeElement();
            assert (alternativeTypeElement != null);
            KotlinType originalParamVarargElementType = originalParameterDescriptor.getVarargElementType();
            if (originalParamVarargElementType == null) {
                if (annotationValueParameter.isVarArg()) {
                    throw new AlternativeSignatureMismatchException("Parameter in method signature is not vararg, but in alternative signature it is vararg");
                }
                alternativeType = TypeTransformingVisitor.computeType(alternativeTypeElement, originalParameterDescriptor.getType(), this.originalToAltTypeParameters, TypeUsage.MEMBER_SIGNATURE_CONTRAVARIANT);
                alternativeVarargElementType = null;
            } else {
                if (!annotationValueParameter.isVarArg()) {
                    throw new AlternativeSignatureMismatchException("Parameter in method signature is vararg, but in alternative signature it is not");
                }
                alternativeVarargElementType = TypeTransformingVisitor.computeType(alternativeTypeElement, originalParamVarargElementType, this.originalToAltTypeParameters, TypeUsage.MEMBER_SIGNATURE_CONTRAVARIANT);
                alternativeType = DescriptorUtilsKt.getBuiltIns(originalParameterDescriptor).getArrayType(Variance.OUT_VARIANCE, alternativeVarargElementType);
            }
            Name altName = annotationValueParameter.getNameAsName();
            altParamDescriptors.add(new ValueParameterDescriptorImpl(originalParameterDescriptor.getContainingDeclaration(), null, originalParameterDescriptor.getIndex(), originalParameterDescriptor.getAnnotations(), altName != null ? altName : originalParameterDescriptor.getName(), alternativeType, originalParameterDescriptor.declaresDefaultValue(), originalParameterDescriptor.isCrossinline(), originalParameterDescriptor.isNoinline(), alternativeVarargElementType, SourceElement.NO_SOURCE));
        }
        this.altValueParameters = altParamDescriptors;
    }

    private void computeTypeParameters(List<TypeParameterDescriptor> typeParameters) {
        if (typeParameters.size() != this.altFunDeclaration.getTypeParameters().size()) {
            throw new AlternativeSignatureMismatchException("Method signature has %d type parameters, but alternative signature has %d", typeParameters.size(), this.altFunDeclaration.getTypeParameters().size());
        }
        this.altTypeParameters = new ArrayList<TypeParameterDescriptor>(typeParameters.size());
        for (int i = 0; i < typeParameters.size(); ++i) {
            TypeParameterDescriptor originalTypeParamDescriptor = typeParameters.get(i);
            TypeParameterDescriptorImpl altParamDescriptor = this.originalToAltTypeParameters.get(originalTypeParamDescriptor);
            KtTypeParameter altTypeParameter = this.altFunDeclaration.getTypeParameters().get(i);
            List<KotlinType> originalUpperBounds = originalTypeParamDescriptor.getUpperBounds();
            List<KtTypeReference> altUpperBounds = AlternativeMethodSignatureData.getUpperBounds(this.altFunDeclaration, altTypeParameter);
            if (!(altUpperBounds.size() == originalUpperBounds.size() || altUpperBounds.isEmpty() && originalUpperBounds.size() == 1 && TypeUtilsKt.isDefaultBound(originalUpperBounds.iterator().next()))) {
                throw new AlternativeSignatureMismatchException("Upper bound number mismatch for %s. Expected %d, but found %d", originalTypeParamDescriptor.getName(), originalUpperBounds.size(), altUpperBounds.size());
            }
            if (altUpperBounds.isEmpty()) {
                altParamDescriptor.addDefaultUpperBound();
            } else {
                int upperBoundIndex = 0;
                for (KotlinType upperBound : originalUpperBounds) {
                    KtTypeElement altTypeElement = altUpperBounds.get(upperBoundIndex).getTypeElement();
                    assert (altTypeElement != null);
                    altParamDescriptor.addUpperBound(TypeTransformingVisitor.computeType(altTypeElement, upperBound, this.originalToAltTypeParameters, TypeUsage.UPPER_BOUND));
                    ++upperBoundIndex;
                }
            }
            altParamDescriptor.setInitialized();
            this.altTypeParameters.add(altParamDescriptor);
        }
    }

    @NotNull
    private static List<KtTypeReference> getUpperBounds(@NotNull KtFunction function, @NotNull KtTypeParameter jetTypeParameter) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeMethodSignatureData", "getUpperBounds"));
        }
        if (jetTypeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetTypeParameter", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeMethodSignatureData", "getUpperBounds"));
        }
        ArrayList<KtTypeReference> result2 = new ArrayList<KtTypeReference>();
        ContainerUtil.addIfNotNull(result2, jetTypeParameter.getExtendsBound());
        Name name = jetTypeParameter.getNameAsName();
        if (name == null) {
            ArrayList<KtTypeReference> arrayList = result2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeMethodSignatureData", "getUpperBounds"));
            }
            return arrayList;
        }
        for (KtTypeConstraint constraint : function.getTypeConstraints()) {
            KtSimpleNameExpression parameterName = constraint.getSubjectTypeParameterName();
            assert (parameterName != null) : "No parameter name in constraint " + constraint.getText();
            if (!name.equals(parameterName.getReferencedNameAsName())) continue;
            result2.add(constraint.getBoundTypeReference());
        }
        ArrayList<KtTypeReference> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeMethodSignatureData", "getUpperBounds"));
        }
        return arrayList;
    }

    private static void checkEqualFunctionNames(@NotNull PsiNamedElement namedElement, @NotNull JavaMember methodOrConstructor) {
        if (namedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedElement", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeMethodSignatureData", "checkEqualFunctionNames"));
        }
        if (methodOrConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodOrConstructor", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeMethodSignatureData", "checkEqualFunctionNames"));
        }
        if (!ComparatorUtil.equalsNullable(methodOrConstructor.getName().asString(), namedElement.getName())) {
            throw new AlternativeSignatureMismatchException("Function names mismatch, original: %s, alternative: %s", methodOrConstructor.getName().asString(), namedElement.getName());
        }
    }
}

