/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LoggerRt {
    private static Factory ourFactory;

    private static synchronized Factory getFactory() {
        if (ourFactory == null) {
            try {
                ourFactory = new IdeaFactory();
            }
            catch (Throwable t) {
                ourFactory = new JavaFactory();
            }
        }
        return ourFactory;
    }

    @NotNull
    public static LoggerRt getInstance(@NotNull @NonNls String category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/openapi/diagnostic/LoggerRt", "getInstance"));
        }
        LoggerRt loggerRt = LoggerRt.getFactory().getInstance(category);
        if (loggerRt == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diagnostic/LoggerRt", "getInstance"));
        }
        return loggerRt;
    }

    public void info(@Nullable @NonNls String message) {
        this.info(message, null);
    }

    public void info(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/diagnostic/LoggerRt", "info"));
        }
        this.info(t.getMessage(), t);
    }

    public void warn(@Nullable @NonNls String message) {
        this.warn(message, null);
    }

    public void warn(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/diagnostic/LoggerRt", "warn"));
        }
        this.warn(t.getMessage(), t);
    }

    public void error(@Nullable @NonNls String message) {
        this.error(message, null);
    }

    public void error(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/diagnostic/LoggerRt", "error"));
        }
        this.error(t.getMessage(), t);
    }

    public abstract void info(@Nullable @NonNls String var1, @Nullable Throwable var2);

    public abstract void warn(@Nullable @NonNls String var1, @Nullable Throwable var2);

    public abstract void error(@Nullable @NonNls String var1, @Nullable Throwable var2);

    private static class IdeaFactory
    implements Factory {
        private final Method myGetInstance;
        private final Method myInfo;
        private final Method myWarn;
        private final Method myError;

        private IdeaFactory() throws Exception {
            Class<?> loggerClass = Class.forName("com.intellij.openapi.diagnostic.Logger");
            this.myGetInstance = loggerClass.getMethod("getInstance", String.class);
            this.myGetInstance.setAccessible(true);
            this.myInfo = loggerClass.getMethod("info", String.class, Throwable.class);
            this.myInfo.setAccessible(true);
            this.myWarn = loggerClass.getMethod("warn", String.class, Throwable.class);
            this.myInfo.setAccessible(true);
            this.myError = loggerClass.getMethod("error", String.class, Throwable.class);
            this.myError.setAccessible(true);
        }

        @Override
        public LoggerRt getInstance(@NotNull @NonNls String category) {
            if (category == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/openapi/diagnostic/LoggerRt$IdeaFactory", "getInstance"));
            }
            try {
                final Object logger = this.myGetInstance.invoke(null, category);
                return new LoggerRt(){

                    @Override
                    public void info(@Nullable @NonNls String message, @Nullable Throwable t) {
                        try {
                            IdeaFactory.this.myInfo.invoke(logger, message, t);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void warn(@Nullable @NonNls String message, @Nullable Throwable t) {
                        try {
                            IdeaFactory.this.myWarn.invoke(logger, message, t);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void error(@Nullable @NonNls String message, @Nullable Throwable t) {
                        try {
                            IdeaFactory.this.myError.invoke(logger, message, t);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class JavaFactory
    implements Factory {
        private JavaFactory() {
        }

        @Override
        public LoggerRt getInstance(@NotNull @NonNls String category) {
            if (category == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/openapi/diagnostic/LoggerRt$JavaFactory", "getInstance"));
            }
            final Logger logger = Logger.getLogger(category);
            return new LoggerRt(){

                @Override
                public void info(@Nullable @NonNls String message, @Nullable Throwable t) {
                    logger.log(Level.INFO, message, t);
                }

                @Override
                public void warn(@Nullable @NonNls String message, @Nullable Throwable t) {
                    logger.log(Level.WARNING, message, t);
                }

                @Override
                public void error(@Nullable @NonNls String message, @Nullable Throwable t) {
                    logger.log(Level.SEVERE, message, t);
                }
            };
        }
    }

    private static interface Factory {
        public LoggerRt getInstance(@NotNull @NonNls String var1);
    }
}

