/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.tools.idea.editors.theme.ProjectThemeResolver;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleListCellRenderer
extends JPanel
implements ListCellRenderer {
    private final ThemeEditorContext myContext;
    private final SimpleColoredComponent myStyleNameLabel = new SimpleColoredComponent();
    private final SimpleColoredComponent myDefaultLabel = new SimpleColoredComponent();

    public StyleListCellRenderer(ThemeEditorContext context) {
        this.myContext = context;
        this.setLayout(new BoxLayout(this, 2));
        this.myStyleNameLabel.setAlignmentX(0.0f);
        this.myDefaultLabel.setAlignmentX(1.0f);
        this.myDefaultLabel.append("DEFAULT", SimpleTextAttributes.GRAY_ATTRIBUTES);
        this.myDefaultLabel.setTextAlign(4);
        this.add((Component)this.myStyleNameLabel);
        this.add(Box.createHorizontalGlue());
        this.add((Component)this.myDefaultLabel);
    }

    @Nullable
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Manifest manifest;
        if (value instanceof JSeparator) {
            return (JSeparator)value;
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.myStyleNameLabel.setForeground(list.getSelectionForeground());
            this.myDefaultLabel.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.myStyleNameLabel.setForeground(list.getForeground());
            this.myDefaultLabel.setForeground(list.getForeground());
        }
        this.myStyleNameLabel.clear();
        if (value instanceof String) {
            this.myStyleNameLabel.append((String)value);
            this.myDefaultLabel.setVisible(false);
            return this;
        }
        if (value instanceof ProjectThemeResolver.ThemeWithSource) {
            value = ((ProjectThemeResolver.ThemeWithSource)value).getTheme();
        }
        if (!(value instanceof ThemeEditorStyle)) {
            return null;
        }
        ThemeEditorStyle style = (ThemeEditorStyle)value;
        ThemeEditorStyle parent = style.getParent();
        String styleName = style.getSimpleName();
        String parentName = parent != null ? parent.getSimpleName() : null;
        String defaultAppTheme = null;
        AndroidFacet facet = AndroidFacet.getInstance(this.myContext.getCurrentThemeModule());
        if (facet != null && (manifest = facet.getManifest()) != null && manifest.getApplication() != null && manifest.getApplication().getXmlTag() != null) {
            defaultAppTheme = manifest.getApplication().getXmlTag().getAttributeValue("theme", "http://schemas.android.com/apk/res/android");
        }
        if (!style.isProjectStyle()) {
            String simplifiedName = StyleListCellRenderer.simplifyName(style);
            if (StringUtil.isEmpty((String)simplifiedName)) {
                this.myStyleNameLabel.append(styleName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else {
                this.myStyleNameLabel.append(simplifiedName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.myStyleNameLabel.append(" [" + styleName + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        } else if (!isSelected && parentName != null && styleName.startsWith(parentName + ".")) {
            this.myStyleNameLabel.append(parentName + ".", SimpleTextAttributes.GRAY_ATTRIBUTES);
            this.myStyleNameLabel.append(styleName.substring(parentName.length() + 1), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else {
            this.myStyleNameLabel.append(styleName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        this.myDefaultLabel.setVisible(style.getName().equals(defaultAppTheme));
        return this;
    }

    @NotNull
    private static String simplifyName(@NotNull ThemeEditorStyle theme) {
        if (theme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "theme", "com/android/tools/idea/editors/theme/attributes/editors/StyleListCellRenderer", "simplifyName"));
        }
        String name = theme.getName();
        String[] pieces = name.split("\\.");
        String result = pieces.length > 1 && !"Light".equals(pieces[1]) ? pieces[1] : "Theme";
        for (ThemeEditorStyle parent = theme; parent != null; parent = parent.getParent()) {
            if (!"Theme.Light".equals(parent.getSimpleName())) continue;
            String string = result + " Light";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/attributes/editors/StyleListCellRenderer", "simplifyName"));
            }
            return string;
        }
        String string = result + " Dark";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/attributes/editors/StyleListCellRenderer", "simplifyName"));
        }
        return string;
    }
}

