/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.JavaCompileOptions;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.Variant;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.customizer.android.ContentRootModuleCustomizer;
import com.android.tools.idea.gradle.util.ProxyUtil;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaAndroidProject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getInstance(IdeaAndroidProject.class);
    @NotNull
    private ProjectSystemId myProjectSystemId;
    @NotNull
    private String myModuleName;
    @NotNull
    private File myRootDirPath;
    @NotNull
    private AndroidProject myDelegate;
    @Nullable
    private transient CountDownLatch myProxyDelegateLatch;
    @Nullable
    private AndroidProject myProxyDelegate;
    @NotNull
    private String mySelectedVariantName;
    private transient VirtualFile myRootDir;
    @NotNull
    private String mySelectedTestArtifactName;
    @Nullable
    private Boolean myOverridesManifestPackage;
    @Nullable
    private transient AndroidVersion myMinSdkVersion;
    @NotNull
    private Map<String, BuildTypeContainer> myBuildTypesByName;
    @NotNull
    private Map<String, ProductFlavorContainer> myProductFlavorsByName;
    @NotNull
    private Map<String, Variant> myVariantsByName;
    @NotNull
    private Set<File> myExtraGeneratedSourceFolders;
    private static final AndroidVersion NOT_SPECIFIED = new AndroidVersion(0, null);

    public IdeaAndroidProject(@NotNull ProjectSystemId projectSystemId, @NotNull String moduleName, @NotNull File rootDirPath, @NotNull AndroidProject delegate, @NotNull String selectedVariantName, @NotNull String selectedTestArtifactName) {
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/android/tools/idea/gradle/IdeaAndroidProject", "<init>"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/IdeaAndroidProject", "<init>"));
        }
        if (rootDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDirPath", "com/android/tools/idea/gradle/IdeaAndroidProject", "<init>"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/android/tools/idea/gradle/IdeaAndroidProject", "<init>"));
        }
        if (selectedVariantName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedVariantName", "com/android/tools/idea/gradle/IdeaAndroidProject", "<init>"));
        }
        if (selectedTestArtifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedTestArtifactName", "com/android/tools/idea/gradle/IdeaAndroidProject", "<init>"));
        }
        this.myBuildTypesByName = Maps.newHashMap();
        this.myProductFlavorsByName = Maps.newHashMap();
        this.myVariantsByName = Maps.newHashMap();
        this.myExtraGeneratedSourceFolders = Sets.newHashSet();
        this.myProjectSystemId = projectSystemId;
        this.myModuleName = moduleName;
        this.myRootDirPath = rootDirPath;
        this.myDelegate = delegate;
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                IdeaAndroidProject.this.myProxyDelegateLatch = new CountDownLatch(1);
                IdeaAndroidProject.this.myProxyDelegate = ProxyUtil.reproxy(AndroidProject.class, IdeaAndroidProject.this.myDelegate);
                IdeaAndroidProject.this.myProxyDelegateLatch.countDown();
            }
        });
        this.populateBuildTypesByName();
        this.populateProductFlavorsByName();
        this.populateVariantsByName();
        this.setSelectedVariantName(selectedVariantName);
        this.setSelectedTestArtifactName(selectedTestArtifactName);
    }

    private void populateBuildTypesByName() {
        for (BuildTypeContainer container : this.myDelegate.getBuildTypes()) {
            String name = container.getBuildType().getName();
            this.myBuildTypesByName.put(name, container);
        }
    }

    private void populateProductFlavorsByName() {
        for (ProductFlavorContainer container : this.myDelegate.getProductFlavors()) {
            String name = container.getProductFlavor().getName();
            this.myProductFlavorsByName.put(name, container);
        }
    }

    private void populateVariantsByName() {
        for (Variant variant : this.myDelegate.getVariants()) {
            this.myVariantsByName.put(variant.getName(), variant);
        }
    }

    @NotNull
    public ProjectSystemId getProjectSystemId() {
        ProjectSystemId projectSystemId = this.myProjectSystemId;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaAndroidProject", "getProjectSystemId"));
        }
        return projectSystemId;
    }

    @Nullable
    public BuildTypeContainer findBuildType(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/IdeaAndroidProject", "findBuildType"));
        }
        return this.myBuildTypesByName.get(name);
    }

    @NotNull
    public Set<String> getBuildTypes() {
        Set<String> set = this.myBuildTypesByName.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaAndroidProject", "getBuildTypes"));
        }
        return set;
    }

    @NotNull
    public Set<String> getProductFlavors() {
        Set<String> set = this.myProductFlavorsByName.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaAndroidProject", "getProductFlavors"));
        }
        return set;
    }

    @Nullable
    public ProductFlavorContainer findProductFlavor(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/IdeaAndroidProject", "findProductFlavor"));
        }
        return this.myProductFlavorsByName.get(name);
    }

    @Nullable
    public BaseArtifact findSelectedTestArtifact(@NotNull Variant variant) {
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/IdeaAndroidProject", "findSelectedTestArtifact"));
        }
        BaseArtifact artifact = this.getBaseArtifact(variant.getExtraAndroidArtifacts());
        if (artifact != null) {
            return artifact;
        }
        return this.getBaseArtifact(variant.getExtraJavaArtifacts());
    }

    @Nullable
    private BaseArtifact getBaseArtifact(@NotNull Iterable<? extends BaseArtifact> artifacts) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/android/tools/idea/gradle/IdeaAndroidProject", "getBaseArtifact"));
        }
        for (BaseArtifact baseArtifact : artifacts) {
            if (!this.getSelectedTestArtifactName().equals(baseArtifact.getName())) continue;
            return baseArtifact;
        }
        return null;
    }

    @Nullable
    public BaseArtifact findSelectedTestArtifactInSelectedVariant() {
        return this.findSelectedTestArtifact(this.getSelectedVariant());
    }

    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaAndroidProject", "getModuleName"));
        }
        return string;
    }

    @NotNull
    public File getRootDirPath() {
        File file = this.myRootDirPath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaAndroidProject", "getRootDirPath"));
        }
        return file;
    }

    @NotNull
    public VirtualFile getRootDir() {
        if (this.myRootDir == null) {
            VirtualFile found = VfsUtil.findFileByIoFile((File)this.myRootDirPath, (boolean)true);
            assert (found != null);
            this.myRootDir = found;
        }
        VirtualFile virtualFile = this.myRootDir;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaAndroidProject", "getRootDir"));
        }
        return virtualFile;
    }

    @NotNull
    public AndroidProject getDelegate() {
        AndroidProject androidProject = this.myDelegate;
        if (androidProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaAndroidProject", "getDelegate"));
        }
        return androidProject;
    }

    @NotNull
    public Variant getSelectedVariant() {
        Variant selected = this.myVariantsByName.get(this.mySelectedVariantName);
        assert (selected != null);
        Variant variant = selected;
        if (variant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaAndroidProject", "getSelectedVariant"));
        }
        return variant;
    }

    public void setSelectedVariantName(@NotNull String name) {
        String newVariantName;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/IdeaAndroidProject", "setSelectedVariantName"));
        }
        Collection<String> variantNames = this.getVariantNames();
        if (variantNames.contains(name)) {
            newVariantName = name;
        } else {
            ArrayList sorted = Lists.newArrayList(variantNames);
            Collections.sort(sorted);
            newVariantName = (String)sorted.get(0);
        }
        this.mySelectedVariantName = newVariantName;
        this.myOverridesManifestPackage = null;
        this.myMinSdkVersion = null;
    }

    public void setSelectedTestArtifactName(@NotNull String selectedTestArtifactName) {
        if (selectedTestArtifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedTestArtifactName", "com/android/tools/idea/gradle/IdeaAndroidProject", "setSelectedTestArtifactName"));
        }
        assert (selectedTestArtifactName.equals("_android_test_") || selectedTestArtifactName.equals("_unit_test_"));
        this.mySelectedTestArtifactName = selectedTestArtifactName;
    }

    @NotNull
    public String getSelectedTestArtifactName() {
        String string = this.mySelectedTestArtifactName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaAndroidProject", "getSelectedTestArtifactName"));
        }
        return string;
    }

    @NotNull
    public Collection<SourceProvider> getSourceProvidersForSelectedTestArtifact(@NotNull Iterable<SourceProviderContainer> containers) {
        if (containers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containers", "com/android/tools/idea/gradle/IdeaAndroidProject", "getSourceProvidersForSelectedTestArtifact"));
        }
        HashSet providers = Sets.newHashSet();
        for (SourceProviderContainer container : containers) {
            if (!this.mySelectedTestArtifactName.equals(container.getArtifactName())) continue;
            providers.add(container.getSourceProvider());
        }
        HashSet hashSet = providers;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaAndroidProject", "getSourceProvidersForSelectedTestArtifact"));
        }
        return hashSet;
    }

    @NotNull
    public Collection<String> getBuildTypeNames() {
        Set<String> set = this.myBuildTypesByName.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaAndroidProject", "getBuildTypeNames"));
        }
        return set;
    }

    @NotNull
    public Collection<String> getProductFlavorNames() {
        Set<String> set = this.myProductFlavorsByName.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaAndroidProject", "getProductFlavorNames"));
        }
        return set;
    }

    @NotNull
    public Collection<String> getVariantNames() {
        Set<String> set = this.myVariantsByName.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaAndroidProject", "getVariantNames"));
        }
        return set;
    }

    @Nullable
    public LanguageLevel getJavaLanguageLevel() {
        JavaCompileOptions compileOptions = this.myDelegate.getJavaCompileOptions();
        String sourceCompatibility = compileOptions.getSourceCompatibility();
        return LanguageLevel.parse((String)sourceCompatibility);
    }

    @NotNull
    public String computePackageName() {
        String string = this.getSelectedVariant().getMainArtifact().getApplicationId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaAndroidProject", "computePackageName"));
        }
        return string;
    }

    public boolean isLibrary() {
        return this.getDelegate().isLibrary();
    }

    public boolean overridesManifestPackage() {
        if (this.myOverridesManifestPackage == null) {
            this.myOverridesManifestPackage = this.getDelegate().getDefaultConfig().getProductFlavor().getApplicationId() != null;
            Variant variant = this.getSelectedVariant();
            List flavors = variant.getProductFlavors();
            for (String flavor : flavors) {
                ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
                assert (productFlavor != null);
                if (productFlavor.getProductFlavor().getApplicationId() == null) continue;
                this.myOverridesManifestPackage = true;
                break;
            }
        }
        return this.myOverridesManifestPackage;
    }

    @Nullable
    public AndroidVersion getConfigMinSdkVersion() {
        if (this.myMinSdkVersion == null) {
            ApiVersion minSdkVersion = this.getSelectedVariant().getMergedFlavor().getMinSdkVersion();
            if (minSdkVersion != null && minSdkVersion.getCodename() != null) {
                ApiVersion defaultConfigVersion = this.getDelegate().getDefaultConfig().getProductFlavor().getMinSdkVersion();
                if (defaultConfigVersion != null) {
                    minSdkVersion = defaultConfigVersion;
                }
                List flavors = this.getSelectedVariant().getProductFlavors();
                for (String flavor : flavors) {
                    ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
                    assert (productFlavor != null);
                    ApiVersion flavorVersion = productFlavor.getProductFlavor().getMinSdkVersion();
                    if (flavorVersion == null) continue;
                    minSdkVersion = flavorVersion;
                    break;
                }
            }
            this.myMinSdkVersion = minSdkVersion != null ? LintUtils.convertVersion((ApiVersion)minSdkVersion, null) : NOT_SPECIFIED;
        }
        return this.myMinSdkVersion != NOT_SPECIFIED ? this.myMinSdkVersion : null;
    }

    public void registerExtraGeneratedSourceFolder(@NotNull File folderPath) {
        if (folderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderPath", "com/android/tools/idea/gradle/IdeaAndroidProject", "registerExtraGeneratedSourceFolder"));
        }
        this.myExtraGeneratedSourceFolders.add(folderPath);
    }

    public boolean shouldManuallyExclude(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/IdeaAndroidProject", "shouldManuallyExclude"));
        }
        if (!path.isDirectory()) {
            return false;
        }
        String name = path.getName();
        if ("intermediates".equals(name) || ContentRootModuleCustomizer.EXCLUDED_OUTPUT_FOLDER_NAMES.contains(name)) {
            return false;
        }
        boolean hasGeneratedFolders = "generated".equals(name) || this.containsExtraGeneratedSourceFolder(path);
        return !hasGeneratedFolders;
    }

    private boolean containsExtraGeneratedSourceFolder(@NotNull File folderPath) {
        if (folderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderPath", "com/android/tools/idea/gradle/IdeaAndroidProject", "containsExtraGeneratedSourceFolder"));
        }
        if (!folderPath.isDirectory()) {
            return false;
        }
        for (File generatedSourceFolder : this.myExtraGeneratedSourceFolders) {
            if (!FileUtil.isAncestor((File)folderPath, (File)generatedSourceFolder, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public File[] getExtraGeneratedSourceFolders() {
        File[] fileArray = this.myExtraGeneratedSourceFolders.toArray(new File[this.myExtraGeneratedSourceFolders.size()]);
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaAndroidProject", "getExtraGeneratedSourceFolders"));
        }
        return fileArray;
    }

    @Nullable
    public Collection<SyncIssue> getSyncIssues() {
        if (this.supportsIssueReporting()) {
            return this.myDelegate.getSyncIssues();
        }
        return null;
    }

    private boolean supportsIssueReporting() {
        FullRevision modelVersion;
        String original = this.myDelegate.getModelVersion();
        try {
            modelVersion = FullRevision.parseRevision((String)original);
        }
        catch (NumberFormatException e) {
            Logger.getInstance(IdeaAndroidProject.class).warn("Failed to parse '" + original + "'", (Throwable)e);
            return false;
        }
        return modelVersion.compareTo(FullRevision.parseRevision((String)"1.1.0")) >= 0;
    }

    @Nullable
    public SourceFileContainerInfo containsSourceFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/IdeaAndroidProject", "containsSourceFile"));
        }
        ProductFlavorContainer defaultConfig = this.myDelegate.getDefaultConfig();
        if (IdeaAndroidProject.containsSourceFile(defaultConfig, file)) {
            return new SourceFileContainerInfo();
        }
        for (Variant variant : this.myDelegate.getVariants()) {
            AndroidArtifact artifact = variant.getMainArtifact();
            if (IdeaAndroidProject.containsSourceFile((BaseArtifact)artifact, file)) {
                return new SourceFileContainerInfo(variant, (BaseArtifact)artifact);
            }
            for (AndroidArtifact extraArtifact : variant.getExtraAndroidArtifacts()) {
                if (!IdeaAndroidProject.containsSourceFile((BaseArtifact)extraArtifact, file)) continue;
                return new SourceFileContainerInfo(variant, (BaseArtifact)extraArtifact);
            }
            String buildTypeName = variant.getBuildType();
            BuildTypeContainer buildTypeContainer = this.findBuildType(buildTypeName);
            if (buildTypeContainer != null) {
                if (IdeaAndroidProject.containsFile(buildTypeContainer.getSourceProvider(), file)) {
                    return new SourceFileContainerInfo(variant);
                }
                for (SourceProviderContainer extraSourceProvider : buildTypeContainer.getExtraSourceProviders()) {
                    if (!IdeaAndroidProject.containsFile(extraSourceProvider.getSourceProvider(), file)) continue;
                    return new SourceFileContainerInfo(variant);
                }
            }
            for (String flavorName : variant.getProductFlavors()) {
                ProductFlavorContainer flavor = this.findProductFlavor(flavorName);
                if (flavor == null || !IdeaAndroidProject.containsSourceFile(flavor, file)) continue;
                return new SourceFileContainerInfo(variant);
            }
        }
        return null;
    }

    private static boolean containsSourceFile(@NotNull ProductFlavorContainer flavorContainer, @NotNull File file) {
        if (flavorContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavorContainer", "com/android/tools/idea/gradle/IdeaAndroidProject", "containsSourceFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/IdeaAndroidProject", "containsSourceFile"));
        }
        if (IdeaAndroidProject.containsFile(flavorContainer.getSourceProvider(), file)) {
            return true;
        }
        for (SourceProviderContainer extraSourceProvider : flavorContainer.getExtraSourceProviders()) {
            if (!IdeaAndroidProject.containsFile(extraSourceProvider.getSourceProvider(), file)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSourceFile(@NotNull BaseArtifact artifact, @NotNull File file) {
        AndroidArtifact android;
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/IdeaAndroidProject", "containsSourceFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/IdeaAndroidProject", "containsSourceFile"));
        }
        if (artifact instanceof AndroidArtifact && (IdeaAndroidProject.containsFile((android = (AndroidArtifact)artifact).getGeneratedSourceFolders(), file) || IdeaAndroidProject.containsFile(android.getGeneratedResourceFolders(), file))) {
            return true;
        }
        SourceProvider sourceProvider = artifact.getVariantSourceProvider();
        if (sourceProvider != null && IdeaAndroidProject.containsFile(sourceProvider, file)) {
            return true;
        }
        sourceProvider = artifact.getMultiFlavorSourceProvider();
        return sourceProvider != null && IdeaAndroidProject.containsFile(sourceProvider, file);
    }

    private static boolean containsFile(@NotNull SourceProvider sourceProvider, @NotNull File file) {
        if (sourceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProvider", "com/android/tools/idea/gradle/IdeaAndroidProject", "containsFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/IdeaAndroidProject", "containsFile"));
        }
        return IdeaAndroidProject.containsFile(sourceProvider.getAidlDirectories(), file) || IdeaAndroidProject.containsFile(sourceProvider.getAssetsDirectories(), file) || IdeaAndroidProject.containsFile(sourceProvider.getCDirectories(), file) || IdeaAndroidProject.containsFile(sourceProvider.getCppDirectories(), file) || IdeaAndroidProject.containsFile(sourceProvider.getJavaDirectories(), file) || IdeaAndroidProject.containsFile(sourceProvider.getRenderscriptDirectories(), file) || IdeaAndroidProject.containsFile(sourceProvider.getResDirectories(), file) || IdeaAndroidProject.containsFile(sourceProvider.getResourcesDirectories(), file);
    }

    private static boolean containsFile(@NotNull Collection<File> directories, @NotNull File file) {
        if (directories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "com/android/tools/idea/gradle/IdeaAndroidProject", "containsFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/IdeaAndroidProject", "containsFile"));
        }
        for (File directory : directories) {
            if (!FileUtil.isAncestor((File)directory, (File)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.myProxyDelegateLatch != null) {
            try {
                this.myProxyDelegateLatch.await();
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        out.writeObject(this.myProjectSystemId);
        out.writeObject(this.myModuleName);
        out.writeObject(this.myRootDirPath);
        out.writeObject(this.myProxyDelegate);
        out.writeObject(this.mySelectedVariantName);
        out.writeObject(this.mySelectedTestArtifactName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.myProjectSystemId = (ProjectSystemId)in.readObject();
        this.myModuleName = (String)in.readObject();
        this.myRootDirPath = (File)in.readObject();
        this.myProxyDelegate = this.myDelegate = (AndroidProject)in.readObject();
        this.myBuildTypesByName = Maps.newHashMap();
        this.myProductFlavorsByName = Maps.newHashMap();
        this.myVariantsByName = Maps.newHashMap();
        this.myExtraGeneratedSourceFolders = Sets.newHashSet();
        this.populateBuildTypesByName();
        this.populateProductFlavorsByName();
        this.populateVariantsByName();
        this.setSelectedVariantName((String)in.readObject());
        this.setSelectedTestArtifactName((String)in.readObject());
    }

    public static class SourceFileContainerInfo {
        @Nullable
        public final Variant variant;
        @Nullable
        public final BaseArtifact artifact;

        SourceFileContainerInfo() {
            this(null);
        }

        SourceFileContainerInfo(@Nullable Variant variant) {
            this(variant, null);
        }

        SourceFileContainerInfo(@Nullable Variant variant, @Nullable BaseArtifact artifact) {
            this.variant = variant;
            this.artifact = artifact;
        }

        public void updateSelectedVariantIn(@NotNull DataNode<ModuleData> moduleNode) {
            DataNode androidProjectNode;
            if (moduleNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleNode", "com/android/tools/idea/gradle/IdeaAndroidProject$SourceFileContainerInfo", "updateSelectedVariantIn"));
            }
            if (this.variant != null && (androidProjectNode = ExternalSystemApiUtil.find(moduleNode, AndroidProjectKeys.IDE_ANDROID_PROJECT)) != null) {
                ((IdeaAndroidProject)androidProjectNode.getData()).setSelectedVariantName(this.variant.getName());
            }
        }
    }
}

