/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.capture;

import com.android.tools.idea.profiling.capture.CaptureType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureTypeService {
    ExtensionPointName<CaptureType> EP_NAME = ExtensionPointName.create((String)"com.android.captureType");

    @NotNull
    public static CaptureTypeService getInstance() {
        CaptureTypeService captureTypeService = (CaptureTypeService)ServiceManager.getService(CaptureTypeService.class);
        if (captureTypeService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureTypeService", "getInstance"));
        }
        return captureTypeService;
    }

    @NotNull
    public CaptureType[] getCaptureTypes() {
        CaptureType[] captureTypeArray = (CaptureType[])this.EP_NAME.getExtensions();
        if (captureTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureTypeService", "getCaptureTypes"));
        }
        return captureTypeArray;
    }

    @Nullable
    public <T extends CaptureType> T getType(Class<T> type) {
        return (T)((CaptureType)this.EP_NAME.findExtension(type));
    }

    @Nullable
    public CaptureType getTypeFor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/profiling/capture/CaptureTypeService", "getTypeFor"));
        }
        for (CaptureType type : this.getCaptureTypes()) {
            if (!type.isValidCapture(file)) continue;
            return type;
        }
        return null;
    }
}

