/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public class AndroidPlugin
implements ApplicationComponent {
    public static Key<Runnable> EXECUTE_BEFORE_PROJECT_BUILD_IN_GUI_TEST_KEY = Key.create((String)"gui.test.execute.before.build");
    public static Key<Runnable> EXECUTE_BEFORE_PROJECT_SYNC_TASK_IN_GUI_TEST_KEY = Key.create((String)"gui.test.execute.before.sync.task");
    public static Key<String> GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY = Key.create((String)"gui.test.gradle.build.output");
    public static Key<String[]> GRADLE_SYNC_COMMAND_LINE_OPTIONS_KEY = Key.create((String)"gradle.sync.command.line.options");
    private static boolean ourGuiTestingMode;
    private static GuiTestSuiteState ourGuiTestSuiteState;

    @NotNull
    public String getComponentName() {
        if ("AndroidApplicationComponent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidPlugin", "getComponentName"));
        }
        return "AndroidApplicationComponent";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public static boolean isGuiTestingMode() {
        return ourGuiTestingMode;
    }

    public static void setGuiTestingMode(boolean guiTestingMode) {
        ourGuiTestingMode = guiTestingMode;
        ourGuiTestSuiteState = ourGuiTestingMode ? new GuiTestSuiteState() : null;
    }

    @NotNull
    public static GuiTestSuiteState getGuiTestSuiteState() {
        if (!ourGuiTestingMode) {
            throw new UnsupportedOperationException("The method 'getGuiTestSuiteState' can only be invoked when running UI tests");
        }
        GuiTestSuiteState guiTestSuiteState = ourGuiTestSuiteState;
        if (guiTestSuiteState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidPlugin", "getGuiTestSuiteState"));
        }
        return guiTestSuiteState;
    }

    public static class GuiTestSuiteState {
        private boolean myOpenProjectWizardAlreadyTested;
        private boolean myImportProjectWizardAlreadyTested;
        private boolean mySkipSdkMerge;
        private boolean myUseCachedGradleModelOnly;

        public boolean isOpenProjectWizardAlreadyTested() {
            return this.myOpenProjectWizardAlreadyTested;
        }

        public void setOpenProjectWizardAlreadyTested(boolean openProjectWizardAlreadyTested) {
            this.myOpenProjectWizardAlreadyTested = openProjectWizardAlreadyTested;
        }

        public boolean isImportProjectWizardAlreadyTested() {
            return this.myImportProjectWizardAlreadyTested;
        }

        public void setImportProjectWizardAlreadyTested(boolean importProjectWizardAlreadyTested) {
            this.myImportProjectWizardAlreadyTested = importProjectWizardAlreadyTested;
        }

        public boolean isSkipSdkMerge() {
            return this.mySkipSdkMerge;
        }

        public void setSkipSdkMerge(boolean skipSdkMerge) {
            this.mySkipSdkMerge = skipSdkMerge;
        }

        public boolean syncWithCachedModelOnly() {
            return this.myUseCachedGradleModelOnly;
        }

        public void setUseCachedGradleModelOnly(boolean useCachedGradleModelOnly) {
            this.myUseCachedGradleModelOnly = useCachedGradleModelOnly;
        }
    }
}

