/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateDTDAction
extends BaseCodeInsightAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.GenerateDTDAction");

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        CodeInsightActionHandler codeInsightActionHandler = new CodeInsightActionHandler(){

            public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/GenerateDTDAction$1", "invoke"));
                }
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/actions/GenerateDTDAction$1", "invoke"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/GenerateDTDAction$1", "invoke"));
                }
                XmlDocument document = GenerateDTDAction.findSuitableXmlDocument(file);
                if (document != null) {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("<!DOCTYPE " + document.getRootTag().getName() + " [\n");
                    buffer.append(XmlUtil.generateDocumentDTD(document, true));
                    buffer.append("]>\n");
                    try {
                        XmlProlog prolog = document.getProlog();
                        PsiElement childOfType = PsiTreeUtil.getChildOfType((PsiElement)prolog, XmlProcessingInstruction.class);
                        if (childOfType != null) {
                            String text = childOfType.getText();
                            buffer.insert(0, text);
                            PsiElement nextSibling = childOfType.getNextSibling();
                            if (nextSibling instanceof PsiWhiteSpace) {
                                buffer.insert(text.length(), nextSibling.getText());
                            }
                        }
                        XmlFile tempFile2 = (XmlFile)PsiFileFactory.getInstance((Project)file.getProject()).createFileFromText("dummy.xml", buffer.toString());
                        prolog.replace((PsiElement)tempFile2.getDocument().getProlog());
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }

            public boolean startInWriteAction() {
                return true;
            }
        };
        if (codeInsightActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/GenerateDTDAction", "getHandler"));
        }
        return codeInsightActionHandler;
    }

    @Nullable
    private static XmlDocument findSuitableXmlDocument(@Nullable PsiFile psiFile) {
        XmlDocument document;
        if (psiFile instanceof XmlFile && (document = ((XmlFile)psiFile).getDocument()) != null && document.getRootTag() != null) {
            return document;
        }
        return null;
    }

    @Override
    public void update(AnActionEvent event) {
        super.update(event);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            Presentation presentation = event.getPresentation();
            presentation.setVisible(presentation.isEnabled());
        }
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/GenerateDTDAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/actions/GenerateDTDAction", "isValidForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/GenerateDTDAction", "isValidForFile"));
        }
        return file.getLanguage() == XMLLanguage.INSTANCE && GenerateDTDAction.findSuitableXmlDocument(file) != null;
    }
}

