/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AddVariableInitializerFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddReturnFix");
    private final PsiVariable myVariable;

    public AddVariableInitializerFix(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix", "<init>"));
        }
        this.myVariable = variable;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"quickfix.add.variable.text", (Object[])new Object[]{this.myVariable.getName()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"quickfix.add.variable.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix", "isAvailable"));
        }
        return this.myVariable.isValid() && this.myVariable.getManager().isInProject((PsiElement)this.myVariable) && !this.myVariable.hasInitializer() && !(this.myVariable instanceof PsiParameter);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(this.myVariable.getContainingFile())) {
            return;
        }
        String initializerText = this.suggestInitializer();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myVariable.getProject()).getElementFactory();
        PsiExpression initializer = factory.createExpressionFromText(initializerText, (PsiElement)this.myVariable);
        if (this.myVariable instanceof PsiLocalVariable) {
            ((PsiLocalVariable)this.myVariable).setInitializer(initializer);
        } else if (this.myVariable instanceof PsiField) {
            ((PsiField)this.myVariable).setInitializer(initializer);
        } else {
            LOG.error("Unknown variable type: " + this.myVariable);
        }
        PsiVariable var = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(this.myVariable);
        TextRange range = var.getInitializer().getTextRange();
        int offset = range.getStartOffset();
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
    }

    private String suggestInitializer() {
        PsiType type = this.myVariable.getType();
        return PsiTypesUtil.getDefaultValueOfType((PsiType)type);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

