/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.tagTreeHighlighting;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.tagTreeHighlighting.XmlTagTreeHighlightingPass;
import com.intellij.codeInsight.daemon.impl.tagTreeHighlighting.XmlTagTreeHighlightingUtil;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class XmlTagTreeHighlightingPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    public XmlTagTreeHighlightingPassFactory(Project project, TextEditorHighlightingPassRegistrar registrar) {
        super(project);
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{4}, null, false, -1);
    }

    @Override
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeHighlightingPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeHighlightingPassFactory", "createHighlightingPass"));
        }
        if (editor.isOneLineMode()) {
            return null;
        }
        if (!XmlTagTreeHighlightingUtil.isTagTreeHighlightingActive(file)) {
            return null;
        }
        if (!(editor instanceof EditorEx)) {
            return null;
        }
        return new XmlTagTreeHighlightingPass(file, (EditorEx)editor);
    }
}

