/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.util.IncorrectOperationException;

public class CatchDeclarationFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof PsiCatchSection) {
            Document doc = editor.getDocument();
            PsiCatchSection catchSection = (PsiCatchSection)psiElement;
            int catchStart = catchSection.getTextRange().getStartOffset();
            int stopOffset = doc.getLineEndOffset(doc.getLineNumber(catchStart));
            PsiCodeBlock catchBlock = catchSection.getCatchBlock();
            if (catchBlock != null) {
                stopOffset = Math.min(stopOffset, catchBlock.getTextRange().getStartOffset());
            }
            stopOffset = Math.min(stopOffset, catchSection.getTextRange().getEndOffset());
            PsiJavaToken lParenth = catchSection.getLParenth();
            if (lParenth == null) {
                doc.replaceString(catchStart, stopOffset, (CharSequence)"catch ()");
                processor2.registerUnresolvedError(catchStart + "catch (".length());
            } else {
                if (catchSection.getParameter() == null) {
                    processor2.registerUnresolvedError(lParenth.getTextRange().getEndOffset());
                }
                if (catchSection.getRParenth() == null) {
                    doc.insertString(stopOffset, (CharSequence)")");
                }
            }
        }
    }
}

